/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_20_R1.block;

import com.google.common.base.Preconditions;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_8172;
import org.bukkit.Material;
import org.bukkit.Tag;
import org.bukkit.World;
import org.bukkit.block.DecoratedPot;
import org.bukkit.craftbukkit.v1_20_R1.block.CraftBlockEntityState;
import org.bukkit.craftbukkit.v1_20_R1.util.CraftMagicNumbers;

public class CraftDecoratedPot
extends CraftBlockEntityState<class_8172>
implements DecoratedPot {
    public CraftDecoratedPot(World world, class_8172 tileEntity) {
        super(world, tileEntity);
    }

    @Override
    public void setSherd(DecoratedPot.Side face, Material sherd) {
        Preconditions.checkArgument((face != null ? 1 : 0) != 0, (Object)"face must not be null");
        Preconditions.checkArgument((sherd == null || sherd == Material.BRICK || Tag.ITEMS_DECORATED_POT_SHERDS.isTagged(sherd) ? 1 : 0) != 0, (String)"sherd is not a valid sherd material: %s", (Object)sherd);
        class_1792 sherdItem = sherd != null ? CraftMagicNumbers.getItem(sherd) : class_1802.field_8621;
        class_8172.class_8526 decorations = ((class_8172)this.getSnapshot()).method_51511();
        switch (face) {
            case BACK: {
                ((class_8172)this.getSnapshot()).field_44706 = new class_8172.class_8526(sherdItem, decorations.comp_1488(), decorations.comp_1489(), decorations.comp_1490());
                break;
            }
            case LEFT: {
                ((class_8172)this.getSnapshot()).field_44706 = new class_8172.class_8526(decorations.comp_1487(), sherdItem, decorations.comp_1489(), decorations.comp_1490());
                break;
            }
            case RIGHT: {
                ((class_8172)this.getSnapshot()).field_44706 = new class_8172.class_8526(decorations.comp_1487(), decorations.comp_1488(), sherdItem, decorations.comp_1490());
                break;
            }
            case FRONT: {
                ((class_8172)this.getSnapshot()).field_44706 = new class_8172.class_8526(decorations.comp_1487(), decorations.comp_1488(), decorations.comp_1489(), sherdItem);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected value: " + face);
            }
        }
    }

    @Override
    public Material getSherd(DecoratedPot.Side face) {
        Preconditions.checkArgument((face != null ? 1 : 0) != 0, (Object)"face must not be null");
        class_8172.class_8526 decorations = ((class_8172)this.getSnapshot()).method_51511();
        class_1792 sherdItem = switch (face) {
            case DecoratedPot.Side.BACK -> decorations.comp_1487();
            case DecoratedPot.Side.LEFT -> decorations.comp_1488();
            case DecoratedPot.Side.RIGHT -> decorations.comp_1489();
            case DecoratedPot.Side.FRONT -> decorations.comp_1490();
            default -> throw new IllegalArgumentException("Unexpected value: " + face);
        };
        return CraftMagicNumbers.getMaterial(sherdItem);
    }

    @Override
    public Map<DecoratedPot.Side, Material> getSherds() {
        class_8172.class_8526 decorations = ((class_8172)this.getSnapshot()).method_51511();
        EnumMap<DecoratedPot.Side, Material> sherds = new EnumMap<DecoratedPot.Side, Material>(DecoratedPot.Side.class);
        sherds.put(DecoratedPot.Side.BACK, CraftMagicNumbers.getMaterial(decorations.comp_1487()));
        sherds.put(DecoratedPot.Side.LEFT, CraftMagicNumbers.getMaterial(decorations.comp_1488()));
        sherds.put(DecoratedPot.Side.RIGHT, CraftMagicNumbers.getMaterial(decorations.comp_1489()));
        sherds.put(DecoratedPot.Side.FRONT, CraftMagicNumbers.getMaterial(decorations.comp_1490()));
        return sherds;
    }

    @Override
    public List<Material> getShards() {
        return ((class_8172)this.getSnapshot()).method_51511().method_51512().map(CraftMagicNumbers::getMaterial).collect(Collectors.toUnmodifiableList());
    }
}

