/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_20_R1.entity;

import com.google.common.base.Preconditions;
import net.minecraft.class_1297;
import net.minecraft.class_1536;
import net.minecraft.class_1676;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import org.bukkit.craftbukkit.v1_20_R1.CraftServer;
import org.bukkit.craftbukkit.v1_20_R1.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_20_R1.entity.CraftProjectile;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.FishHook;

public class CraftFishHook
extends CraftProjectile
implements FishHook {
    private double biteChance = -1.0;

    public CraftFishHook(CraftServer server, class_1536 entity) {
        super(server, (class_1676)entity);
    }

    public class_1536 getHandle() {
        return (class_1536)this.entity;
    }

    @Override
    public String toString() {
        return "CraftFishingHook";
    }

    @Override
    public EntityType getType() {
        return EntityType.FISHING_HOOK;
    }

    @Override
    public int getMinWaitTime() {
        return this.getHandle().bridge$minWaitTime();
    }

    @Override
    public void setMinWaitTime(int minWaitTime) {
        Preconditions.checkArgument((minWaitTime >= 0 && minWaitTime <= this.getMaxWaitTime() ? 1 : 0) != 0, (String)"The minimum wait time should be between %s and %s (the maximum wait time)", (int)0, (int)this.getMaxWaitTime());
        class_1536 hook = this.getHandle();
        hook.banner$setMinWaitTime(minWaitTime);
    }

    @Override
    public int getMaxWaitTime() {
        return this.getHandle().bridge$maxWaitTime();
    }

    @Override
    public void setMaxWaitTime(int maxWaitTime) {
        Preconditions.checkArgument((maxWaitTime >= 0 && maxWaitTime >= this.getMinWaitTime() ? 1 : 0) != 0, (String)"The maximum wait time should be between %s and %s (the minimum wait time)", (int)0, (int)this.getMinWaitTime());
        class_1536 hook = this.getHandle();
        hook.banner$setMaxWaitTime(maxWaitTime);
    }

    @Override
    public void setWaitTime(int min, int max) {
        Preconditions.checkArgument((min >= 0 && max >= 0 && min <= max ? 1 : 0) != 0, (Object)"The minimum/maximum wait time should be higher than or equal to 0 and the minimum wait time");
        this.getHandle().banner$setMinWaitTime(min);
        this.getHandle().banner$setMaxWaitTime(max);
    }

    @Override
    public int getMinLureTime() {
        return this.getHandle().bridge$minLureTime();
    }

    @Override
    public void setMinLureTime(int minLureTime) {
        Preconditions.checkArgument((minLureTime >= 0 && minLureTime <= this.getMaxLureTime() ? 1 : 0) != 0, (String)"The minimum lure time (%s) should be between 0 and %s (the maximum wait time)", (int)minLureTime, (int)this.getMaxLureTime());
        this.getHandle().banner$setMinLureTime(minLureTime);
    }

    @Override
    public int getMaxLureTime() {
        return this.getHandle().bridge$maxLureTime();
    }

    @Override
    public void setMaxLureTime(int maxLureTime) {
        Preconditions.checkArgument((maxLureTime >= 0 && maxLureTime >= this.getMinLureTime() ? 1 : 0) != 0, (String)"The maximum lure time (%s) should be higher than or equal to 0 and %s (the minimum wait time)", (int)maxLureTime, (int)this.getMinLureTime());
        this.getHandle().banner$setMaxLureTime(maxLureTime);
    }

    @Override
    public void setLureTime(int min, int max) {
        Preconditions.checkArgument((min >= 0 && max >= 0 && min <= max ? 1 : 0) != 0, (Object)"The minimum/maximum lure time should be higher than or equal to 0 and the minimum wait time.");
        this.getHandle().banner$setMinLureTime(min);
        this.getHandle().banner$setMaxLureTime(max);
    }

    @Override
    public float getMinLureAngle() {
        return this.getHandle().bridge$minLureAngle();
    }

    @Override
    public void setMinLureAngle(float minLureAngle) {
        Preconditions.checkArgument((minLureAngle <= this.getMaxLureAngle() ? 1 : 0) != 0, (String)"The minimum lure angle (%s) should be less than %s (the maximum lure angle)", (Object)Float.valueOf(minLureAngle), (Object)Float.valueOf(this.getMaxLureAngle()));
        this.getHandle().banner$setMinLureAnglee(minLureAngle);
    }

    @Override
    public float getMaxLureAngle() {
        return this.getHandle().bridge$maxLureAngle();
    }

    @Override
    public void setMaxLureAngle(float maxLureAngle) {
        Preconditions.checkArgument((maxLureAngle >= this.getMinLureAngle() ? 1 : 0) != 0, (String)"The minimum lure angle (%s) should be less than %s (the maximum lure angle)", (Object)Float.valueOf(maxLureAngle), (Object)Float.valueOf(this.getMinLureAngle()));
        this.getHandle().banner$setMaxLureAnglee(maxLureAngle);
    }

    @Override
    public void setLureAngle(float min, float max) {
        Preconditions.checkArgument((min <= max ? 1 : 0) != 0, (String)"The minimum lure (%s) angle should be less than the maximum lure angle (%s)", (Object)Float.valueOf(min), (Object)Float.valueOf(max));
        this.getHandle().banner$setMinLureAnglee(min);
        this.getHandle().banner$setMaxLureAnglee(max);
    }

    @Override
    public boolean isSkyInfluenced() {
        return this.getHandle().bridge$skyInfluenced();
    }

    @Override
    public void setSkyInfluenced(boolean skyInfluenced) {
        this.getHandle().banner$setSkyInfluenced(skyInfluenced);
    }

    @Override
    public boolean isRainInfluenced() {
        return this.getHandle().bridge$rainInfluenced();
    }

    @Override
    public void setRainInfluenced(boolean rainInfluenced) {
        this.getHandle().banner$setRainInfluenced(rainInfluenced);
    }

    @Override
    public boolean getApplyLure() {
        return this.getHandle().bridge$applyLure();
    }

    @Override
    public void setApplyLure(boolean applyLure) {
        this.getHandle().banner$setApplyLure(applyLure);
    }

    @Override
    public double getBiteChance() {
        class_1536 hook = this.getHandle();
        if (this.biteChance == -1.0) {
            if (hook.method_37908().method_8520(class_2338.method_49638((class_2374)hook.method_19538()).method_10069(0, 1, 0))) {
                return 0.0033333333333333335;
            }
            return 0.002;
        }
        return this.biteChance;
    }

    @Override
    public void setBiteChance(double chance) {
        Preconditions.checkArgument((chance >= 0.0 && chance <= 1.0 ? 1 : 0) != 0, (Object)"The bite chance must be between 0 and 1");
        this.biteChance = chance;
    }

    @Override
    public boolean isInOpenWater() {
        return this.getHandle().field_23233 < 10 && this.getHandle().method_26086(this.getHandle().method_24515());
    }

    @Override
    public Entity getHookedEntity() {
        class_1297 hooked = this.getHandle().field_7165;
        return hooked != null ? hooked.getBukkitEntity() : null;
    }

    @Override
    public void setHookedEntity(Entity entity) {
        class_1536 hook = this.getHandle();
        hook.field_7165 = entity != null ? ((CraftEntity)entity).getHandle() : null;
        hook.method_5841().method_12778(class_1536.field_7170, (Object)(hook.field_7165 != null ? hook.field_7165.method_5628() + 1 : 0));
    }

    @Override
    public boolean pullHookedEntity() {
        class_1536 hook = this.getHandle();
        if (hook.field_7165 == null) {
            return false;
        }
        hook.method_6954(hook.field_7165);
        return true;
    }

    @Override
    public FishHook.HookState getState() {
        return FishHook.HookState.values()[this.getHandle().field_7175.ordinal()];
    }
}

