/*
 * Decompiled with CFR 0.152.
 */
package com.mohistmc.banner.config;

import com.mohistmc.banner.config.BannerConfig;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.configuration.file.YamlConfiguration;

public class BannerWorldConfig {
    private final String worldName;
    private final YamlConfiguration config;
    private boolean verbose;
    public boolean disableEndCredits;
    public boolean disableChestCatDetection;
    public boolean piglinsGuardChests;
    public boolean zombiesTargetTurtleEggs;
    public boolean disableTeleportationSuffocationCheck;
    public int bambooHeightMax;
    public int cactusHeight;
    public int reedHeight;

    public BannerWorldConfig(String worldName) {
        this.worldName = worldName;
        this.config = BannerConfig.config;
        this.init();
    }

    public void init() {
        this.verbose = this.getBoolean("verbose", false);
        this.log("-------- World Settings For [" + this.worldName + "] --------");
        BannerConfig.readConfig(BannerWorldConfig.class, this);
    }

    private void log(String s) {
        if (this.verbose) {
            Bukkit.getLogger().info(s);
        }
    }

    private void set(String path, Object val) {
        this.config.set("world-settings.default." + path, val);
    }

    private boolean getBoolean(String path, boolean def) {
        this.config.addDefault("world-settings.default." + path, def);
        return this.config.getBoolean("world-settings." + this.worldName + "." + path, this.config.getBoolean("world-settings.default." + path));
    }

    private double getDouble(String path, double def) {
        this.config.addDefault("world-settings.default." + path, def);
        return this.config.getDouble("world-settings." + this.worldName + "." + path, this.config.getDouble("world-settings.default." + path));
    }

    private int getInt(String path) {
        return this.config.getInt("world-settings." + this.worldName + "." + path);
    }

    private int getInt(String path, int def) {
        this.config.addDefault("world-settings.default." + path, def);
        return this.config.getInt("world-settings." + this.worldName + "." + path, this.config.getInt("world-settings.default." + path));
    }

    private <T> List getList(String path, T def) {
        this.config.addDefault("world-settings.default." + path, def);
        return this.config.getList("world-settings." + this.worldName + "." + path, this.config.getList("world-settings.default." + path));
    }

    private String getString(String path, String def) {
        this.config.addDefault("world-settings.default." + path, def);
        return this.config.getString("world-settings." + this.worldName + "." + path, this.config.getString("world-settings.default." + path));
    }

    private Object get(String path, Object def) {
        this.config.addDefault("world-settings.default." + path, def);
        return this.config.get("world-settings." + this.worldName + "." + path, this.config.get("world-settings.default." + path));
    }

    private void endCredits() {
        this.disableEndCredits = this.getBoolean("game-mechanics.disable-end-credits", false);
        this.log("End credits disabled: " + this.disableEndCredits);
    }

    private void animalBehaviours() {
        this.disableChestCatDetection = this.getBoolean("entities.behavior.disableChestCatDetection", false);
        this.piglinsGuardChests = this.getBoolean("entities.behavior.piglinsGuardChests", true);
        this.zombiesTargetTurtleEggs = this.getBoolean("entities.behavior.zombiesTargetTurtleEggs", true);
    }

    private void environment() {
        this.disableTeleportationSuffocationCheck = this.getBoolean("environment.disableTeleportationSuffocationCheck", false);
    }

    public void maxGrowthHeight() {
        this.bambooHeightMax = this.getInt("maxGrowthHeight.bamboo.max", 16);
        this.cactusHeight = this.getInt("maxGrowthHeight.cactus", 3);
        this.reedHeight = this.getInt("maxGrowthHeight.reeds", 3);
    }
}

