/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_20_R1.block;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1767;
import net.minecraft.class_2185;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2573;
import org.bukkit.DyeColor;
import org.bukkit.World;
import org.bukkit.block.Banner;
import org.bukkit.block.banner.Pattern;
import org.bukkit.block.banner.PatternType;
import org.bukkit.craftbukkit.v1_20_R1.block.CraftBlockEntityState;

public class CraftBanner
extends CraftBlockEntityState<class_2573>
implements Banner {
    private DyeColor base;
    private List<Pattern> patterns;

    public CraftBanner(World world, class_2573 tileEntity) {
        super(world, tileEntity);
    }

    @Override
    public void load(class_2573 banner) {
        super.load(banner);
        this.base = DyeColor.getByWoolData((byte)((class_2185)this.data.method_26204()).method_9303().method_7789());
        this.patterns = new ArrayList<Pattern>();
        if (banner.field_11773 != null) {
            for (int i = 0; i < banner.field_11773.size(); ++i) {
                class_2487 p = (class_2487)banner.field_11773.method_10534(i);
                this.patterns.add(new Pattern(DyeColor.getByWoolData((byte)p.method_10550("Color")), PatternType.getByIdentifier(p.method_10558("Pattern"))));
            }
        }
    }

    @Override
    public DyeColor getBaseColor() {
        return this.base;
    }

    @Override
    public void setBaseColor(DyeColor color) {
        Preconditions.checkArgument((color != null ? 1 : 0) != 0, (Object)"color");
        this.base = color;
    }

    @Override
    public List<Pattern> getPatterns() {
        return new ArrayList<Pattern>(this.patterns);
    }

    @Override
    public void setPatterns(List<Pattern> patterns) {
        this.patterns = new ArrayList<Pattern>(patterns);
    }

    @Override
    public void addPattern(Pattern pattern) {
        this.patterns.add(pattern);
    }

    @Override
    public Pattern getPattern(int i) {
        return this.patterns.get(i);
    }

    @Override
    public Pattern removePattern(int i) {
        return this.patterns.remove(i);
    }

    @Override
    public void setPattern(int i, Pattern pattern) {
        this.patterns.set(i, pattern);
    }

    @Override
    public int numberOfPatterns() {
        return this.patterns.size();
    }

    @Override
    public void applyTo(class_2573 banner) {
        super.applyTo(banner);
        banner.field_11774 = class_1767.method_7791((int)this.base.getWoolData());
        class_2499 newPatterns = new class_2499();
        for (Pattern p : this.patterns) {
            class_2487 compound = new class_2487();
            compound.method_10569("Color", (int)p.getColor().getWoolData());
            compound.method_10582("Pattern", p.getPattern().getIdentifier());
            newPatterns.add((Object)compound);
        }
        banner.field_11773 = newPatterns;
    }
}

