/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_20_R1.entity;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_1422;
import net.minecraft.class_1474;
import org.bukkit.DyeColor;
import org.bukkit.craftbukkit.v1_20_R1.CraftServer;
import org.bukkit.craftbukkit.v1_20_R1.entity.CraftFish;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.TropicalFish;

public class CraftTropicalFish
extends CraftFish
implements TropicalFish {
    public CraftTropicalFish(CraftServer server, class_1474 entity) {
        super(server, (class_1422)entity);
    }

    public class_1474 getHandle() {
        return (class_1474)this.entity;
    }

    @Override
    public String toString() {
        return "CraftTropicalFish";
    }

    @Override
    public EntityType getType() {
        return EntityType.TROPICAL_FISH;
    }

    @Override
    public DyeColor getPatternColor() {
        return CraftTropicalFish.getPatternColor(this.getHandle().method_47863());
    }

    @Override
    public void setPatternColor(DyeColor color) {
        this.getHandle().method_47865(CraftTropicalFish.getData(color, this.getBodyColor(), this.getPattern()));
    }

    @Override
    public DyeColor getBodyColor() {
        return CraftTropicalFish.getBodyColor(this.getHandle().method_47863());
    }

    @Override
    public void setBodyColor(DyeColor color) {
        this.getHandle().method_47865(CraftTropicalFish.getData(this.getPatternColor(), color, this.getPattern()));
    }

    @Override
    public TropicalFish.Pattern getPattern() {
        return CraftTropicalFish.getPattern(this.getHandle().method_47863());
    }

    @Override
    public void setPattern(TropicalFish.Pattern pattern) {
        this.getHandle().method_47865(CraftTropicalFish.getData(this.getPatternColor(), this.getBodyColor(), pattern));
    }

    public static int getData(DyeColor patternColor, DyeColor bodyColor, TropicalFish.Pattern type) {
        return patternColor.getWoolData() << 24 | bodyColor.getWoolData() << 16 | CraftPattern.values()[type.ordinal()].getDataValue();
    }

    public static DyeColor getPatternColor(int data) {
        return DyeColor.getByWoolData((byte)(data >> 24 & 0xFF));
    }

    public static DyeColor getBodyColor(int data) {
        return DyeColor.getByWoolData((byte)(data >> 16 & 0xFF));
    }

    public static TropicalFish.Pattern getPattern(int data) {
        return CraftPattern.fromData(data & 0xFFFF);
    }

    public static enum CraftPattern {
        KOB(0, false),
        SUNSTREAK(1, false),
        SNOOPER(2, false),
        DASHER(3, false),
        BRINELY(4, false),
        SPOTTY(5, false),
        FLOPPER(0, true),
        STRIPEY(1, true),
        GLITTER(2, true),
        BLOCKFISH(3, true),
        BETTY(4, true),
        CLAYFISH(5, true);

        private final int variant;
        private final boolean large;
        private static final Map<Integer, TropicalFish.Pattern> BY_DATA;

        public static TropicalFish.Pattern fromData(int data) {
            return BY_DATA.get(data);
        }

        private CraftPattern(int variant, boolean large) {
            this.variant = variant;
            this.large = large;
        }

        public int getDataValue() {
            return this.variant << 8 | (this.large ? 1 : 0);
        }

        static {
            BY_DATA = new HashMap<Integer, TropicalFish.Pattern>();
            for (CraftPattern type : CraftPattern.values()) {
                BY_DATA.put(type.getDataValue(), TropicalFish.Pattern.values()[type.ordinal()]);
            }
        }
    }
}

