/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_20_R1.util;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import net.minecraft.class_2483;
import net.minecraft.class_2487;
import net.minecraft.class_2489;
import net.minecraft.class_2497;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2522;

public class CraftNBTTagConfigSerializer {
    private static final Pattern ARRAY = Pattern.compile("^\\[.*]");
    private static final Pattern INTEGER = Pattern.compile("[-+]?(?:0|[1-9][0-9]*)?i", 2);
    private static final Pattern DOUBLE = Pattern.compile("[-+]?(?:[0-9]+[.]?|[0-9]*[.][0-9]+)(?:e[-+]?[0-9]+)?d", 2);
    private static final class_2522 MOJANGSON_PARSER = new class_2522(new StringReader(""));

    public static Object serialize(class_2520 base) {
        if (base instanceof class_2487) {
            HashMap<String, Object> innerMap = new HashMap<String, Object>();
            for (String key : ((class_2487)base).method_10541()) {
                innerMap.put(key, CraftNBTTagConfigSerializer.serialize(((class_2487)base).method_10580(key)));
            }
            return innerMap;
        }
        if (base instanceof class_2499) {
            ArrayList<Object> baseList = new ArrayList<Object>();
            for (int i = 0; i < ((class_2483)base).size(); ++i) {
                baseList.add(CraftNBTTagConfigSerializer.serialize((class_2520)((class_2483)base).get(i)));
            }
            return baseList;
        }
        if (base instanceof class_2519) {
            return base.method_10714();
        }
        if (base instanceof class_2497) {
            return base.toString() + "i";
        }
        return base.toString();
    }

    public static class_2520 deserialize(Object object) {
        if (object instanceof Map) {
            class_2487 compound = new class_2487();
            for (Map.Entry entry : ((Map)object).entrySet()) {
                compound.method_10566((String)entry.getKey(), CraftNBTTagConfigSerializer.deserialize(entry.getValue()));
            }
            return compound;
        }
        if (object instanceof List) {
            List list = (List)object;
            if (list.isEmpty()) {
                return new class_2499();
            }
            class_2499 tagList = new class_2499();
            for (Object tag : list) {
                tagList.add((Object)CraftNBTTagConfigSerializer.deserialize(tag));
            }
            return tagList;
        }
        if (object instanceof String) {
            String string = (String)object;
            if (ARRAY.matcher(string).matches()) {
                try {
                    return new class_2522(new StringReader(string)).method_10726();
                }
                catch (CommandSyntaxException e) {
                    throw new RuntimeException("Could not deserialize found list ", e);
                }
            }
            if (INTEGER.matcher(string).matches()) {
                return class_2497.method_23247((int)Integer.parseInt(string.substring(0, string.length() - 1)));
            }
            if (DOUBLE.matcher(string).matches()) {
                return class_2489.method_23241((double)Double.parseDouble(string.substring(0, string.length() - 1)));
            }
            class_2520 nbtBase = MOJANGSON_PARSER.method_10731(string);
            if (nbtBase instanceof class_2497) {
                return class_2519.method_23256((String)nbtBase.method_10714());
            }
            if (nbtBase instanceof class_2489) {
                return class_2519.method_23256((String)String.valueOf(((class_2489)nbtBase).method_10697()));
            }
            return nbtBase;
        }
        throw new RuntimeException("Could not deserialize Tag");
    }
}

