/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_20_R1;

import com.google.common.base.Preconditions;
import com.mohistmc.banner.bukkit.BukkitExtraConstants;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Random;
import net.minecraft.class_1263;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_169;
import net.minecraft.class_176;
import net.minecraft.class_1799;
import net.minecraft.class_181;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_47;
import net.minecraft.class_52;
import net.minecraft.class_8567;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.World;
import org.bukkit.craftbukkit.v1_20_R1.CraftWorld;
import org.bukkit.craftbukkit.v1_20_R1.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_20_R1.entity.CraftHumanEntity;
import org.bukkit.craftbukkit.v1_20_R1.inventory.CraftInventory;
import org.bukkit.craftbukkit.v1_20_R1.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_20_R1.util.CraftLocation;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.loot.LootContext;
import org.bukkit.loot.LootTable;

public class CraftLootTable
implements LootTable {
    private final class_52 handle;
    private final NamespacedKey key;

    public CraftLootTable(NamespacedKey key, class_52 handle) {
        this.handle = handle;
        this.key = key;
    }

    public class_52 getHandle() {
        return this.handle;
    }

    @Override
    public Collection<ItemStack> populateLoot(Random random, LootContext context) {
        Preconditions.checkArgument((context != null ? 1 : 0) != 0, (Object)"LootContext cannot be null");
        class_8567 nmsContext = this.convertContext(context, random);
        ObjectArrayList nmsItems = this.handle.method_51878(nmsContext);
        ArrayList<ItemStack> bukkit = new ArrayList<ItemStack>(nmsItems.size());
        for (class_1799 item : nmsItems) {
            if (item.method_7960()) continue;
            bukkit.add(CraftItemStack.asBukkitCopy(item));
        }
        return bukkit;
    }

    @Override
    public void fillInventory(Inventory inventory, Random random, LootContext context) {
        Preconditions.checkArgument((inventory != null ? 1 : 0) != 0, (Object)"Inventory cannot be null");
        Preconditions.checkArgument((context != null ? 1 : 0) != 0, (Object)"LootContext cannot be null");
        class_8567 nmsContext = this.convertContext(context, random);
        CraftInventory craftInventory = (CraftInventory)inventory;
        class_1263 handle = craftInventory.getInventory();
        this.getHandle().fillInventory(handle, nmsContext, random.nextLong(), true);
    }

    @Override
    public NamespacedKey getKey() {
        return this.key;
    }

    private class_8567 convertContext(LootContext context, Random random) {
        Preconditions.checkArgument((context != null ? 1 : 0) != 0, (Object)"LootContext cannot be null");
        Location loc = context.getLocation();
        Preconditions.checkArgument((loc.getWorld() != null ? 1 : 0) != 0, (Object)"LootContext.getLocation#getWorld cannot be null");
        class_3218 handle = ((CraftWorld)loc.getWorld()).getHandle();
        class_8567.class_8568 builder = new class_8567.class_8568(handle);
        if (random != null) {
            // empty if block
        }
        this.setMaybe(builder, class_181.field_24424, CraftLocation.toVec3D(loc));
        if (this.getHandle() != class_52.field_948) {
            if (context.getLootedEntity() != null) {
                class_1297 nmsLootedEntity = ((CraftEntity)context.getLootedEntity()).getHandle();
                this.setMaybe(builder, class_181.field_1226, nmsLootedEntity);
                this.setMaybe(builder, class_181.field_1231, handle.method_48963().method_48830());
                this.setMaybe(builder, class_181.field_24424, nmsLootedEntity.method_19538());
            }
            if (context.getKiller() != null) {
                class_1657 nmsKiller = ((CraftHumanEntity)context.getKiller()).getHandle();
                this.setMaybe(builder, class_181.field_1230, nmsKiller);
                this.setMaybe(builder, class_181.field_1231, handle.method_48963().method_48802(nmsKiller));
                this.setMaybe(builder, class_181.field_1233, nmsKiller);
                this.setMaybe(builder, class_181.field_1229, nmsKiller.method_6030());
            }
            if (context.getLootingModifier() != -1) {
                this.setMaybe(builder, BukkitExtraConstants.LOOTING_MOD, context.getLootingModifier());
            }
        }
        class_176.class_177 nmsBuilder = new class_176.class_177();
        for (class_169 param : this.getHandle().method_322().method_778()) {
            nmsBuilder.method_781(param);
        }
        for (class_169 param : this.getHandle().method_322().method_777()) {
            if (this.getHandle().method_322().method_778().contains(param)) continue;
            nmsBuilder.method_780(param);
        }
        nmsBuilder.method_780(BukkitExtraConstants.LOOTING_MOD);
        return builder.method_51875(this.getHandle().method_322());
    }

    private <T> void setMaybe(class_8567.class_8568 builder, class_169<T> param, T value) {
        if (this.getHandle().method_322().method_778().contains(param) || this.getHandle().method_322().method_777().contains(param)) {
            // empty if block
        }
    }

    public static LootContext convertContext(class_47 info) {
        CraftEntity killer;
        class_243 position = (class_243)info.method_296(class_181.field_24424);
        if (position == null) {
            position = ((class_1297)info.method_296(class_181.field_1226)).method_19538();
        }
        Location location = CraftLocation.toBukkit(position, (World)info.method_299().getWorld());
        LootContext.Builder contextBuilder = new LootContext.Builder(location);
        if (info.method_300(class_181.field_1230) && (killer = ((class_1297)info.method_296(class_181.field_1230)).getBukkitEntity()) instanceof CraftHumanEntity) {
            contextBuilder.killer((CraftHumanEntity)killer);
        }
        if (info.method_300(class_181.field_1226)) {
            contextBuilder.lootedEntity(((class_1297)info.method_296(class_181.field_1226)).getBukkitEntity());
        }
        if (info.method_300(BukkitExtraConstants.LOOTING_MOD)) {
            contextBuilder.lootingModifier((Integer)info.method_296(BukkitExtraConstants.LOOTING_MOD));
        }
        contextBuilder.luck(info.method_302());
        return contextBuilder.build();
    }

    public String toString() {
        return this.getKey().toString();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof LootTable)) {
            return false;
        }
        LootTable table = (LootTable)obj;
        return table.getKey().equals(this.getKey());
    }
}

