/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_20_R1.inventory;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import org.bukkit.Material;
import org.bukkit.configuration.serialization.DelegateDeserialization;
import org.bukkit.craftbukkit.v1_20_R1.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_20_R1.inventory.CraftMetaItem;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BundleMeta;

@DelegateDeserialization(value=CraftMetaItem.SerializableMeta.class)
public class CraftMetaBundle
extends CraftMetaItem
implements BundleMeta {
    static final CraftMetaItem.ItemMetaKey ITEMS = new CraftMetaItem.ItemMetaKey("Items", "items");
    private List<ItemStack> items;

    CraftMetaBundle(CraftMetaItem meta) {
        super(meta);
        if (!(meta instanceof CraftMetaBundle)) {
            return;
        }
        CraftMetaBundle bundle = (CraftMetaBundle)meta;
        if (bundle.hasItems()) {
            this.items = new ArrayList<ItemStack>(bundle.items);
        }
    }

    CraftMetaBundle(class_2487 tag) {
        super(tag);
        class_2499 list;
        if (tag.method_10573(CraftMetaBundle.ITEMS.NBT, 9) && (list = tag.method_10554(CraftMetaBundle.ITEMS.NBT, 10)) != null && !list.isEmpty()) {
            this.items = new ArrayList<ItemStack>();
            for (int i = 0; i < list.size(); ++i) {
                class_2487 nbttagcompound1 = list.method_10602(i);
                CraftItemStack itemStack = CraftItemStack.asCraftMirror(class_1799.method_7915((class_2487)nbttagcompound1));
                if (((ItemStack)itemStack).getType().isAir()) continue;
                this.addItem(itemStack);
            }
        }
    }

    CraftMetaBundle(Map<String, Object> map) {
        super(map);
        Iterable items = CraftMetaItem.SerializableMeta.getObject(Iterable.class, map, CraftMetaBundle.ITEMS.BUKKIT, true);
        if (items != null) {
            for (Object stack : items) {
                ItemStack itemStack;
                if (!(stack instanceof ItemStack) || (itemStack = (ItemStack)stack).getType().isAir()) continue;
                this.addItem(itemStack);
            }
        }
    }

    @Override
    void applyToItem(class_2487 tag) {
        super.applyToItem(tag);
        if (this.hasItems()) {
            class_2499 list = new class_2499();
            for (ItemStack item : this.items) {
                class_2487 saved = new class_2487();
                CraftItemStack.asNMSCopy(item).method_7953(saved);
                list.add((Object)saved);
            }
            tag.method_10566(CraftMetaBundle.ITEMS.NBT, (class_2520)list);
        }
    }

    @Override
    boolean applicableTo(Material type) {
        return type == Material.BUNDLE;
    }

    @Override
    boolean isEmpty() {
        return super.isEmpty() && this.isBundleEmpty();
    }

    boolean isBundleEmpty() {
        return !this.hasItems();
    }

    @Override
    public boolean hasItems() {
        return this.items != null && !this.items.isEmpty();
    }

    @Override
    public List<ItemStack> getItems() {
        return this.items == null ? ImmutableList.of() : ImmutableList.copyOf(this.items);
    }

    @Override
    public void setItems(List<ItemStack> items) {
        this.items = null;
        if (items == null) {
            return;
        }
        for (ItemStack i : items) {
            this.addItem(i);
        }
    }

    @Override
    public void addItem(ItemStack item) {
        Preconditions.checkArgument((item != null && !item.getType().isAir() ? 1 : 0) != 0, (Object)"item is null or air");
        if (this.items == null) {
            this.items = new ArrayList<ItemStack>();
        }
        this.items.add(item);
    }

    @Override
    boolean equalsCommon(CraftMetaItem meta) {
        if (!super.equalsCommon(meta)) {
            return false;
        }
        if (meta instanceof CraftMetaBundle) {
            CraftMetaBundle that = (CraftMetaBundle)meta;
            return this.hasItems() ? that.hasItems() && this.items.equals(that.items) : !that.hasItems();
        }
        return true;
    }

    @Override
    boolean notUncommon(CraftMetaItem meta) {
        return super.notUncommon(meta) && (meta instanceof CraftMetaBundle || this.isBundleEmpty());
    }

    @Override
    int applyHash() {
        int original;
        int hash = original = super.applyHash();
        if (this.hasItems()) {
            hash = 61 * hash + this.items.hashCode();
        }
        return original != hash ? CraftMetaBundle.class.hashCode() ^ hash : hash;
    }

    @Override
    public CraftMetaBundle clone() {
        return (CraftMetaBundle)super.clone();
    }

    @Override
    ImmutableMap.Builder<String, Object> serialize(ImmutableMap.Builder<String, Object> builder) {
        super.serialize(builder);
        if (this.hasItems()) {
            builder.put((Object)CraftMetaBundle.ITEMS.BUKKIT, this.items);
        }
        return builder;
    }
}

