/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_20_R1.inventory;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1744;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import org.bukkit.Material;
import org.bukkit.configuration.serialization.DelegateDeserialization;
import org.bukkit.craftbukkit.v1_20_R1.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_20_R1.inventory.CraftMetaItem;
import org.bukkit.craftbukkit.v1_20_R1.util.CraftMagicNumbers;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.CrossbowMeta;

@DelegateDeserialization(value=CraftMetaItem.SerializableMeta.class)
public class CraftMetaCrossbow
extends CraftMetaItem
implements CrossbowMeta {
    static final CraftMetaItem.ItemMetaKey CHARGED = new CraftMetaItem.ItemMetaKey("Charged", "charged");
    static final CraftMetaItem.ItemMetaKey CHARGED_PROJECTILES = new CraftMetaItem.ItemMetaKey("ChargedProjectiles", "charged-projectiles");
    private boolean charged;
    private List<ItemStack> chargedProjectiles;

    CraftMetaCrossbow(CraftMetaItem meta) {
        super(meta);
        if (!(meta instanceof CraftMetaCrossbow)) {
            return;
        }
        CraftMetaCrossbow crossbow = (CraftMetaCrossbow)meta;
        this.charged = crossbow.charged;
        if (crossbow.hasChargedProjectiles()) {
            this.chargedProjectiles = new ArrayList<ItemStack>(crossbow.chargedProjectiles);
        }
    }

    CraftMetaCrossbow(class_2487 tag) {
        super(tag);
        class_2499 list;
        this.charged = tag.method_10577(CraftMetaCrossbow.CHARGED.NBT);
        if (tag.method_10573(CraftMetaCrossbow.CHARGED_PROJECTILES.NBT, 9) && (list = tag.method_10554(CraftMetaCrossbow.CHARGED_PROJECTILES.NBT, 10)) != null && !list.isEmpty()) {
            this.chargedProjectiles = new ArrayList<ItemStack>();
            for (int i = 0; i < list.size(); ++i) {
                class_2487 nbttagcompound1 = list.method_10602(i);
                this.chargedProjectiles.add(CraftItemStack.asCraftMirror(class_1799.method_7915((class_2487)nbttagcompound1)));
            }
        }
    }

    CraftMetaCrossbow(Map<String, Object> map) {
        super(map);
        Iterable projectiles;
        Boolean charged = CraftMetaItem.SerializableMeta.getObject(Boolean.class, map, CraftMetaCrossbow.CHARGED.BUKKIT, true);
        if (charged != null) {
            this.charged = charged;
        }
        if ((projectiles = CraftMetaItem.SerializableMeta.getObject(Iterable.class, map, CraftMetaCrossbow.CHARGED_PROJECTILES.BUKKIT, true)) != null) {
            for (Object stack : projectiles) {
                if (!(stack instanceof ItemStack)) continue;
                this.addChargedProjectile((ItemStack)stack);
            }
        }
    }

    @Override
    void applyToItem(class_2487 tag) {
        super.applyToItem(tag);
        tag.method_10556(CraftMetaCrossbow.CHARGED.NBT, this.charged);
        if (this.hasChargedProjectiles()) {
            class_2499 list = new class_2499();
            for (ItemStack item : this.chargedProjectiles) {
                class_2487 saved = new class_2487();
                CraftItemStack.asNMSCopy(item).method_7953(saved);
                list.add((Object)saved);
            }
            tag.method_10566(CraftMetaCrossbow.CHARGED_PROJECTILES.NBT, (class_2520)list);
        }
    }

    @Override
    boolean applicableTo(Material type) {
        return type == Material.CROSSBOW;
    }

    @Override
    boolean isEmpty() {
        return super.isEmpty() && this.isCrossbowEmpty();
    }

    boolean isCrossbowEmpty() {
        return !this.hasChargedProjectiles();
    }

    @Override
    public boolean hasChargedProjectiles() {
        return this.chargedProjectiles != null;
    }

    @Override
    public List<ItemStack> getChargedProjectiles() {
        return this.chargedProjectiles == null ? ImmutableList.of() : ImmutableList.copyOf(this.chargedProjectiles);
    }

    @Override
    public void setChargedProjectiles(List<ItemStack> projectiles) {
        this.chargedProjectiles = null;
        this.charged = false;
        if (projectiles == null) {
            return;
        }
        for (ItemStack i : projectiles) {
            this.addChargedProjectile(i);
        }
    }

    @Override
    public void addChargedProjectile(ItemStack item) {
        Preconditions.checkArgument((item != null ? 1 : 0) != 0, (Object)"item");
        Preconditions.checkArgument((item.getType() == Material.FIREWORK_ROCKET || CraftMagicNumbers.getItem(item.getType()) instanceof class_1744 ? 1 : 0) != 0, (String)"Item %s is not an arrow or firework rocket", (Object)item);
        if (this.chargedProjectiles == null) {
            this.chargedProjectiles = new ArrayList<ItemStack>();
        }
        this.charged = true;
        this.chargedProjectiles.add(item);
    }

    @Override
    boolean equalsCommon(CraftMetaItem meta) {
        if (!super.equalsCommon(meta)) {
            return false;
        }
        if (meta instanceof CraftMetaCrossbow) {
            CraftMetaCrossbow that = (CraftMetaCrossbow)meta;
            return this.charged == that.charged && (this.hasChargedProjectiles() ? that.hasChargedProjectiles() && this.chargedProjectiles.equals(that.chargedProjectiles) : !that.hasChargedProjectiles());
        }
        return true;
    }

    @Override
    boolean notUncommon(CraftMetaItem meta) {
        return super.notUncommon(meta) && (meta instanceof CraftMetaCrossbow || this.isCrossbowEmpty());
    }

    @Override
    int applyHash() {
        int original;
        int hash = original = super.applyHash();
        if (this.hasChargedProjectiles()) {
            hash = 61 * hash + (this.charged ? 1 : 0);
            hash = 61 * hash + this.chargedProjectiles.hashCode();
        }
        return original != hash ? CraftMetaCrossbow.class.hashCode() ^ hash : hash;
    }

    @Override
    public CraftMetaCrossbow clone() {
        return (CraftMetaCrossbow)super.clone();
    }

    @Override
    ImmutableMap.Builder<String, Object> serialize(ImmutableMap.Builder<String, Object> builder) {
        super.serialize(builder);
        builder.put((Object)CraftMetaCrossbow.CHARGED.BUKKIT, (Object)this.charged);
        if (this.hasChargedProjectiles()) {
            builder.put((Object)CraftMetaCrossbow.CHARGED_PROJECTILES.BUKKIT, this.chargedProjectiles);
        }
        return builder;
    }
}

