/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_20_R1.structure;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import net.minecraft.class_1299;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2415;
import net.minecraft.class_2470;
import net.minecraft.class_2487;
import net.minecraft.class_3488;
import net.minecraft.class_3491;
import net.minecraft.class_3492;
import net.minecraft.class_3499;
import net.minecraft.class_5425;
import net.minecraft.class_5819;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.RegionAccessor;
import org.bukkit.World;
import org.bukkit.block.structure.Mirror;
import org.bukkit.block.structure.StructureRotation;
import org.bukkit.craftbukkit.v1_20_R1.CraftRegionAccessor;
import org.bukkit.craftbukkit.v1_20_R1.CraftWorld;
import org.bukkit.craftbukkit.v1_20_R1.structure.CraftPalette;
import org.bukkit.craftbukkit.v1_20_R1.util.CraftBlockVector;
import org.bukkit.craftbukkit.v1_20_R1.util.CraftLocation;
import org.bukkit.craftbukkit.v1_20_R1.util.RandomSourceWrapper;
import org.bukkit.entity.Entity;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.structure.Palette;
import org.bukkit.structure.Structure;
import org.bukkit.util.BlockVector;

public class CraftStructure
implements Structure {
    private final class_3499 structure;

    public CraftStructure(class_3499 structure) {
        this.structure = structure;
    }

    @Override
    public void place(Location location, boolean includeEntities, StructureRotation structureRotation, Mirror mirror, int palette, float integrity, Random random) {
        Preconditions.checkArgument((location != null ? 1 : 0) != 0, (Object)"Location cannot be null");
        location.checkFinite();
        World world = location.getWorld();
        Preconditions.checkArgument((world != null ? 1 : 0) != 0, (Object)"The World of Location cannot be null");
        BlockVector blockVector = new BlockVector(location.getBlockX(), location.getBlockY(), location.getBlockZ());
        this.place(world, blockVector, includeEntities, structureRotation, mirror, palette, integrity, random);
    }

    @Override
    public void place(RegionAccessor regionAccessor, BlockVector location, boolean includeEntities, StructureRotation structureRotation, Mirror mirror, int palette, float integrity, Random random) {
        Preconditions.checkArgument((location != null ? 1 : 0) != 0, (Object)"Location cannot be null");
        Preconditions.checkArgument((regionAccessor != null ? 1 : 0) != 0, (Object)"RegionAccessor cannot be null");
        location.checkFinite();
        Preconditions.checkArgument((integrity >= 0.0f && integrity <= 1.0f ? 1 : 0) != 0, (String)"Integrity value (%S) must be between 0 and 1 inclusive", (Object)Float.valueOf(integrity));
        RandomSourceWrapper randomSource = new RandomSourceWrapper(random);
        class_3492 definedstructureinfo = new class_3492().method_15125(class_2415.valueOf((String)mirror.name())).method_15123(class_2470.valueOf((String)structureRotation.name())).method_15133(!includeEntities).method_16184((class_3491)new class_3488(integrity)).method_15112((class_5819)randomSource);
        definedstructureinfo.field_15575 = palette;
        class_2338 blockPosition = CraftBlockVector.toBlockPosition(location);
        this.structure.method_15172((class_5425)((CraftRegionAccessor)regionAccessor).getHandle(), blockPosition, blockPosition, definedstructureinfo, (class_5819)randomSource, 2);
    }

    @Override
    public void fill(Location corner1, Location corner2, boolean includeEntities) {
        Preconditions.checkArgument((corner1 != null ? 1 : 0) != 0, (Object)"Location corner1 cannot be null");
        Preconditions.checkArgument((corner2 != null ? 1 : 0) != 0, (Object)"Location corner2 cannot be null");
        World world = corner1.getWorld();
        Preconditions.checkArgument((world != null ? 1 : 0) != 0, (Object)"World of corner1 Location cannot be null");
        Location origin = new Location(world, Math.min(corner1.getBlockX(), corner2.getBlockX()), Math.min(corner1.getBlockY(), corner2.getBlockY()), Math.min(corner1.getBlockZ(), corner2.getBlockZ()));
        BlockVector size = new BlockVector(Math.abs(corner1.getBlockX() - corner2.getBlockX()), Math.abs(corner1.getBlockY() - corner2.getBlockY()), Math.abs(corner1.getBlockZ() - corner2.getBlockZ()));
        this.fill(origin, size, includeEntities);
    }

    @Override
    public void fill(Location origin, BlockVector size, boolean includeEntities) {
        Preconditions.checkArgument((origin != null ? 1 : 0) != 0, (Object)"Location origin cannot be null");
        World world = origin.getWorld();
        Preconditions.checkArgument((world != null ? 1 : 0) != 0, (Object)"World of Location origin cannot be null");
        Preconditions.checkArgument((size != null ? 1 : 0) != 0, (Object)"BlockVector size cannot be null");
        Preconditions.checkArgument((size.getBlockX() >= 1 && size.getBlockY() >= 1 && size.getBlockZ() >= 1 ? 1 : 0) != 0, (String)"Size must be at least 1x1x1 but was %sx%sx%s", (Object)size.getBlockX(), (Object)size.getBlockY(), (Object)size.getBlockZ());
        this.structure.method_15174((class_1937)((CraftWorld)world).getHandle(), CraftLocation.toBlockPosition(origin), (class_2382)CraftBlockVector.toBlockPosition(size), includeEntities, class_2246.field_10369);
    }

    @Override
    public BlockVector getSize() {
        return CraftBlockVector.toBukkit(this.structure.method_15160());
    }

    @Override
    public List<Entity> getEntities() {
        ArrayList entities = new ArrayList();
        for (class_3499.class_3502 entity : this.structure.field_15589) {
            class_1299.method_5892((class_2487)entity.field_15598, (class_1937)((CraftWorld)Bukkit.getServer().getWorlds().get(0)).getHandle()).ifPresent(dummyEntity -> {
                dummyEntity.method_5814(entity.field_15599.field_1352, entity.field_15599.field_1351, entity.field_15599.field_1350);
                entities.add(dummyEntity.getBukkitEntity());
            });
        }
        return Collections.unmodifiableList(entities);
    }

    @Override
    public int getEntityCount() {
        return this.structure.field_15589.size();
    }

    @Override
    public List<Palette> getPalettes() {
        return this.structure.field_15586.stream().map(CraftPalette::new).collect(Collectors.toList());
    }

    @Override
    public int getPaletteCount() {
        return this.structure.field_15586.size();
    }

    @Override
    public PersistentDataContainer getPersistentDataContainer() {
        return this.getHandle().bridge$persistentDataContainer();
    }

    public class_3499 getHandle() {
        return this.structure;
    }
}

