/*
 * Decompiled with CFR 0.152.
 */
package com.mohistmc.banner.fabric;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.mohistmc.banner.BannerMCStart;
import com.mohistmc.banner.BannerServer;
import com.mohistmc.banner.api.DynamicEnumHelper;
import com.mohistmc.banner.api.ServerAPI;
import com.mohistmc.banner.api.Unsafe;
import com.mohistmc.banner.entity.MohistModsEntity;
import com.mohistmc.banner.type.BannerEnchantment;
import com.mohistmc.banner.type.BannerPotionEffect;
import java.lang.invoke.MethodHandle;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1299;
import net.minecraft.class_1311;
import net.minecraft.class_1527;
import net.minecraft.class_1535;
import net.minecraft.class_1792;
import net.minecraft.class_1842;
import net.minecraft.class_1847;
import net.minecraft.class_1887;
import net.minecraft.class_1959;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3176;
import net.minecraft.class_3448;
import net.minecraft.class_3468;
import net.minecraft.class_3611;
import net.minecraft.class_3852;
import net.minecraft.class_5321;
import net.minecraft.class_5363;
import net.minecraft.class_5712;
import net.minecraft.class_7709;
import net.minecraft.class_7922;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import org.bukkit.Art;
import org.bukkit.Fluid;
import org.bukkit.GameEvent;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.bukkit.Statistic;
import org.bukkit.World;
import org.bukkit.block.Biome;
import org.bukkit.craftbukkit.v1_20_R1.CraftStatistic;
import org.bukkit.craftbukkit.v1_20_R1.inventory.CraftRecipe;
import org.bukkit.craftbukkit.v1_20_R1.potion.CraftPotionUtil;
import org.bukkit.craftbukkit.v1_20_R1.util.CraftMagicNumbers;
import org.bukkit.craftbukkit.v1_20_R1.util.CraftNamespacedKey;
import org.bukkit.craftbukkit.v1_20_R1.util.CraftSpawnCategory;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.EnderDragon;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.SpawnCategory;
import org.bukkit.entity.Villager;
import org.bukkit.inventory.recipe.CookingBookCategory;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.potion.PotionType;

public class BukkitRegistry {
    public static final List<Class<?>> ENV_CTOR = ImmutableList.of(Integer.TYPE);
    public static final Map<Integer, World.Environment> ENVIRONMENT_MAP = (Map)Unsafe.getStatic(World.Environment.class, "lookup");
    public static final BiMap<class_5321<class_5363>, World.Environment> DIM_MAP = HashBiMap.create((Map)ImmutableMap.builder().put((Object)class_5363.field_25412, (Object)World.Environment.NORMAL).put((Object)class_5363.field_25413, (Object)World.Environment.NETHER).put((Object)class_5363.field_25414, (Object)World.Environment.THE_END).build());
    public static final Map<String, Art> ART_BY_NAME = (Map)Unsafe.getStatic(Art.class, "BY_NAME");
    public static final Map<Integer, Art> ART_BY_ID = (Map)Unsafe.getStatic(Art.class, "BY_ID");
    public static final BiMap<class_2960, Statistic> STATS = HashBiMap.create((Map)((Map)Unsafe.getStatic(CraftStatistic.class, "statistics")));
    public static final BiMap<class_3611, Fluid> FLUIDTYPE_FLUID = (BiMap)Unsafe.getStatic(CraftMagicNumbers.class, "FLUIDTYPE_FLUID");
    public static Map<class_3448<?>, Statistic> STATISTIC_MAP = new HashMap();
    public static Map<Villager.Profession, class_2960> PROFESSION = new HashMap<Villager.Profession, class_2960>();
    public static Map<class_1959, Biome> BIOME_MAP = new HashMap<class_1959, Biome>();

    public static void registerAll(class_3176 console) {
        BukkitRegistry.loadItems();
        BukkitRegistry.loadBlocks();
        BukkitRegistry.loadPotions();
        BukkitRegistry.loadEnchantments();
        BukkitRegistry.loadEntities();
        BukkitRegistry.loadVillagerProfessions();
        BukkitRegistry.loadBiomes(console);
        BukkitRegistry.loadArts();
        BukkitRegistry.loadStats();
        BukkitRegistry.loadSpawnCategory();
        BukkitRegistry.loadEndDragonPhase();
        BukkitRegistry.loadCookingBookCategory();
        BukkitRegistry.loadFluids();
        BukkitRegistry.loadGameEvents();
        try {
            for (Field field : Registry.class.getFields()) {
                Object object;
                if (!Modifier.isStatic(field.getModifiers()) || !((object = field.get(null)) instanceof Registry.SimpleRegistry)) continue;
                Registry.SimpleRegistry registry = (Registry.SimpleRegistry)object;
                registry.reloader.run();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void loadItems() {
        class_7922 registry = class_7923.field_41178;
        ArrayList<Material> newTypes = new ArrayList<Material>();
        for (class_1792 item : registry) {
            class_2960 resourceLocation = registry.method_10221((Object)item);
            if (BukkitRegistry.isMINECRAFT(resourceLocation)) continue;
            String materialName = BukkitRegistry.normalizeName(resourceLocation.toString());
            int id = class_1792.method_7880((class_1792)item);
            Material material = Material.addMaterial(materialName, id, false, resourceLocation.method_12836());
            newTypes.add(material);
            if (material == null) continue;
            CraftMagicNumbers.ITEM_MATERIAL.put(item, material);
            CraftMagicNumbers.MATERIAL_ITEM.put(material, item);
            BannerServer.LOGGER.debug("Registered {} as item {}" + material.name() + " - " + materialName);
        }
        BannerServer.LOGGER.info(BannerMCStart.I18N.get("registry.item"), (Object)newTypes.size());
    }

    public static void loadBlocks() {
        class_7922 registry = class_7923.field_41175;
        ArrayList<Material> newTypes = new ArrayList<Material>();
        for (class_2248 block : registry) {
            class_2960 resourceLocation = registry.method_10221((Object)block);
            if (BukkitRegistry.isMINECRAFT(resourceLocation)) continue;
            String materialName = BukkitRegistry.normalizeName(resourceLocation.toString());
            int id = class_1792.method_7880((class_1792)block.method_8389());
            Material material = Material.addMaterial(materialName, id, true, resourceLocation.method_12836());
            newTypes.add(material);
            if (material == null) continue;
            CraftMagicNumbers.BLOCK_MATERIAL.put(block, material);
            CraftMagicNumbers.MATERIAL_BLOCK.put(material, block);
            BannerServer.LOGGER.debug("Registered {} as block {}" + material.name() + " - " + materialName);
        }
        BannerServer.LOGGER.info(BannerMCStart.I18N.get("registry.block"), (Object)newTypes.size());
    }

    private static void loadGameEvents() {
        try {
            Constructor constructor = GameEvent.class.getDeclaredConstructor(NamespacedKey.class);
            constructor.setAccessible(true);
            MethodHandle handle = Unsafe.lookup().unreflectConstructor(constructor);
            for (class_5712 gameEvent : class_7923.field_41171) {
                class_2960 key = class_7923.field_41171.method_10221((Object)gameEvent);
                GameEvent bukkit = GameEvent.getByKey(CraftNamespacedKey.fromMinecraft(key));
                if (bukkit != null) continue;
                bukkit = handle.invoke(CraftNamespacedKey.fromMinecraft(key));
                BannerServer.LOGGER.debug("Registered {} as game event {}", (Object)key, (Object)bukkit);
            }
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    private static void loadFluids() {
        int id = Fluid.values().length;
        ArrayList<Fluid> newTypes = new ArrayList<Fluid>();
        Field keyField = Arrays.stream(Fluid.class.getDeclaredFields()).filter(it -> it.getName().equals("key")).findAny().orElse(null);
        long keyOffset = Unsafe.objectFieldOffset(keyField);
        for (class_3611 fluidType : class_7923.field_41173) {
            if (FLUIDTYPE_FLUID.containsKey((Object)fluidType)) continue;
            class_2960 key = class_7923.field_41173.method_10221((Object)fluidType);
            String name = BukkitRegistry.normalizeName(key.toString());
            Fluid bukkit = DynamicEnumHelper.makeEnum(Fluid.class, name, id++, List.of(), List.of());
            Unsafe.putObject(bukkit, keyOffset, CraftNamespacedKey.fromMinecraft(key));
            newTypes.add(bukkit);
            FLUIDTYPE_FLUID.put((Object)fluidType, (Object)bukkit);
            BannerServer.LOGGER.debug("Registered {} as fluid {}", (Object)key, (Object)bukkit);
        }
        DynamicEnumHelper.addEnums(Fluid.class, newTypes);
    }

    private static void loadCookingBookCategory() {
        int id = class_7709.values().length;
        ArrayList<CookingBookCategory> newTypes = new ArrayList<CookingBookCategory>();
        for (class_7709 category : class_7709.values()) {
            try {
                CraftRecipe.getCategory(category);
            }
            catch (Exception e) {
                String name = category.name();
                CookingBookCategory bukkit = DynamicEnumHelper.makeEnum(CookingBookCategory.class, name, id++, List.of(), List.of());
                newTypes.add(bukkit);
                BannerServer.LOGGER.debug("Registered {} as cooking category {}", (Object)name, (Object)bukkit);
            }
        }
        DynamicEnumHelper.addEnums(CookingBookCategory.class, newTypes);
    }

    private static void loadEndDragonPhase() {
        int max = class_1527.method_6869();
        ArrayList<EnderDragon.Phase> newTypes = new ArrayList<EnderDragon.Phase>();
        for (int id = EnderDragon.Phase.values().length; id < max; ++id) {
            String name = "MOD_PHASE_" + id;
            EnderDragon.Phase newPhase = DynamicEnumHelper.makeEnum(EnderDragon.Phase.class, name, id, List.of(), List.of());
            newTypes.add(newPhase);
            BannerServer.LOGGER.debug("Registered {} as ender dragon phase {}", (Object)name, (Object)newPhase);
        }
        DynamicEnumHelper.addEnums(EnderDragon.Phase.class, newTypes);
    }

    private static void loadSpawnCategory() {
        int id = SpawnCategory.values().length;
        ArrayList<SpawnCategory> newTypes = new ArrayList<SpawnCategory>();
        for (class_1311 category : class_1311.values()) {
            try {
                CraftSpawnCategory.toBukkit(category);
            }
            catch (Exception e) {
                String name = category.name();
                SpawnCategory spawnCategory = DynamicEnumHelper.makeEnum(SpawnCategory.class, name, id++, List.of(), List.of());
                newTypes.add(spawnCategory);
                BannerServer.LOGGER.debug("Registered {} as spawn category {}", (Object)name, (Object)spawnCategory);
            }
        }
        DynamicEnumHelper.addEnums(SpawnCategory.class, newTypes);
    }

    private static void loadStats() {
        int i = Statistic.values().length;
        ArrayList<Statistic> newTypes = new ArrayList<Statistic>();
        Field key = Arrays.stream(Statistic.class.getDeclaredFields()).filter(it -> it.getName().equals("key")).findAny().orElse(null);
        long keyOffset = Unsafe.objectFieldOffset(key);
        for (class_3448 statType : class_7923.field_41193) {
            class_2960 location;
            Statistic statistic;
            if (statType == class_3468.field_15419 || (statistic = (Statistic)STATS.get((Object)(location = class_7923.field_41193.method_10221((Object)statType)))) != null) continue;
            String standardName = BukkitRegistry.normalizeName(location.toString());
            Statistic.Type type = statType.method_14959() == class_7923.field_41177 ? Statistic.Type.ENTITY : (statType.method_14959() == class_7923.field_41175 ? Statistic.Type.BLOCK : (statType.method_14959() == class_7923.field_41178 ? Statistic.Type.ITEM : Statistic.Type.UNTYPED));
            statistic = DynamicEnumHelper.makeEnum(Statistic.class, standardName, i, ImmutableList.of(Statistic.Type.class), (List<Object>)ImmutableList.of((Object)((Object)type)));
            Unsafe.putObject(statistic, keyOffset, location);
            newTypes.add(statistic);
            STATS.put((Object)location, (Object)statistic);
            STATISTIC_MAP.put(statType, statistic);
            BannerServer.LOGGER.debug("Registered {} as stats {}", (Object)location, (Object)statistic);
            ++i;
        }
        for (class_2960 location : class_7923.field_41183) {
            Statistic statistic = (Statistic)STATS.get((Object)location);
            if (statistic != null) continue;
            String standardName = BukkitRegistry.normalizeName(location.toString());
            statistic = DynamicEnumHelper.makeEnum(Statistic.class, standardName, i, ImmutableList.of(), (List<Object>)ImmutableList.of());
            Unsafe.putObject(statistic, keyOffset, location);
            newTypes.add(statistic);
            STATS.put((Object)location, (Object)statistic);
            BannerServer.LOGGER.debug("Registered {} as custom stats {}", (Object)location, (Object)statistic);
            ++i;
        }
        DynamicEnumHelper.addEnums(Statistic.class, newTypes);
        BukkitRegistry.putStatic(CraftStatistic.class, "statistics", STATS);
    }

    private static void loadArts() {
        int i = Art.values().length;
        ArrayList<Art> newTypes = new ArrayList<Art>();
        Field key = Arrays.stream(Art.class.getDeclaredFields()).filter(it -> it.getName().equals("key")).findAny().orElse(null);
        long keyOffset = Unsafe.objectFieldOffset(key);
        for (class_1535 paintingType : class_7923.field_41182) {
            class_2960 location = class_7923.field_41182.method_10221((Object)paintingType);
            String lookupName = location.method_12832().toLowerCase(Locale.ROOT);
            Art bukkit = Art.getByName(lookupName);
            if (bukkit != null) continue;
            String standardName = BukkitRegistry.normalizeName(location.toString());
            bukkit = DynamicEnumHelper.makeEnum(Art.class, standardName, i, ImmutableList.of(Integer.TYPE, Integer.TYPE, Integer.TYPE), (List<Object>)ImmutableList.of((Object)i, (Object)paintingType.method_6945(), (Object)paintingType.method_6943()));
            newTypes.add(bukkit);
            Unsafe.putObject(bukkit, keyOffset, CraftNamespacedKey.fromMinecraft(location));
            ART_BY_ID.put(i, bukkit);
            ART_BY_NAME.put(lookupName, bukkit);
            BannerServer.LOGGER.debug("Registered {} as art {}", (Object)location, (Object)bukkit);
            ++i;
        }
        DynamicEnumHelper.addEnums(Art.class, newTypes);
    }

    private static void loadBiomes(class_3176 console) {
        int i = Biome.values().length;
        ArrayList<Biome> newTypes = new ArrayList<Biome>();
        Field key = Arrays.stream(Biome.class.getDeclaredFields()).filter(it -> it.getName().equals("key")).findAny().orElse(null);
        long keyOffset = Unsafe.objectFieldOffset(key);
        class_2378 registry = console.method_30611().method_30530(class_7924.field_41236);
        for (class_1959 biome : registry) {
            Biome bukkit;
            class_2960 location = registry.method_10221((Object)biome);
            if (BukkitRegistry.isMINECRAFT(location)) continue;
            String name = BukkitRegistry.normalizeName(location.toString());
            try {
                bukkit = Biome.valueOf(name);
            }
            catch (Throwable t) {
                bukkit = null;
            }
            if (bukkit != null) continue;
            bukkit = DynamicEnumHelper.makeEnum(Biome.class, name, i++, ImmutableList.of(), (List<Object>)ImmutableList.of());
            newTypes.add(bukkit);
            Unsafe.putObject(bukkit, keyOffset, CraftNamespacedKey.fromMinecraft(location));
            BannerServer.LOGGER.debug("Registered {} as biome {}", (Object)location, (Object)bukkit);
        }
        DynamicEnumHelper.addEnums(Biome.class, newTypes);
        BannerServer.LOGGER.info(BannerMCStart.I18N.get("registry.biome"), (Object)newTypes.size());
    }

    private static void loadVillagerProfessions() {
        int i = Villager.Profession.values().length;
        ArrayList<Villager.Profession> newTypes = new ArrayList<Villager.Profession>();
        Field key = Arrays.stream(Villager.Profession.class.getDeclaredFields()).filter(it -> it.getName().equals("key")).findAny().orElse(null);
        long keyOffset = Unsafe.objectFieldOffset(key);
        for (class_3852 villagerProfession : class_7923.field_41195) {
            Villager.Profession profession;
            class_2960 location = class_7923.field_41195.method_10221((Object)villagerProfession);
            if (BukkitRegistry.isMINECRAFT(location)) continue;
            String name = BukkitRegistry.normalizeName(location.toString());
            try {
                profession = Villager.Profession.valueOf(name);
            }
            catch (Throwable t) {
                profession = null;
            }
            if (profession == null) {
                profession = DynamicEnumHelper.makeEnum(Villager.Profession.class, name, i++, ImmutableList.of(), (List<Object>)ImmutableList.of());
                newTypes.add(profession);
                Unsafe.putObject(profession, keyOffset, CraftNamespacedKey.fromMinecraft(location));
                BannerServer.LOGGER.debug("Registered {} as villager profession {}", (Object)location, (Object)profession);
            }
            PROFESSION.put(profession, location);
        }
        DynamicEnumHelper.addEnums(Villager.Profession.class, newTypes);
        BannerServer.LOGGER.info(BannerMCStart.I18N.get("registry.villager-profession"), (Object)newTypes.size());
    }

    public static void registerEnvironments(class_2378<class_5363> registry) {
        int i = World.Environment.values().length;
        ArrayList<World.Environment> newTypes = new ArrayList<World.Environment>();
        for (Map.Entry entry : registry.method_29722()) {
            class_5321 key = (class_5321)entry.getKey();
            World.Environment environment = (World.Environment)((Object)DIM_MAP.get((Object)key));
            if (environment != null) continue;
            String name = BukkitRegistry.normalizeName(key.method_29177().toString());
            environment = DynamicEnumHelper.makeEnum(World.Environment.class, name, i, ENV_CTOR, (List<Object>)ImmutableList.of((Object)(i - 1)));
            newTypes.add(environment);
            ENVIRONMENT_MAP.put(i - 1, environment);
            DIM_MAP.put((Object)key, (Object)environment);
            BannerServer.LOGGER.debug("Registered {} as environment {}", (Object)key.method_29177(), (Object)environment);
            ++i;
        }
        DynamicEnumHelper.addEnums(World.Environment.class, newTypes);
        BannerServer.LOGGER.info(BannerMCStart.I18N.get("registry.environment"), (Object)newTypes.size());
    }

    private static void loadEntities() {
        int ordinal = EntityType.values().length;
        ArrayList<EntityType> values = new ArrayList<EntityType>();
        for (class_1299 entry : class_7923.field_41177) {
            class_2960 location = class_7923.field_41177.method_10221((Object)entry);
            String enumName = BukkitRegistry.normalizeName(location.toString());
            ServerAPI.entityTypeMap.put(entry, enumName);
            if (BukkitRegistry.isMINECRAFT(location)) continue;
            int typeId = enumName.hashCode();
            try {
                EntityType bukkitType = DynamicEnumHelper.makeEnum(EntityType.class, enumName, ordinal, List.of(String.class, Class.class, Integer.TYPE, Boolean.TYPE), List.of(enumName.toLowerCase(), MohistModsEntity.class, Integer.valueOf(typeId), Boolean.valueOf(false)));
                EntityType.NAME_MAP.put(enumName.toLowerCase(), bukkitType);
                EntityType.ID_MAP.put((short)typeId, bukkitType);
                ++ordinal;
                values.add(bukkitType);
                BannerServer.LOGGER.debug("Registered {} as entity {}" + enumName);
            }
            catch (Throwable e) {
                BannerServer.LOGGER.error("Not found {} in {}" + enumName + ". " + e.getMessage());
            }
        }
        DynamicEnumHelper.addEnums(EntityType.class, values);
        BannerServer.LOGGER.info(BannerMCStart.I18N.get("registry.entity-type"), (Object)values.size());
    }

    private static void loadEnchantments() {
        int origin = Enchantment.values().length;
        int size = class_7923.field_41176.method_10204();
        BukkitRegistry.putBool(Enchantment.class, "acceptingNew", true);
        for (class_1887 enc : class_7923.field_41176) {
            try {
                class_2960 location = class_7923.field_41176.method_10221((Object)enc);
                String name = BukkitRegistry.normalizeName(location.toString());
                BannerEnchantment enchantment = new BannerEnchantment(enc, name);
                Enchantment.registerEnchantment(enchantment);
                BannerServer.LOGGER.debug("Registered {} as enchantment {}", (Object)location, (Object)enchantment);
            }
            catch (Exception e) {
                BannerServer.LOGGER.error("Failed to register enchantment {}: {}", (Object)enc, (Object)e);
            }
        }
        Enchantment.stopAcceptingRegistrations();
        BannerServer.LOGGER.info(BannerMCStart.I18N.get("registry.enchantment"), (Object)(size - origin));
    }

    private static void loadPotions() {
        int origin = PotionEffectType.values().length;
        int size = class_7923.field_41174.method_10204();
        int maxId = class_7923.field_41174.method_10220().mapToInt(class_1291::method_5554).max().orElse(0);
        PotionEffectType[] types = new PotionEffectType[maxId + 1];
        BukkitRegistry.putStatic(PotionEffectType.class, "byId", types);
        BukkitRegistry.putBool(PotionEffectType.class, "acceptingNew", true);
        for (class_1291 eff : class_7923.field_41174) {
            try {
                class_2960 location = class_7923.field_41174.method_10221((Object)eff);
                String name = BukkitRegistry.normalizeName(location.toString());
                BannerPotionEffect effect = new BannerPotionEffect(eff, name);
                PotionEffectType.registerPotionEffectType(effect);
                BannerServer.LOGGER.debug("Registered {} as potion {}", (Object)location, (Object)effect);
            }
            catch (Exception e) {
                BannerServer.LOGGER.error("Failed to register potion type {}: {}", (Object)eff, (Object)e);
            }
        }
        PotionEffectType.stopAcceptingRegistrations();
        BannerServer.LOGGER.info(BannerMCStart.I18N.get("registry.potion"), (Object)(size - origin));
        int typeId = PotionType.values().length;
        ArrayList<PotionType> newTypes = new ArrayList<PotionType>();
        HashBiMap map = HashBiMap.create((Map)((Map)Unsafe.getStatic(CraftPotionUtil.class, "regular")));
        BukkitRegistry.putStatic(CraftPotionUtil.class, "regular", map);
        for (class_1842 potion : class_7923.field_41179) {
            class_2960 location = class_7923.field_41179.method_10221((Object)potion);
            if (BukkitRegistry.isMINECRAFT(location) || CraftPotionUtil.toBukkit(location.toString()).getType() != PotionType.UNCRAFTABLE || potion == class_1847.field_8984) continue;
            String name = BukkitRegistry.normalizeName(location.toString());
            class_1293 effectInstance = potion.method_8049().isEmpty() ? null : (class_1293)potion.method_8049().get(0);
            PotionType potionType = DynamicEnumHelper.makeEnum(PotionType.class, name, typeId++, Arrays.asList(PotionEffectType.class, Boolean.TYPE, Boolean.TYPE), Arrays.asList(effectInstance == null ? null : PotionEffectType.getById(class_1291.method_5554((class_1291)effectInstance.method_5579())), false, false));
            newTypes.add(potionType);
            map.put((Object)potionType, (Object)location.toString());
            BannerServer.LOGGER.debug("Registered {} as potion type {}", (Object)location, (Object)potionType);
        }
        DynamicEnumHelper.addEnums(PotionType.class, newTypes);
    }

    private static void putStatic(Class<?> cl, String name, Object o) {
        try {
            Unsafe.ensureClassInitialized(cl);
            Field field = cl.getDeclaredField(name);
            Object materialByNameBase = Unsafe.staticFieldBase(field);
            long materialByNameOffset = Unsafe.staticFieldOffset(field);
            Unsafe.putObject(materialByNameBase, materialByNameOffset, o);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void putBool(Class<?> cl, String name, boolean b) {
        try {
            Unsafe.ensureClassInitialized(cl);
            Field field = cl.getDeclaredField(name);
            Object materialByNameBase = Unsafe.staticFieldBase(field);
            long materialByNameOffset = Unsafe.staticFieldOffset(field);
            Unsafe.putBoolean(materialByNameBase, materialByNameOffset, b);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static String normalizeName(String name) {
        return name.replace(':', '_').replaceAll("\\s+", "_").replaceAll("\\W", "").toUpperCase(Locale.ENGLISH);
    }

    public static boolean isMINECRAFT(class_2960 resourceLocation) {
        return resourceLocation.method_12836().equals("minecraft");
    }
}

