/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_20_R1.inventory;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2371;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_20_R1.entity.CraftHumanEntity;
import org.bukkit.craftbukkit.v1_20_R1.inventory.CraftInventory;
import org.bukkit.craftbukkit.v1_20_R1.inventory.CraftItemStack;
import org.bukkit.entity.HumanEntity;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.InventoryHolder;

public class CraftInventoryCustom
extends CraftInventory {
    public CraftInventoryCustom(InventoryHolder owner, InventoryType type) {
        super(new MinecraftInventory(owner, type));
    }

    public CraftInventoryCustom(InventoryHolder owner, InventoryType type, String title) {
        super(new MinecraftInventory(owner, type, title));
    }

    public CraftInventoryCustom(InventoryHolder owner, int size) {
        super(new MinecraftInventory(owner, size));
    }

    public CraftInventoryCustom(InventoryHolder owner, int size, String title) {
        super(new MinecraftInventory(owner, size, title));
    }

    static class MinecraftInventory
    implements class_1263 {
        private final class_2371<class_1799> items;
        private int maxStack = 64;
        private final List<HumanEntity> viewers;
        private final String title;
        private InventoryType type;
        private final InventoryHolder owner;

        public MinecraftInventory(InventoryHolder owner, InventoryType type) {
            this(owner, type.getDefaultSize(), type.getDefaultTitle());
            this.type = type;
        }

        public MinecraftInventory(InventoryHolder owner, InventoryType type, String title) {
            this(owner, type.getDefaultSize(), title);
            this.type = type;
        }

        public MinecraftInventory(InventoryHolder owner, int size) {
            this(owner, size, "Chest");
        }

        public MinecraftInventory(InventoryHolder owner, int size, String title) {
            Preconditions.checkArgument((title != null ? 1 : 0) != 0, (Object)"title cannot be null");
            this.items = class_2371.method_10213((int)size, (Object)class_1799.field_8037);
            this.title = title;
            this.viewers = new ArrayList<HumanEntity>();
            this.owner = owner;
            this.type = InventoryType.CHEST;
        }

        public int method_5439() {
            return this.items.size();
        }

        public class_1799 method_5438(int i) {
            return (class_1799)this.items.get(i);
        }

        public class_1799 method_5434(int i, int j) {
            class_1799 result;
            class_1799 stack = this.method_5438(i);
            if (stack == class_1799.field_8037) {
                return stack;
            }
            if (stack.method_7947() <= j) {
                this.method_5447(i, class_1799.field_8037);
                result = stack;
            } else {
                result = CraftItemStack.copyNMSStack(stack, j);
                stack.method_7934(j);
            }
            this.method_5431();
            return result;
        }

        public class_1799 method_5441(int i) {
            class_1799 result;
            class_1799 stack = this.method_5438(i);
            if (stack == class_1799.field_8037) {
                return stack;
            }
            if (stack.method_7947() <= 1) {
                this.method_5447(i, null);
                result = stack;
            } else {
                result = CraftItemStack.copyNMSStack(stack, 1);
                stack.method_7934(1);
            }
            return result;
        }

        public void method_5447(int i, class_1799 itemstack) {
            this.items.set(i, (Object)itemstack);
            if (itemstack != class_1799.field_8037 && this.method_5444() > 0 && itemstack.method_7947() > this.method_5444()) {
                itemstack.method_7939(this.method_5444());
            }
        }

        public int method_5444() {
            return this.maxStack;
        }

        public void setMaxStackSize(int size) {
            this.maxStack = size;
        }

        public void method_5431() {
        }

        public boolean method_5443(class_1657 entityhuman) {
            return true;
        }

        public List<class_1799> getContents() {
            return this.items;
        }

        public void onOpen(CraftHumanEntity who) {
            this.viewers.add(who);
        }

        public void onClose(CraftHumanEntity who) {
            this.viewers.remove(who);
        }

        public List<HumanEntity> getViewers() {
            return this.viewers;
        }

        public InventoryType getType() {
            return this.type;
        }

        public InventoryHolder getOwner() {
            return this.owner;
        }

        public boolean method_5437(int i, class_1799 itemstack) {
            return true;
        }

        public void method_5435(class_1657 entityHuman) {
        }

        public void method_5432(class_1657 entityHuman) {
        }

        public void method_5448() {
            this.items.clear();
        }

        public Location getLocation() {
            return null;
        }

        public String getTitle() {
            return this.title;
        }

        public boolean method_5442() {
            class_1799 itemstack;
            Iterator iterator = this.items.iterator();
            do {
                if (iterator.hasNext()) continue;
                return true;
            } while ((itemstack = (class_1799)iterator.next()).method_7960());
            return false;
        }
    }
}

