/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_20_R1.util;

import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.class_124;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_5250;
import net.minecraft.class_5251;
import net.minecraft.class_7417;
import org.bukkit.ChatColor;

public final class CraftChatMessage {
    private static final Pattern LINK_PATTERN = Pattern.compile("((?:(?:https?):\\/\\/)?(?:[-\\w_\\.]{2,}\\.[a-z]{2,4}.*?(?=[\\.\\?!,;:]?(?:[" + String.valueOf('\u00a7') + " \\n]|$))))");
    private static final Map<Character, class_124> formatMap;

    public static class_124 getColor(ChatColor color) {
        return formatMap.get(Character.valueOf(color.getChar()));
    }

    public static ChatColor getColor(class_124 format) {
        return ChatColor.getByChar(format.field_1059);
    }

    public static class_2561 fromStringOrNull(String message) {
        return CraftChatMessage.fromStringOrNull(message, false);
    }

    public static class_2561 fromStringOrNull(String message, boolean keepNewlines) {
        return message == null || message.isEmpty() ? null : CraftChatMessage.fromString(message, keepNewlines)[0];
    }

    public static class_2561[] fromString(String message) {
        return CraftChatMessage.fromString(message, false);
    }

    public static class_2561[] fromString(String message, boolean keepNewlines) {
        return CraftChatMessage.fromString(message, keepNewlines, false);
    }

    public static class_2561[] fromString(String message, boolean keepNewlines, boolean plain) {
        return new StringMessage(message, keepNewlines, plain).getOutput();
    }

    public static String toJSON(class_2561 component) {
        return class_2561.class_2562.method_10867((class_2561)component);
    }

    public static String toJSONOrNull(class_2561 component) {
        if (component == null) {
            return null;
        }
        return CraftChatMessage.toJSON(component);
    }

    public static class_2561 fromJSON(String jsonMessage) throws JsonParseException {
        return class_2561.class_2562.method_10877((String)jsonMessage);
    }

    public static class_2561 fromJSONOrNull(String jsonMessage) {
        if (jsonMessage == null) {
            return null;
        }
        try {
            return CraftChatMessage.fromJSON(jsonMessage);
        }
        catch (JsonParseException ex) {
            return null;
        }
    }

    public static class_2561 fromJSONOrString(String message) {
        return CraftChatMessage.fromJSONOrString(message, false);
    }

    public static class_2561 fromJSONOrString(String message, boolean keepNewlines) {
        return CraftChatMessage.fromJSONOrString(message, false, keepNewlines);
    }

    private static class_2561 fromJSONOrString(String message, boolean nullable, boolean keepNewlines) {
        if (message == null) {
            message = "";
        }
        if (nullable && message.isEmpty()) {
            return null;
        }
        class_2561 component = CraftChatMessage.fromJSONOrNull(message);
        if (component != null) {
            return component;
        }
        return CraftChatMessage.fromString(message, keepNewlines)[0];
    }

    public static String fromJSONOrStringToJSON(String message) {
        return CraftChatMessage.fromJSONOrStringToJSON(message, false);
    }

    public static String fromJSONOrStringToJSON(String message, boolean keepNewlines) {
        return CraftChatMessage.fromJSONOrStringToJSON(message, false, keepNewlines, Integer.MAX_VALUE, false);
    }

    public static String fromJSONOrStringOrNullToJSON(String message) {
        return CraftChatMessage.fromJSONOrStringOrNullToJSON(message, false);
    }

    public static String fromJSONOrStringOrNullToJSON(String message, boolean keepNewlines) {
        return CraftChatMessage.fromJSONOrStringToJSON(message, true, keepNewlines, Integer.MAX_VALUE, false);
    }

    public static String fromJSONOrStringToJSON(String message, boolean nullable, boolean keepNewlines, int maxLength, boolean checkJsonContentLength) {
        if (message == null) {
            message = "";
        }
        if (nullable && message.isEmpty()) {
            return null;
        }
        class_2561 component = CraftChatMessage.fromJSONOrNull(message);
        if (component != null) {
            String trimmedContent;
            String content;
            if (checkJsonContentLength && (content = CraftChatMessage.fromComponent(component)) != (trimmedContent = CraftChatMessage.trimMessage(content, maxLength))) {
                return CraftChatMessage.fromStringToJSON(trimmedContent, keepNewlines);
            }
            return message;
        }
        message = CraftChatMessage.trimMessage(message, maxLength);
        return CraftChatMessage.fromStringToJSON(message, keepNewlines);
    }

    public static String trimMessage(String message, int maxLength) {
        if (message != null && message.length() > maxLength) {
            return message.substring(0, maxLength);
        }
        return message;
    }

    public static String fromStringToJSON(String message) {
        return CraftChatMessage.fromStringToJSON(message, false);
    }

    public static String fromStringToJSON(String message, boolean keepNewlines) {
        class_2561 component = CraftChatMessage.fromString(message, keepNewlines)[0];
        return CraftChatMessage.toJSON(component);
    }

    public static String fromStringOrNullToJSON(String message) {
        class_2561 component = CraftChatMessage.fromStringOrNull(message);
        return CraftChatMessage.toJSONOrNull(component);
    }

    public static String fromJSONComponent(String jsonMessage) {
        class_2561 component = CraftChatMessage.fromJSONOrNull(jsonMessage);
        return CraftChatMessage.fromComponent(component);
    }

    public static String fromComponent(class_2561 component) {
        if (component == null) {
            return "";
        }
        StringBuilder out = new StringBuilder();
        boolean hadFormat = false;
        for (class_2561 c : CraftChatMessage.list(component)) {
            class_2583 modi = c.method_10866();
            class_5251 color = modi.method_10973();
            if (c.method_10851() != class_7417.field_39004 || color != null) {
                if (color != null) {
                    if (color.bridge$format() != null) {
                        out.append(color.bridge$format());
                    } else {
                        out.append('\u00a7').append("x");
                        for (char magic : color.method_27721().substring(1).toCharArray()) {
                            out.append('\u00a7').append(magic);
                        }
                    }
                    hadFormat = true;
                } else if (hadFormat) {
                    out.append((Object)ChatColor.RESET);
                    hadFormat = false;
                }
            }
            if (modi.method_10984()) {
                out.append(class_124.field_1067);
                hadFormat = true;
            }
            if (modi.method_10966()) {
                out.append(class_124.field_1056);
                hadFormat = true;
            }
            if (modi.method_10965()) {
                out.append(class_124.field_1073);
                hadFormat = true;
            }
            if (modi.method_10986()) {
                out.append(class_124.field_1055);
                hadFormat = true;
            }
            if (modi.method_10987()) {
                out.append(class_124.field_1051);
                hadFormat = true;
            }
            c.method_10851().method_27659(x -> {
                out.append(x);
                return Optional.empty();
            });
        }
        return out.toString();
    }

    public static ArrayList<class_2561> list(class_2561 txt) {
        ArrayList<class_2561> arr = new ArrayList<class_2561>();
        if (!arr.contains(txt)) {
            arr.add(txt);
        }
        for (class_2561 tx : txt.method_10855()) {
            arr.addAll(CraftChatMessage.list(tx));
        }
        return arr;
    }

    public static class_2561 fixComponent(class_5250 component) {
        Matcher matcher = LINK_PATTERN.matcher("");
        return CraftChatMessage.fixComponent(component, matcher);
    }

    private static class_2561 fixComponent(class_5250 component, Matcher matcher) {
        class_2585 text;
        String msg;
        if (component.method_10851() instanceof class_2585 && matcher.reset(msg = (text = (class_2585)component.method_10851()).comp_737()).find()) {
            matcher.reset();
            class_2583 modifier = component.method_10866();
            ArrayList<Object> extras = new ArrayList<Object>();
            ArrayList extrasOld = new ArrayList(component.method_10855());
            component = class_2561.method_43473();
            int pos = 0;
            while (matcher.find()) {
                Object match = matcher.group();
                if (!((String)match).startsWith("http://") && !((String)match).startsWith("https://")) {
                    match = "http://" + (String)match;
                }
                class_5250 prev = class_2561.method_43470((String)msg.substring(pos, matcher.start()));
                prev.method_10862(modifier);
                extras.add(prev);
                class_5250 class_52502 = class_2561.method_43470((String)matcher.group());
                class_2583 linkModi = modifier.method_10958(new class_2558(class_2558.class_2559.field_11749, (String)match));
                class_52502.method_10862(linkModi);
                extras.add(class_52502);
                pos = matcher.end();
            }
            class_5250 prev = class_2561.method_43470((String)msg.substring(pos));
            prev.method_10862(modifier);
            extras.add(prev);
            extras.addAll(extrasOld);
            for (class_2561 class_25612 : extras) {
                component.method_10852(class_25612);
            }
        }
        List extras = component.method_10855();
        for (int i = 0; i < extras.size(); ++i) {
            class_2561 comp = (class_2561)extras.get(i);
            if (comp.method_10866() == null || comp.method_10866().method_10970() != null) continue;
            extras.set(i, CraftChatMessage.fixComponent(comp.method_27661(), matcher));
        }
        if (component.method_10851() instanceof class_2588) {
            Object[] subs = ((class_2588)component.method_10851()).method_11023();
            for (int i = 0; i < subs.length; ++i) {
                Object comp = subs[i];
                if (comp instanceof class_2561) {
                    class_2561 c = (class_2561)comp;
                    if (c.method_10866() == null || c.method_10866().method_10970() != null) continue;
                    subs[i] = CraftChatMessage.fixComponent(c.method_27661(), matcher);
                    continue;
                }
                if (!(comp instanceof String) || !matcher.reset((String)comp).find()) continue;
                subs[i] = CraftChatMessage.fixComponent(class_2561.method_43470((String)((String)comp)), matcher);
            }
        }
        return component;
    }

    private CraftChatMessage() {
    }

    static {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (class_124 format : class_124.values()) {
            builder.put((Object)Character.valueOf(Character.toLowerCase(format.toString().charAt(1))), (Object)format);
        }
        formatMap = builder.build();
    }

    private static final class StringMessage {
        private static final Pattern INCREMENTAL_PATTERN = Pattern.compile("(" + String.valueOf('\u00a7') + "[0-9a-fk-orx])|((?:(?:https?):\\/\\/)?(?:[-\\w_\\.]{2,}\\.[a-z]{2,4}.*?(?=[\\.\\?!,;:]?(?:[" + String.valueOf('\u00a7') + " \\n]|$))))|(\\n)", 2);
        private static final Pattern INCREMENTAL_PATTERN_KEEP_NEWLINES = Pattern.compile("(" + String.valueOf('\u00a7') + "[0-9a-fk-orx])|((?:(?:https?):\\/\\/)?(?:[-\\w_\\.]{2,}\\.[a-z]{2,4}.*?(?=[\\.\\?!,;:]?(?:[" + String.valueOf('\u00a7') + " ]|$))))", 2);
        private static final class_2583 RESET = class_2583.field_24360.method_10982(Boolean.valueOf(false)).method_10978(Boolean.valueOf(false)).method_30938(Boolean.valueOf(false)).method_36140(Boolean.valueOf(false)).method_36141(Boolean.valueOf(false));
        private final List<class_2561> list = new ArrayList<class_2561>();
        private class_5250 currentChatComponent = class_2561.method_43473();
        private class_2583 modifier = class_2583.field_24360;
        private final class_2561[] output;
        private int currentIndex;
        private StringBuilder hex;
        private final String message;

        /*
         * Unable to fully structure code
         */
        private StringMessage(String message, boolean keepNewlines, boolean plain) {
            super();
            this.message = message;
            if (message == null) {
                this.output = new class_2561[]{this.currentChatComponent};
                return;
            }
            this.list.add((class_2561)this.currentChatComponent);
            matcher = (keepNewlines != false ? StringMessage.INCREMENTAL_PATTERN_KEEP_NEWLINES : StringMessage.INCREMENTAL_PATTERN).matcher(message);
            match = null;
            needsAdd = false;
            while (matcher.find()) {
                groupId = 0;
                while ((match = matcher.group(++groupId)) == null) {
                }
                index = matcher.start(groupId);
                if (index > this.currentIndex) {
                    needsAdd = false;
                    this.appendNewComponent(index);
                }
                switch (groupId) {
                    case 1: {
                        c = match.toLowerCase(Locale.ENGLISH).charAt(1);
                        format = CraftChatMessage.formatMap.get(Character.valueOf(c));
                        if (c != 'x') ** GOTO lbl29
                        this.hex = new StringBuilder("#");
                        ** GOTO lbl56
lbl29:
                        // 1 sources

                        if (this.hex == null) ** GOTO lbl36
                        this.hex.append(c);
                        if (this.hex.length() == 7) {
                            this.modifier = StringMessage.RESET.method_27703(class_5251.method_27719((String)this.hex.toString()));
                            this.hex = null;
                        }
                        ** GOTO lbl56
lbl36:
                        // 1 sources

                        if (!format.method_542() || format == class_124.field_1070) ** GOTO lbl55
                        switch (1.$SwitchMap$net$minecraft$ChatFormatting[format.ordinal()]) {
                            case 1: {
                                this.modifier = this.modifier.method_10982(Boolean.TRUE);
                                ** GOTO lbl56
                            }
                            case 2: {
                                this.modifier = this.modifier.method_10978(Boolean.TRUE);
                                ** GOTO lbl56
                            }
                            case 3: {
                                this.modifier = this.modifier.method_36140(Boolean.TRUE);
                                ** GOTO lbl56
                            }
                            case 4: {
                                this.modifier = this.modifier.method_30938(Boolean.TRUE);
                                ** GOTO lbl56
                            }
                            case 5: {
                                this.modifier = this.modifier.method_36141(Boolean.TRUE);
                                ** GOTO lbl56
                            }
                            default: {
                                throw new AssertionError((Object)"Unexpected message format");
                            }
                        }
lbl55:
                        // 1 sources

                        this.modifier = StringMessage.RESET.method_10977(format);
lbl56:
                        // 8 sources

                        needsAdd = true;
                        break;
                    }
                    case 2: {
                        if (plain) {
                            this.appendNewComponent(matcher.end(groupId));
                            break;
                        }
                        if (!match.startsWith("http://") && !match.startsWith("https://")) {
                            match = "http://" + (String)match;
                        }
                        this.modifier = this.modifier.method_10958(new class_2558(class_2558.class_2559.field_11749, (String)match));
                        this.appendNewComponent(matcher.end(groupId));
                        this.modifier = this.modifier.method_10958((class_2558)null);
                        break;
                    }
                    case 3: {
                        if (needsAdd) {
                            this.appendNewComponent(index);
                        }
                        this.currentChatComponent = null;
                    }
                }
                this.currentIndex = matcher.end(groupId);
            }
            if (this.currentIndex < message.length() || needsAdd) {
                this.appendNewComponent(message.length());
            }
            this.output = this.list.toArray(new class_2561[this.list.size()]);
        }

        private void appendNewComponent(int index) {
            class_5250 addition = class_2561.method_43470((String)this.message.substring(this.currentIndex, index)).method_10862(this.modifier);
            this.currentIndex = index;
            if (this.currentChatComponent == null) {
                this.currentChatComponent = class_2561.method_43473();
                this.list.add((class_2561)this.currentChatComponent);
            }
            this.currentChatComponent.method_10852((class_2561)addition);
        }

        private class_2561[] getOutput() {
            return this.output;
        }
    }
}

