/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_20_R1.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.class_1936;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2874;
import net.minecraft.class_3218;
import net.minecraft.class_3610;
import net.minecraft.class_5455;
import org.bukkit.block.BlockState;
import org.bukkit.craftbukkit.v1_20_R1.block.CraftBlock;
import org.bukkit.craftbukkit.v1_20_R1.block.CraftBlockEntityState;
import org.bukkit.craftbukkit.v1_20_R1.block.CraftBlockState;
import org.bukkit.craftbukkit.v1_20_R1.util.DummyGeneratorAccess;

public class BlockStateListPopulator
extends DummyGeneratorAccess {
    private final class_1936 world;
    private final Map<class_2338, class_2680> dataMap = new HashMap<class_2338, class_2680>();
    private final Map<class_2338, class_2586> entityMap = new HashMap<class_2338, class_2586>();
    private final LinkedHashMap<class_2338, CraftBlockState> list;

    public BlockStateListPopulator(class_1936 world) {
        this(world, new LinkedHashMap<class_2338, CraftBlockState>());
    }

    private BlockStateListPopulator(class_1936 world, LinkedHashMap<class_2338, CraftBlockState> list) {
        this.world = world;
        this.list = list;
    }

    @Override
    public class_2680 method_8320(class_2338 bp) {
        class_2680 blockData = this.dataMap.get(bp);
        return blockData != null ? blockData : this.world.method_8320(bp);
    }

    @Override
    public class_3610 method_8316(class_2338 bp) {
        class_2680 blockData = this.dataMap.get(bp);
        return blockData != null ? blockData.method_26227() : this.world.method_8316(bp);
    }

    @Override
    public class_2586 method_8321(class_2338 blockposition) {
        if (this.entityMap.containsKey(blockposition)) {
            return this.entityMap.get(blockposition);
        }
        return this.world.method_8321(blockposition);
    }

    public boolean method_8652(class_2338 position, class_2680 data, int flag) {
        position = position.method_10062();
        this.list.remove(position);
        this.dataMap.put(position, data);
        if (data.method_31709()) {
            this.entityMap.put(position, ((class_2343)data.method_26204()).method_10123(position, data));
        } else {
            this.entityMap.put(position, null);
        }
        CraftBlockState state = (CraftBlockState)CraftBlock.at((class_1936)this, position).getState();
        state.setFlag(flag);
        state.setWorldHandle(this.world);
        this.list.put(position, state);
        return true;
    }

    public class_3218 getMinecraftWorld() {
        return this.world.getMinecraftWorld();
    }

    public void refreshTiles() {
        for (CraftBlockState state : this.list.values()) {
            if (!(state instanceof CraftBlockEntityState)) continue;
            ((CraftBlockEntityState)state).refreshSnapshot();
        }
    }

    public void updateList() {
        for (BlockState blockState : this.list.values()) {
            blockState.update(true);
        }
    }

    public Set<class_2338> getBlocks() {
        return this.list.keySet();
    }

    public List<CraftBlockState> getList() {
        return new ArrayList<CraftBlockState>(this.list.values());
    }

    public class_1936 getWorld() {
        return this.world;
    }

    public int method_31607() {
        return this.getWorld().method_31607();
    }

    public int method_31605() {
        return this.getWorld().method_31605();
    }

    @Override
    public boolean method_16358(class_2338 blockposition, Predicate<class_2680> predicate) {
        return predicate.test(this.method_8320(blockposition));
    }

    @Override
    public boolean method_35237(class_2338 bp, Predicate<class_3610> prdct) {
        return this.world.method_35237(bp, prdct);
    }

    @Override
    public class_2874 method_8597() {
        return this.world.method_8597();
    }

    @Override
    public class_5455 method_30349() {
        return this.world.method_30349();
    }
}

