/*
 * Decompiled with CFR 0.152.
 */
package com.mohistmc.banner.mixin.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.ParseResults;
import com.mojang.brigadier.RedirectModifier;
import com.mojang.brigadier.ResultConsumer;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(value={CommandDispatcher.class}, remap=false)
public class MixinCommandDispatcher<S> {
    @Shadow
    private ResultConsumer<S> consumer;

    @Overwrite
    public int execute(ParseResults<S> parse) throws CommandSyntaxException {
        if (parse.getReader().canRead()) {
            if (parse.getExceptions().size() == 1) {
                throw (CommandSyntaxException)((Object)parse.getExceptions().values().iterator().next());
            }
            if (parse.getContext().getRange().isEmpty()) {
                throw CommandSyntaxException.BUILT_IN_EXCEPTIONS.dispatcherUnknownCommand().createWithContext(parse.getReader());
            }
            throw CommandSyntaxException.BUILT_IN_EXCEPTIONS.dispatcherUnknownArgument().createWithContext(parse.getReader());
        }
        int result = 0;
        int successfulForks = 0;
        boolean forked = false;
        boolean foundCommand = false;
        String command = parse.getReader().getString();
        CommandContext original = parse.getContext().build(command);
        List<CommandContext> contexts = Collections.singletonList(original);
        ArrayList<CommandContext> next = null;
        while (contexts != null) {
            int size = contexts.size();
            for (CommandContext context : contexts) {
                CommandContext child = context.getChild();
                if (child != null) {
                    forked |= context.isForked();
                    if (!child.hasNodes()) continue;
                    RedirectModifier modifier = context.getRedirectModifier();
                    if (modifier == null) {
                        if (next == null) {
                            next = new ArrayList<CommandContext>(1);
                        }
                        next.add(child.copyFor(context.getSource()));
                        continue;
                    }
                    try {
                        Collection results = modifier.apply(context);
                        if (!results.isEmpty()) {
                            if (next == null) {
                                next = new ArrayList(results.size());
                            }
                            for (Object source : results) {
                                next.add(child.copyFor(source));
                            }
                            continue;
                        }
                        foundCommand = true;
                        continue;
                    }
                    catch (CommandSyntaxException ex) {
                        this.consumer.onCommandComplete(context, false, 0);
                        if (forked) continue;
                        throw ex;
                    }
                }
                if (context.getCommand() == null) continue;
                foundCommand = true;
                try {
                    int value = context.getCommand().run(context);
                    result += value;
                    this.consumer.onCommandComplete(context, true, value);
                    ++successfulForks;
                }
                catch (CommandSyntaxException ex) {
                    this.consumer.onCommandComplete(context, false, 0);
                    if (forked) continue;
                    throw ex;
                }
            }
            contexts = next;
            next = null;
        }
        if (!foundCommand) {
            this.consumer.onCommandComplete(original, false, 0);
            throw CommandSyntaxException.BUILT_IN_EXCEPTIONS.dispatcherUnknownCommand().createWithContext(parse.getReader());
        }
        return forked ? successfulForks : result;
    }
}

