/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_20_R1.entity;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.mohistmc.banner.bukkit.BukkitCaptures;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Optional;
import java.util.Set;
import net.minecraft.class_1263;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1306;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1671;
import net.minecraft.class_1703;
import net.minecraft.class_1796;
import net.minecraft.class_1799;
import net.minecraft.class_1860;
import net.minecraft.class_1863;
import net.minecraft.class_1937;
import net.minecraft.class_2244;
import net.minecraft.class_2246;
import net.minecraft.class_2304;
import net.minecraft.class_2331;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2596;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2815;
import net.minecraft.class_3222;
import net.minecraft.class_3908;
import net.minecraft.class_3917;
import net.minecraft.class_3944;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.block.Block;
import org.bukkit.craftbukkit.v1_20_R1.CraftServer;
import org.bukkit.craftbukkit.v1_20_R1.entity.CraftAbstractVillager;
import org.bukkit.craftbukkit.v1_20_R1.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_20_R1.entity.CraftLivingEntity;
import org.bukkit.craftbukkit.v1_20_R1.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_20_R1.entity.CraftVillager;
import org.bukkit.craftbukkit.v1_20_R1.entity.memory.CraftMemoryMapper;
import org.bukkit.craftbukkit.v1_20_R1.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_20_R1.inventory.CraftContainer;
import org.bukkit.craftbukkit.v1_20_R1.inventory.CraftInventory;
import org.bukkit.craftbukkit.v1_20_R1.inventory.CraftInventoryDoubleChest;
import org.bukkit.craftbukkit.v1_20_R1.inventory.CraftInventoryLectern;
import org.bukkit.craftbukkit.v1_20_R1.inventory.CraftInventoryPlayer;
import org.bukkit.craftbukkit.v1_20_R1.inventory.CraftInventoryView;
import org.bukkit.craftbukkit.v1_20_R1.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_20_R1.inventory.CraftMerchantCustom;
import org.bukkit.craftbukkit.v1_20_R1.util.CraftChatMessage;
import org.bukkit.craftbukkit.v1_20_R1.util.CraftLocation;
import org.bukkit.craftbukkit.v1_20_R1.util.CraftMagicNumbers;
import org.bukkit.craftbukkit.v1_20_R1.util.CraftNamespacedKey;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Firework;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Villager;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.MainHand;
import org.bukkit.inventory.Merchant;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.permissions.PermissibleBase;
import org.bukkit.permissions.Permission;
import org.bukkit.permissions.PermissionAttachment;
import org.bukkit.permissions.PermissionAttachmentInfo;
import org.bukkit.plugin.Plugin;

public class CraftHumanEntity
extends CraftLivingEntity
implements HumanEntity {
    private CraftInventoryPlayer inventory;
    private CraftInventory enderChest;
    protected final PermissibleBase perm = new PermissibleBase(this);
    private boolean op;
    private GameMode mode;

    public CraftHumanEntity(CraftServer server, class_1657 entity) {
        super(server, (class_1309)entity);
        this.mode = server.getDefaultGameMode();
        this.inventory = new CraftInventoryPlayer(entity.method_31548());
        this.enderChest = new CraftInventory((class_1263)entity.method_7274());
    }

    @Override
    public PlayerInventory getInventory() {
        if (this.inventory == null || this.inventory.getInventory() != ((class_1657)this.entity).method_31548()) {
            this.inventory = new CraftInventoryPlayer(((class_1657)this.entity).method_31548());
        }
        return this.inventory;
    }

    @Override
    public EntityEquipment getEquipment() {
        if (this.inventory == null || this.inventory.getInventory() != ((class_1657)this.entity).method_31548()) {
            this.inventory = new CraftInventoryPlayer(((class_1657)this.entity).method_31548());
        }
        return this.inventory;
    }

    @Override
    public Inventory getEnderChest() {
        if (this.enderChest == null || this.enderChest.getInventory() != ((class_1657)this.entity).method_7274()) {
            this.enderChest = new CraftInventory((class_1263)((class_1657)this.entity).method_7274());
        }
        return this.enderChest;
    }

    @Override
    public MainHand getMainHand() {
        return this.getHandle().method_6068() == class_1306.field_6182 ? MainHand.LEFT : MainHand.RIGHT;
    }

    @Override
    public ItemStack getItemInHand() {
        return this.getInventory().getItemInHand();
    }

    @Override
    public void setItemInHand(ItemStack item) {
        this.getInventory().setItemInHand(item);
    }

    @Override
    public ItemStack getItemOnCursor() {
        return CraftItemStack.asCraftMirror(this.getHandle().field_7512.method_34255());
    }

    @Override
    public void setItemOnCursor(ItemStack item) {
        class_1799 stack = CraftItemStack.asNMSCopy(item);
        this.getHandle().field_7512.method_34254(stack);
        if (this instanceof CraftPlayer) {
            this.getHandle().field_7512.broadcastCarriedItem();
        }
    }

    @Override
    public int getSleepTicks() {
        return this.getHandle().field_7487;
    }

    @Override
    public boolean sleep(Location location, boolean force) {
        Preconditions.checkArgument((location != null ? 1 : 0) != 0, (Object)"Location cannot be null");
        Preconditions.checkArgument((location.getWorld() != null ? 1 : 0) != 0, (Object)"Location needs to be in a world");
        Preconditions.checkArgument((boolean)location.getWorld().equals(this.getWorld()), (Object)"Cannot sleep across worlds");
        class_2338 blockposition = CraftLocation.toBlockPosition(location);
        class_2680 iblockdata = this.getHandle().method_37908().method_8320(blockposition);
        if (!(iblockdata.method_26204() instanceof class_2244)) {
            return false;
        }
        if (this.getHandle().startSleepInBed(blockposition, force).left().isPresent()) {
            return false;
        }
        iblockdata = (class_2680)iblockdata.method_11657((class_2769)class_2244.field_9968, (Comparable)Boolean.valueOf(true));
        this.getHandle().method_37908().method_8652(blockposition, iblockdata, 4);
        return true;
    }

    @Override
    public void wakeup(boolean setSpawnLocation) {
        Preconditions.checkState((boolean)this.isSleeping(), (Object)"Cannot wakeup if not sleeping");
        this.getHandle().method_7358(true, setSpawnLocation);
    }

    @Override
    public Location getBedLocation() {
        Preconditions.checkState((boolean)this.isSleeping(), (Object)"Not sleeping");
        class_2338 bed = (class_2338)this.getHandle().method_18398().get();
        return CraftLocation.toBukkit(bed, this.getWorld());
    }

    @Override
    public String getName() {
        return this.getHandle().method_5820();
    }

    @Override
    public boolean isOp() {
        return this.op;
    }

    @Override
    public boolean isPermissionSet(String name) {
        return this.perm.isPermissionSet(name);
    }

    @Override
    public boolean isPermissionSet(Permission perm) {
        return this.perm.isPermissionSet(perm);
    }

    @Override
    public boolean hasPermission(String name) {
        return this.perm.hasPermission(name);
    }

    @Override
    public boolean hasPermission(Permission perm) {
        return this.perm.hasPermission(perm);
    }

    @Override
    public PermissionAttachment addAttachment(Plugin plugin, String name, boolean value) {
        return this.perm.addAttachment(plugin, name, value);
    }

    @Override
    public PermissionAttachment addAttachment(Plugin plugin) {
        return this.perm.addAttachment(plugin);
    }

    @Override
    public PermissionAttachment addAttachment(Plugin plugin, String name, boolean value, int ticks) {
        return this.perm.addAttachment(plugin, name, value, ticks);
    }

    @Override
    public PermissionAttachment addAttachment(Plugin plugin, int ticks) {
        return this.perm.addAttachment(plugin, ticks);
    }

    @Override
    public void removeAttachment(PermissionAttachment attachment) {
        this.perm.removeAttachment(attachment);
    }

    @Override
    public void recalculatePermissions() {
        this.perm.recalculatePermissions();
    }

    @Override
    public void setOp(boolean value) {
        this.op = value;
        this.perm.recalculatePermissions();
    }

    @Override
    public Set<PermissionAttachmentInfo> getEffectivePermissions() {
        return this.perm.getEffectivePermissions();
    }

    @Override
    public GameMode getGameMode() {
        return this.mode;
    }

    @Override
    public void setGameMode(GameMode mode) {
        Preconditions.checkArgument((mode != null ? 1 : 0) != 0, (Object)"GameMode cannot be null");
        this.mode = mode;
    }

    public class_1657 getHandle() {
        return (class_1657)this.entity;
    }

    public void setHandle(class_1657 entity) {
        super.setHandle((class_1309)entity);
        this.inventory = new CraftInventoryPlayer(entity.method_31548());
    }

    @Override
    public String toString() {
        return "CraftHumanEntity{id=" + this.getEntityId() + "name=" + this.getName() + "}";
    }

    @Override
    public InventoryView getOpenInventory() {
        BukkitCaptures.captureContainerOwner(this.getHandle());
        return this.getHandle().field_7512.getBukkitView();
    }

    @Override
    public InventoryView openInventory(Inventory inventory) {
        class_2586 te;
        CraftInventory craft;
        if (!(this.getHandle() instanceof class_3222)) {
            return null;
        }
        class_3222 player = (class_3222)this.getHandle();
        class_1703 formerContainer = this.getHandle().field_7512;
        class_3908 iinventory = null;
        if (inventory instanceof CraftInventoryDoubleChest) {
            iinventory = ((CraftInventoryDoubleChest)inventory).tile;
        } else if (inventory instanceof CraftInventoryLectern) {
            iinventory = ((CraftInventoryLectern)inventory).tile;
        } else if (inventory instanceof CraftInventory && (craft = (CraftInventory)inventory).getInventory() instanceof class_3908) {
            iinventory = (class_3908)craft.getInventory();
        }
        if (iinventory instanceof class_3908 && iinventory instanceof class_2586 && !(te = (class_2586)iinventory).method_11002()) {
            te.method_31662(this.getHandle().method_37908());
        }
        class_3917 container = CraftContainer.getNotchInventoryType(inventory);
        if (iinventory instanceof class_3908) {
            this.getHandle().method_17355(iinventory);
        } else {
            CraftHumanEntity.openCustomInventory(inventory, player, container);
        }
        if (this.getHandle().field_7512 == formerContainer) {
            return null;
        }
        this.getHandle().field_7512.banner$setCheckReachable(false);
        return this.getHandle().field_7512.getBukkitView();
    }

    private static void openCustomInventory(Inventory inventory, class_3222 player, class_3917<?> windowType) {
        if (player.field_13987 == null) {
            return;
        }
        Preconditions.checkArgument((windowType != null ? 1 : 0) != 0, (Object)"Unknown windowType");
        CraftContainer container = new CraftContainer(inventory, (class_1657)player, player.nextContainerCounterInt());
        container = CraftEventFactory.callInventoryOpenEvent(player, container);
        if (container == null) {
            return;
        }
        String title = container.getBukkitView().getTitle();
        player.field_13987.method_14364((class_2596)new class_3944(container.field_7763, windowType, CraftChatMessage.fromString(title)[0]));
        player.field_7512 = container;
        player.method_14235((class_1703)container);
    }

    @Override
    public InventoryView openWorkbench(Location location, boolean force) {
        Block block;
        if (location == null) {
            location = this.getLocation();
        }
        if (!force && (block = location.getBlock()).getType() != Material.CRAFTING_TABLE) {
            return null;
        }
        this.getHandle().method_17355(((class_2304)class_2246.field_9980).method_17454(null, this.getHandle().method_37908(), CraftLocation.toBlockPosition(location)));
        if (force) {
            this.getHandle().field_7512.banner$setCheckReachable(false);
        }
        return this.getHandle().field_7512.getBukkitView();
    }

    @Override
    public InventoryView openEnchanting(Location location, boolean force) {
        Block block;
        if (location == null) {
            location = this.getLocation();
        }
        if (!force && (block = location.getBlock()).getType() != Material.ENCHANTING_TABLE) {
            return null;
        }
        class_2338 pos = CraftLocation.toBlockPosition(location);
        this.getHandle().method_17355(((class_2331)class_2246.field_10485).method_17454(null, this.getHandle().method_37908(), pos));
        if (force) {
            this.getHandle().field_7512.banner$setCheckReachable(false);
        }
        return this.getHandle().field_7512.getBukkitView();
    }

    @Override
    public void openInventory(InventoryView inventory) {
        if (!(this.getHandle() instanceof class_3222)) {
            return;
        }
        if (((class_3222)this.getHandle()).field_13987 == null) {
            return;
        }
        if (this.getHandle().field_7512 != this.getHandle().field_7498) {
            ((class_3222)this.getHandle()).field_13987.method_12054(new class_2815(this.getHandle().field_7512.field_7763));
        }
        class_3222 player = (class_3222)this.getHandle();
        Object container = inventory instanceof CraftInventoryView ? ((CraftInventoryView)inventory).getHandle() : new CraftContainer(inventory, this.getHandle(), player.nextContainerCounterInt());
        if ((container = CraftEventFactory.callInventoryOpenEvent(player, container)) == null) {
            return;
        }
        class_3917 windowType = CraftContainer.getNotchInventoryType(inventory.getTopInventory());
        String title = inventory.getTitle();
        player.field_13987.method_14364((class_2596)new class_3944(container.field_7763, windowType, CraftChatMessage.fromString(title)[0]));
        player.field_7512 = container;
        player.method_14235(container);
    }

    @Override
    public InventoryView openMerchant(Villager villager, boolean force) {
        Preconditions.checkNotNull((Object)villager, (Object)"villager cannot be null");
        return this.openMerchant((Merchant)villager, force);
    }

    @Override
    public InventoryView openMerchant(Merchant merchant, boolean force) {
        class_2561 name;
        Object mcMerchant;
        Preconditions.checkNotNull((Object)merchant, (Object)"merchant cannot be null");
        if (!force && merchant.isTrading()) {
            return null;
        }
        if (merchant.isTrading()) {
            merchant.getTrader().closeInventory();
        }
        int level = 1;
        if (merchant instanceof CraftAbstractVillager) {
            mcMerchant = ((CraftAbstractVillager)merchant).getHandle();
            name = ((CraftAbstractVillager)merchant).getHandle().method_5476();
            if (merchant instanceof CraftVillager) {
                level = ((CraftVillager)merchant).getHandle().method_7231().method_16925();
            }
        } else if (merchant instanceof CraftMerchantCustom) {
            mcMerchant = ((CraftMerchantCustom)merchant).getMerchant();
            name = ((CraftMerchantCustom)merchant).getMerchant().getScoreboardDisplayName();
        } else {
            throw new IllegalArgumentException("Can't open merchant " + merchant.toString());
        }
        mcMerchant.method_8259(this.getHandle());
        mcMerchant.method_17449(this.getHandle(), name, level);
        return this.getHandle().field_7512.getBukkitView();
    }

    @Override
    public void closeInventory() {
        this.getHandle().method_7346();
    }

    @Override
    public boolean isBlocking() {
        return this.getHandle().method_6039();
    }

    @Override
    public boolean isHandRaised() {
        return this.getHandle().method_6115();
    }

    @Override
    public ItemStack getItemInUse() {
        class_1799 item = this.getHandle().method_6030();
        return item.method_7960() ? null : CraftItemStack.asCraftMirror(item);
    }

    @Override
    public boolean setWindowProperty(InventoryView.Property prop, int value) {
        return false;
    }

    @Override
    public int getEnchantmentSeed() {
        return this.getHandle().field_7494;
    }

    @Override
    public void setEnchantmentSeed(int i) {
        this.getHandle().field_7494 = i;
    }

    @Override
    public int getExpToLevel() {
        return this.getHandle().method_7349();
    }

    @Override
    public float getAttackCooldown() {
        return this.getHandle().method_7261(0.5f);
    }

    @Override
    public boolean hasCooldown(Material material) {
        Preconditions.checkArgument((material != null ? 1 : 0) != 0, (Object)"Material cannot be null");
        Preconditions.checkArgument((boolean)material.isItem(), (String)"Material %s is not an item", (Object)material);
        return this.getHandle().method_7357().method_7904(CraftMagicNumbers.getItem(material));
    }

    @Override
    public int getCooldown(Material material) {
        Preconditions.checkArgument((material != null ? 1 : 0) != 0, (Object)"Material cannot be null");
        Preconditions.checkArgument((boolean)material.isItem(), (String)"Material %s is not an item", (Object)material);
        class_1796.class_1797 cooldown = (class_1796.class_1797)this.getHandle().method_7357().field_8024.get(CraftMagicNumbers.getItem(material));
        return cooldown == null ? 0 : Math.max(0, cooldown.field_8027 - this.getHandle().method_7357().field_8025);
    }

    @Override
    public void setCooldown(Material material, int ticks) {
        Preconditions.checkArgument((material != null ? 1 : 0) != 0, (Object)"Material cannot be null");
        Preconditions.checkArgument((boolean)material.isItem(), (String)"Material %s is not an item", (Object)material);
        this.getHandle().method_7357().method_7906(CraftMagicNumbers.getItem(material), ticks);
    }

    @Override
    public boolean discoverRecipe(NamespacedKey recipe) {
        return this.discoverRecipes(Arrays.asList(recipe)) != 0;
    }

    @Override
    public int discoverRecipes(Collection<NamespacedKey> recipes) {
        return this.getHandle().method_7254(this.bukkitKeysToMinecraftRecipes(recipes));
    }

    @Override
    public boolean undiscoverRecipe(NamespacedKey recipe) {
        return this.undiscoverRecipes(Arrays.asList(recipe)) != 0;
    }

    @Override
    public int undiscoverRecipes(Collection<NamespacedKey> recipes) {
        return this.getHandle().method_7333(this.bukkitKeysToMinecraftRecipes(recipes));
    }

    @Override
    public boolean hasDiscoveredRecipe(NamespacedKey recipe) {
        return false;
    }

    @Override
    public Set<NamespacedKey> getDiscoveredRecipes() {
        return ImmutableSet.of();
    }

    private Collection<class_1860<?>> bukkitKeysToMinecraftRecipes(Collection<NamespacedKey> recipeKeys) {
        ArrayList recipes = new ArrayList();
        class_1863 manager = this.getHandle().method_37908().method_8503().method_3772();
        for (NamespacedKey recipeKey : recipeKeys) {
            Optional recipe = manager.method_8130(CraftNamespacedKey.toMinecraft(recipeKey));
            if (!recipe.isPresent()) continue;
            recipes.add((class_1860)recipe.get());
        }
        return recipes;
    }

    @Override
    public Entity getShoulderEntityLeft() {
        if (!this.getHandle().method_7356().method_33133()) {
            Optional shoulder = class_1299.method_5892((class_2487)this.getHandle().method_7356(), (class_1937)this.getHandle().method_37908());
            return !shoulder.isPresent() ? null : ((class_1297)shoulder.get()).getBukkitEntity();
        }
        return null;
    }

    @Override
    public void setShoulderEntityLeft(Entity entity) {
        this.getHandle().method_7273(entity == null ? new class_2487() : ((CraftEntity)entity).save());
        if (entity != null) {
            entity.remove();
        }
    }

    @Override
    public Entity getShoulderEntityRight() {
        if (!this.getHandle().method_7308().method_33133()) {
            Optional shoulder = class_1299.method_5892((class_2487)this.getHandle().method_7308(), (class_1937)this.getHandle().method_37908());
            return !shoulder.isPresent() ? null : ((class_1297)shoulder.get()).getBukkitEntity();
        }
        return null;
    }

    @Override
    public void setShoulderEntityRight(Entity entity) {
        this.getHandle().method_7345(entity == null ? new class_2487() : ((CraftEntity)entity).save());
        if (entity != null) {
            entity.remove();
        }
    }

    @Override
    public boolean dropItem(boolean dropAll) {
        if (!(this.getHandle() instanceof class_3222)) {
            return false;
        }
        return ((class_3222)this.getHandle()).method_37413(dropAll);
    }

    @Override
    public float getExhaustion() {
        return this.getHandle().method_7344().field_7752;
    }

    @Override
    public void setExhaustion(float value) {
        this.getHandle().method_7344().field_7752 = value;
    }

    @Override
    public float getSaturation() {
        return this.getHandle().method_7344().field_7753;
    }

    @Override
    public void setSaturation(float value) {
        this.getHandle().method_7344().field_7753 = value;
    }

    @Override
    public int getFoodLevel() {
        return this.getHandle().method_7344().field_7756;
    }

    @Override
    public void setFoodLevel(int value) {
        this.getHandle().method_7344().field_7756 = value;
    }

    @Override
    public int getSaturatedRegenRate() {
        return this.getHandle().method_7344().bridge$saturatedRegenRate();
    }

    @Override
    public void setSaturatedRegenRate(int i) {
        this.getHandle().method_7344().banner$setSaturatedRegenRate(i);
    }

    @Override
    public int getUnsaturatedRegenRate() {
        return this.getHandle().method_7344().bridge$unsaturatedRegenRate();
    }

    @Override
    public void setUnsaturatedRegenRate(int i) {
        this.getHandle().method_7344().banner$setUnsaturatedRegenRate(i);
    }

    @Override
    public int getStarvationRate() {
        return this.getHandle().method_7344().bridge$starvationRate();
    }

    @Override
    public void setStarvationRate(int i) {
        this.getHandle().method_7344().banner$setStarvationRate(i);
    }

    @Override
    public Location getLastDeathLocation() {
        return this.getHandle().method_43122().map(CraftMemoryMapper::fromNms).orElse(null);
    }

    @Override
    public void setLastDeathLocation(Location location) {
        if (location == null) {
            this.getHandle().method_43120(Optional.empty());
        } else {
            this.getHandle().method_43120(Optional.of(CraftMemoryMapper.toNms(location)));
        }
    }

    @Override
    public Firework fireworkBoost(ItemStack fireworkItemStack) {
        Preconditions.checkArgument((fireworkItemStack != null ? 1 : 0) != 0, (Object)"fireworkItemStack must not be null");
        Preconditions.checkArgument((fireworkItemStack.getType() == Material.FIREWORK_ROCKET ? 1 : 0) != 0, (String)"fireworkItemStack must be of type %s", (Object)Material.FIREWORK_ROCKET);
        class_1671 fireworks = new class_1671(this.getHandle().method_37908(), CraftItemStack.asNMSCopy(fireworkItemStack), (class_1309)this.getHandle());
        boolean success = this.getHandle().method_37908().addFreshEntity((class_1297)fireworks, CreatureSpawnEvent.SpawnReason.CUSTOM);
        return success ? (Firework)((Object)fireworks.getBukkitEntity()) : null;
    }
}

