/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_20_R1.block;

import com.google.common.base.Preconditions;
import java.lang.ref.WeakReference;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.data.BlockData;
import org.bukkit.craftbukkit.v1_20_R1.CraftWorld;
import org.bukkit.craftbukkit.v1_20_R1.block.CraftBlock;
import org.bukkit.craftbukkit.v1_20_R1.block.data.CraftBlockData;
import org.bukkit.craftbukkit.v1_20_R1.util.CraftLocation;
import org.bukkit.craftbukkit.v1_20_R1.util.CraftMagicNumbers;
import org.bukkit.material.MaterialData;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;

public class CraftBlockState
implements BlockState {
    protected final CraftWorld world;
    private final class_2338 position;
    protected class_2680 data;
    protected int flag;
    private WeakReference<class_1936> weakWorld;

    protected CraftBlockState(Block block) {
        this(block.getWorld(), ((CraftBlock)block).getPosition(), ((CraftBlock)block).getNMS());
        this.flag = 3;
        this.setWorldHandle(((CraftBlock)block).getHandle());
    }

    protected CraftBlockState(Block block, int flag) {
        this(block);
        this.flag = flag;
    }

    protected CraftBlockState(@Nullable World world, class_2338 blockPosition, class_2680 blockData) {
        this.world = (CraftWorld)world;
        this.position = blockPosition;
        this.data = blockData;
    }

    public void setWorldHandle(class_1936 generatorAccess) {
        this.weakWorld = generatorAccess instanceof class_1937 ? null : new WeakReference<class_1936>(generatorAccess);
    }

    public class_1936 getWorldHandle() {
        if (this.weakWorld == null) {
            return this.isPlaced() ? this.world.getHandle() : null;
        }
        class_1936 access = (class_1936)this.weakWorld.get();
        if (access == null) {
            this.weakWorld = null;
            return this.isPlaced() ? this.world.getHandle() : null;
        }
        return access;
    }

    protected final boolean isWorldGeneration() {
        class_1936 generatorAccess = this.getWorldHandle();
        return generatorAccess != null && !(generatorAccess instanceof class_1937);
    }

    protected final void ensureNoWorldGeneration() {
        if (this.isWorldGeneration()) {
            throw new IllegalStateException("This operation is not supported during world generation!");
        }
    }

    @Override
    public World getWorld() {
        this.requirePlaced();
        return this.world;
    }

    @Override
    public int getX() {
        return this.position.method_10263();
    }

    @Override
    public int getY() {
        return this.position.method_10264();
    }

    @Override
    public int getZ() {
        return this.position.method_10260();
    }

    @Override
    public Chunk getChunk() {
        this.requirePlaced();
        return this.world.getChunkAt(this.getX() >> 4, this.getZ() >> 4);
    }

    public void setData(class_2680 data) {
        this.data = data;
    }

    public class_2338 getPosition() {
        return this.position;
    }

    public class_2680 getHandle() {
        return this.data;
    }

    @Override
    public BlockData getBlockData() {
        return CraftBlockData.fromData(this.data);
    }

    @Override
    public void setBlockData(BlockData data) {
        Preconditions.checkArgument((data != null ? 1 : 0) != 0, (Object)"BlockData cannot be null");
        this.data = ((CraftBlockData)data).getState();
    }

    @Override
    public void setData(MaterialData data) {
        Material mat = CraftMagicNumbers.getMaterial(this.data).getItemType();
        if (mat == null || mat.getData() == null) {
            this.data = CraftMagicNumbers.getBlock(data);
        } else if (data.getClass() == mat.getData() || data.getClass() == MaterialData.class) {
            this.data = CraftMagicNumbers.getBlock(data);
        } else {
            throw new IllegalArgumentException("Provided data is not of type " + mat.getData().getName() + ", found " + data.getClass().getName());
        }
    }

    @Override
    public MaterialData getData() {
        return CraftMagicNumbers.getMaterial(this.data);
    }

    @Override
    public void setType(Material type) {
        Preconditions.checkArgument((type != null ? 1 : 0) != 0, (Object)"Material cannot be null");
        Preconditions.checkArgument((boolean)type.isBlock(), (Object)"Material must be a block!");
        if (this.getType() != type) {
            this.data = CraftMagicNumbers.getBlock(type).method_9564();
        }
    }

    @Override
    public Material getType() {
        return CraftMagicNumbers.getMaterial(this.data.method_26204());
    }

    public void setFlag(int flag) {
        this.flag = flag;
    }

    public int getFlag() {
        return this.flag;
    }

    @Override
    public byte getLightLevel() {
        return this.getBlock().getLightLevel();
    }

    @Override
    public CraftBlock getBlock() {
        this.requirePlaced();
        return CraftBlock.at(this.getWorldHandle(), this.position);
    }

    @Override
    public boolean update() {
        return this.update(false);
    }

    @Override
    public boolean update(boolean force) {
        return this.update(force, true);
    }

    @Override
    public boolean update(boolean force, boolean applyPhysics) {
        if (!this.isPlaced()) {
            return true;
        }
        class_1936 access = this.getWorldHandle();
        CraftBlock block = this.getBlock();
        if (block.getType() != this.getType() && !force) {
            return false;
        }
        class_2680 newBlock = this.data;
        block.setTypeAndData(newBlock, applyPhysics);
        if (access instanceof class_1937) {
            this.world.getHandle().method_8413(this.position, block.getNMS(), newBlock, 3);
        }
        return true;
    }

    @Override
    public byte getRawData() {
        return CraftMagicNumbers.toLegacyData(this.data);
    }

    @Override
    public Location getLocation() {
        return CraftLocation.toBukkit(this.position, (World)this.world);
    }

    @Override
    public Location getLocation(Location loc) {
        if (loc != null) {
            loc.setWorld(this.world);
            loc.setX(this.getX());
            loc.setY(this.getY());
            loc.setZ(this.getZ());
            loc.setYaw(0.0f);
            loc.setPitch(0.0f);
        }
        return loc;
    }

    @Override
    public void setRawData(byte data) {
        this.data = CraftMagicNumbers.getBlock(this.getType(), data);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CraftBlockState other = (CraftBlockState)obj;
        if (!(this.world == other.world || this.world != null && this.world.equals(other.world))) {
            return false;
        }
        if (!(this.position == other.position || this.position != null && this.position.equals((Object)other.position))) {
            return false;
        }
        return this.data == other.data || this.data != null && this.data.equals(other.data);
    }

    public int hashCode() {
        int hash = 7;
        hash = 73 * hash + (this.world != null ? this.world.hashCode() : 0);
        hash = 73 * hash + (this.position != null ? this.position.hashCode() : 0);
        hash = 73 * hash + (this.data != null ? this.data.hashCode() : 0);
        return hash;
    }

    @Override
    public void setMetadata(String metadataKey, MetadataValue newMetadataValue) {
        this.requirePlaced();
        this.world.getBlockMetadata().setMetadata(this.getBlock(), metadataKey, newMetadataValue);
    }

    @Override
    public List<MetadataValue> getMetadata(String metadataKey) {
        this.requirePlaced();
        return this.world.getBlockMetadata().getMetadata(this.getBlock(), metadataKey);
    }

    @Override
    public boolean hasMetadata(String metadataKey) {
        this.requirePlaced();
        return this.world.getBlockMetadata().hasMetadata(this.getBlock(), metadataKey);
    }

    @Override
    public void removeMetadata(String metadataKey, Plugin owningPlugin) {
        this.requirePlaced();
        this.world.getBlockMetadata().removeMetadata(this.getBlock(), metadataKey, owningPlugin);
    }

    @Override
    public boolean isPlaced() {
        return this.world != null;
    }

    protected void requirePlaced() {
        if (!this.isPlaced()) {
            throw new IllegalStateException("The blockState must be placed to call this method");
        }
    }

    public String toString() {
        return this.data.toString();
    }
}

