/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_20_R1.entity;

import com.google.common.base.Preconditions;
import com.mohistmc.banner.bukkit.BukkitExtraConstants;
import java.util.Locale;
import net.minecraft.class_1641;
import net.minecraft.class_1646;
import net.minecraft.class_2244;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_3852;
import net.minecraft.class_3854;
import net.minecraft.class_3988;
import net.minecraft.class_7923;
import org.apache.commons.lang3.Validate;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_20_R1.CraftServer;
import org.bukkit.craftbukkit.v1_20_R1.entity.CraftAbstractVillager;
import org.bukkit.craftbukkit.v1_20_R1.util.CraftLocation;
import org.bukkit.craftbukkit.v1_20_R1.util.CraftNamespacedKey;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Villager;
import org.bukkit.entity.ZombieVillager;
import org.bukkit.event.entity.CreatureSpawnEvent;

public class CraftVillager
extends CraftAbstractVillager
implements Villager {
    public CraftVillager(CraftServer server, class_1646 entity) {
        super(server, (class_3988)entity);
    }

    public class_1646 getHandle() {
        return (class_1646)this.entity;
    }

    @Override
    public String toString() {
        return "CraftVillager";
    }

    @Override
    public EntityType getType() {
        return EntityType.VILLAGER;
    }

    @Override
    public void remove() {
        this.getHandle().method_30958();
        super.remove();
    }

    @Override
    public Villager.Profession getProfession() {
        return CraftVillager.nmsToBukkitProfession(this.getHandle().method_7231().method_16924());
    }

    @Override
    public void setProfession(Villager.Profession profession) {
        Validate.notNull((Object)profession);
        this.getHandle().method_7195(this.getHandle().method_7231().method_16921(CraftVillager.bukkitToNmsProfession(profession)));
    }

    @Override
    public Villager.Type getVillagerType() {
        return Villager.Type.valueOf(class_7923.field_41194.method_10221((Object)this.getHandle().method_7231().method_16919()).method_12832().toUpperCase(Locale.ROOT));
    }

    @Override
    public void setVillagerType(Villager.Type type) {
        Validate.notNull((Object)type);
        this.getHandle().method_7195(this.getHandle().method_7231().method_16922((class_3854)class_7923.field_41194.method_10223(CraftNamespacedKey.toMinecraft(type.getKey()))));
    }

    @Override
    public int getVillagerLevel() {
        return this.getHandle().method_7231().method_16925();
    }

    @Override
    public void setVillagerLevel(int level) {
        Preconditions.checkArgument((1 <= level && level <= 5 ? 1 : 0) != 0, (Object)"level must be between [1, 5]");
        this.getHandle().method_7195(this.getHandle().method_7231().method_16920(level));
    }

    @Override
    public int getVillagerExperience() {
        return this.getHandle().method_19269();
    }

    @Override
    public void setVillagerExperience(int experience) {
        Preconditions.checkArgument((experience >= 0 ? 1 : 0) != 0, (Object)"Experience must be positive");
        this.getHandle().method_19625(experience);
    }

    @Override
    public boolean sleep(Location location) {
        Preconditions.checkArgument((location != null ? 1 : 0) != 0, (Object)"Location cannot be null");
        Preconditions.checkArgument((location.getWorld() != null ? 1 : 0) != 0, (Object)"Location needs to be in a world");
        Preconditions.checkArgument((boolean)location.getWorld().equals(this.getWorld()), (Object)"Cannot sleep across worlds");
        Preconditions.checkState((!this.getHandle().bridge$generation() ? 1 : 0) != 0, (Object)"Cannot sleep during world generation");
        class_2338 position = CraftLocation.toBlockPosition(location);
        class_2680 iblockdata = this.getHandle().method_37908().method_8320(position);
        if (!(iblockdata.method_26204() instanceof class_2244)) {
            return false;
        }
        this.getHandle().method_18403(position);
        return true;
    }

    @Override
    public void wakeup() {
        Preconditions.checkState((boolean)this.isSleeping(), (Object)"Cannot wakeup if not sleeping");
        Preconditions.checkState((!this.getHandle().bridge$generation() ? 1 : 0) != 0, (Object)"Cannot wakeup during world generation");
        this.getHandle().method_18400();
    }

    @Override
    public void shakeHead() {
        this.getHandle().method_20264();
    }

    @Override
    public ZombieVillager zombify() {
        class_1641 entityzombievillager = BukkitExtraConstants.zombifyVillager(this.getHandle().method_37908().getMinecraftWorld(), this.getHandle(), this.getHandle().method_24515(), this.isSilent(), CreatureSpawnEvent.SpawnReason.CUSTOM);
        return entityzombievillager != null ? (ZombieVillager)((Object)entityzombievillager.getBukkitEntity()) : null;
    }

    public static Villager.Profession nmsToBukkitProfession(class_3852 nms) {
        return Villager.Profession.valueOf(class_7923.field_41195.method_10221((Object)nms).method_12832().toUpperCase(Locale.ROOT));
    }

    public static class_3852 bukkitToNmsProfession(Villager.Profession bukkit) {
        return (class_3852)class_7923.field_41195.method_10223(CraftNamespacedKey.toMinecraft(bukkit.getKey()));
    }
}

