/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_20_R1.generator;

import java.lang.ref.WeakReference;
import net.minecraft.class_1959;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2378;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2791;
import net.minecraft.class_6880;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Biome;
import org.bukkit.block.data.BlockData;
import org.bukkit.craftbukkit.v1_20_R1.block.CraftBlock;
import org.bukkit.craftbukkit.v1_20_R1.block.data.CraftBlockData;
import org.bukkit.craftbukkit.v1_20_R1.util.CraftMagicNumbers;
import org.bukkit.generator.ChunkGenerator;
import org.bukkit.material.MaterialData;

public final class CraftChunkData
implements ChunkGenerator.ChunkData {
    private final int maxHeight;
    private final int minHeight;
    private final WeakReference<class_2791> weakChunk;

    public CraftChunkData(World world, class_2791 chunkAccess) {
        this(world.getMaxHeight(), world.getMinHeight(), chunkAccess);
    }

    CraftChunkData(int maxHeight, int minHeight, class_2791 chunkAccess) {
        this.maxHeight = maxHeight;
        this.minHeight = minHeight;
        this.weakChunk = new WeakReference<class_2791>(chunkAccess);
    }

    public class_2791 getHandle() {
        class_2791 access = (class_2791)this.weakChunk.get();
        if (access == null) {
            throw new IllegalStateException("ChunkAccess no longer present, are you using it in a different tick?");
        }
        return access;
    }

    public void breakLink() {
        this.weakChunk.clear();
    }

    @Override
    public int getMaxHeight() {
        return this.maxHeight;
    }

    @Override
    public int getMinHeight() {
        return this.minHeight;
    }

    @Override
    public Biome getBiome(int x, int y, int z) {
        return CraftBlock.biomeBaseToBiome((class_2378<class_1959>)this.getHandle().bridge$biomeRegistry(), (class_6880<class_1959>)this.getHandle().method_16359(x >> 2, y >> 2, z >> 2));
    }

    @Override
    public void setBlock(int x, int y, int z, Material material) {
        this.setBlock(x, y, z, material.createBlockData());
    }

    @Override
    public void setBlock(int x, int y, int z, MaterialData material) {
        this.setBlock(x, y, z, CraftMagicNumbers.getBlock(material));
    }

    @Override
    public void setBlock(int x, int y, int z, BlockData blockData) {
        this.setBlock(x, y, z, ((CraftBlockData)blockData).getState());
    }

    @Override
    public void setRegion(int xMin, int yMin, int zMin, int xMax, int yMax, int zMax, Material material) {
        this.setRegion(xMin, yMin, zMin, xMax, yMax, zMax, material.createBlockData());
    }

    @Override
    public void setRegion(int xMin, int yMin, int zMin, int xMax, int yMax, int zMax, MaterialData material) {
        this.setRegion(xMin, yMin, zMin, xMax, yMax, zMax, CraftMagicNumbers.getBlock(material));
    }

    @Override
    public void setRegion(int xMin, int yMin, int zMin, int xMax, int yMax, int zMax, BlockData blockData) {
        this.setRegion(xMin, yMin, zMin, xMax, yMax, zMax, ((CraftBlockData)blockData).getState());
    }

    @Override
    public Material getType(int x, int y, int z) {
        return CraftMagicNumbers.getMaterial(this.getTypeId(x, y, z).method_26204());
    }

    @Override
    public MaterialData getTypeAndData(int x, int y, int z) {
        return CraftMagicNumbers.getMaterial(this.getTypeId(x, y, z));
    }

    @Override
    public BlockData getBlockData(int x, int y, int z) {
        return CraftBlockData.fromData(this.getTypeId(x, y, z));
    }

    public void setRegion(int xMin, int yMin, int zMin, int xMax, int yMax, int zMax, class_2680 type) {
        if (xMin > 15 || yMin >= this.maxHeight || zMin > 15) {
            return;
        }
        if (xMin < 0) {
            xMin = 0;
        }
        if (yMin < this.minHeight) {
            yMin = this.minHeight;
        }
        if (zMin < 0) {
            zMin = 0;
        }
        if (xMax > 16) {
            xMax = 16;
        }
        if (yMax > this.maxHeight) {
            yMax = this.maxHeight;
        }
        if (zMax > 16) {
            zMax = 16;
        }
        if (xMin >= xMax || yMin >= yMax || zMin >= zMax) {
            return;
        }
        for (int y = yMin; y < yMax; ++y) {
            for (int x = xMin; x < xMax; ++x) {
                for (int z = zMin; z < zMax; ++z) {
                    this.setBlock(x, y, z, type);
                }
            }
        }
    }

    public class_2680 getTypeId(int x, int y, int z) {
        if (x != (x & 0xF) || y < this.minHeight || y >= this.maxHeight || z != (z & 0xF)) {
            return class_2246.field_10124.method_9564();
        }
        class_2791 access = this.getHandle();
        return access.method_8320(class_2338.method_49637((double)(access.method_12004().method_8326() + x), (double)y, (double)(access.method_12004().method_8328() + z)));
    }

    @Override
    public byte getData(int x, int y, int z) {
        return CraftMagicNumbers.toLegacyData(this.getTypeId(x, y, z));
    }

    private void setBlock(int x, int y, int z, class_2680 type) {
        if (x != (x & 0xF) || y < this.minHeight || y >= this.maxHeight || z != (z & 0xF)) {
            return;
        }
        class_2791 access = this.getHandle();
        class_2338 blockPosition = class_2338.method_49637((double)(access.method_12004().method_8326() + x), (double)y, (double)(access.method_12004().method_8328() + z));
        class_2680 oldBlockData = access.method_12010(blockPosition, type, false);
        if (type.method_31709()) {
            class_2586 tileEntity = ((class_2343)type.method_26204()).method_10123(blockPosition, type);
            if (tileEntity == null) {
                access.method_12041(blockPosition);
            } else {
                access.method_12007(tileEntity);
            }
        } else if (oldBlockData != null && oldBlockData.method_31709()) {
            access.method_12041(blockPosition);
        }
    }
}

