/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_20_R1.persistence;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import org.apache.commons.lang3.Validate;
import org.bukkit.NamespacedKey;
import org.bukkit.craftbukkit.v1_20_R1.persistence.CraftPersistentDataAdapterContext;
import org.bukkit.craftbukkit.v1_20_R1.persistence.CraftPersistentDataTypeRegistry;
import org.bukkit.craftbukkit.v1_20_R1.util.CraftNBTTagConfigSerializer;
import org.bukkit.persistence.PersistentDataAdapterContext;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;

public class CraftPersistentDataContainer
implements PersistentDataContainer {
    private final Map<String, class_2520> customDataTags = new HashMap<String, class_2520>();
    private final CraftPersistentDataTypeRegistry registry;
    private final CraftPersistentDataAdapterContext adapterContext;

    public CraftPersistentDataContainer(Map<String, class_2520> customTags, CraftPersistentDataTypeRegistry registry) {
        this(registry);
        this.customDataTags.putAll(customTags);
    }

    public CraftPersistentDataContainer(CraftPersistentDataTypeRegistry registry) {
        this.registry = registry;
        this.adapterContext = new CraftPersistentDataAdapterContext(this.registry);
    }

    @Override
    public <T, Z> void set(NamespacedKey key, PersistentDataType<T, Z> type, Z value) {
        Validate.notNull((Object)key, (String)"The provided key for the custom value was null", (Object[])new Object[0]);
        Validate.notNull(type, (String)"The provided type for the custom value was null", (Object[])new Object[0]);
        Validate.notNull(value, (String)"The provided value for the custom value was null", (Object[])new Object[0]);
        this.customDataTags.put(key.toString(), this.registry.wrap(type.getPrimitiveType(), type.toPrimitive(value, this.adapterContext)));
    }

    @Override
    public <T, Z> boolean has(NamespacedKey key, PersistentDataType<T, Z> type) {
        Validate.notNull((Object)key, (String)"The provided key for the custom value was null", (Object[])new Object[0]);
        Validate.notNull(type, (String)"The provided type for the custom value was null", (Object[])new Object[0]);
        class_2520 value = this.customDataTags.get(key.toString());
        if (value == null) {
            return false;
        }
        return this.registry.isInstanceOf(type.getPrimitiveType(), value);
    }

    @Override
    public <T, Z> Z get(NamespacedKey key, PersistentDataType<T, Z> type) {
        Validate.notNull((Object)key, (String)"The provided key for the custom value was null", (Object[])new Object[0]);
        Validate.notNull(type, (String)"The provided type for the custom value was null", (Object[])new Object[0]);
        class_2520 value = this.customDataTags.get(key.toString());
        if (value == null) {
            return null;
        }
        return type.fromPrimitive(this.registry.extract(type.getPrimitiveType(), value), this.adapterContext);
    }

    @Override
    public <T, Z> Z getOrDefault(NamespacedKey key, PersistentDataType<T, Z> type, Z defaultValue) {
        Z z = this.get(key, type);
        return z != null ? z : defaultValue;
    }

    @Override
    public Set<NamespacedKey> getKeys() {
        HashSet<NamespacedKey> keys = new HashSet<NamespacedKey>();
        this.customDataTags.keySet().forEach(key -> {
            String[] keyData = key.split(":", 2);
            if (keyData.length == 2) {
                keys.add(new NamespacedKey(keyData[0], keyData[1]));
            }
        });
        return keys;
    }

    @Override
    public void remove(NamespacedKey key) {
        Validate.notNull((Object)key, (String)"The provided key for the custom value was null", (Object[])new Object[0]);
        this.customDataTags.remove(key.toString());
    }

    @Override
    public boolean isEmpty() {
        return this.customDataTags.isEmpty();
    }

    @Override
    public PersistentDataAdapterContext getAdapterContext() {
        return this.adapterContext;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof CraftPersistentDataContainer)) {
            return false;
        }
        Map<String, class_2520> myRawMap = this.getRaw();
        Map<String, class_2520> theirRawMap = ((CraftPersistentDataContainer)obj).getRaw();
        return Objects.equals(myRawMap, theirRawMap);
    }

    public class_2487 toTagCompound() {
        class_2487 tag = new class_2487();
        for (Map.Entry<String, class_2520> entry : this.customDataTags.entrySet()) {
            tag.method_10566(entry.getKey(), entry.getValue());
        }
        return tag;
    }

    public void put(String key, class_2520 base) {
        this.customDataTags.put(key, base);
    }

    public void putAll(Map<String, class_2520> map) {
        this.customDataTags.putAll(map);
    }

    public void putAll(class_2487 compound) {
        for (String key : compound.method_10541()) {
            this.customDataTags.put(key, compound.method_10580(key));
        }
    }

    public Map<String, class_2520> getRaw() {
        return this.customDataTags;
    }

    public CraftPersistentDataTypeRegistry getDataTagTypeRegistry() {
        return this.registry;
    }

    public int hashCode() {
        int hashCode = 3;
        return hashCode += this.customDataTags.hashCode();
    }

    public Map<String, Object> serialize() {
        return (Map)CraftNBTTagConfigSerializer.serialize((class_2520)this.toTagCompound());
    }
}

