/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_20_R1.scoreboard;

import net.minecraft.class_266;
import net.minecraft.class_269;
import org.apache.commons.lang3.Validate;
import org.bukkit.OfflinePlayer;
import org.bukkit.craftbukkit.v1_20_R1.scoreboard.CraftCriteria;
import org.bukkit.craftbukkit.v1_20_R1.scoreboard.CraftScore;
import org.bukkit.craftbukkit.v1_20_R1.scoreboard.CraftScoreboard;
import org.bukkit.craftbukkit.v1_20_R1.scoreboard.CraftScoreboardComponent;
import org.bukkit.craftbukkit.v1_20_R1.scoreboard.CraftScoreboardTranslations;
import org.bukkit.craftbukkit.v1_20_R1.util.CraftChatMessage;
import org.bukkit.scoreboard.Criteria;
import org.bukkit.scoreboard.DisplaySlot;
import org.bukkit.scoreboard.Objective;
import org.bukkit.scoreboard.RenderType;
import org.bukkit.scoreboard.Score;

final class CraftObjective
extends CraftScoreboardComponent
implements Objective {
    private final class_266 objective;
    private final CraftCriteria criteria;

    CraftObjective(CraftScoreboard scoreboard, class_266 objective) {
        super(scoreboard);
        this.objective = objective;
        this.criteria = CraftCriteria.getFromNMS(objective);
    }

    class_266 getHandle() {
        return this.objective;
    }

    @Override
    public String getName() throws IllegalStateException {
        CraftScoreboard scoreboard = this.checkState();
        return this.objective.method_1113();
    }

    @Override
    public String getDisplayName() throws IllegalStateException {
        CraftScoreboard scoreboard = this.checkState();
        return CraftChatMessage.fromComponent(this.objective.method_1114());
    }

    @Override
    public void setDisplayName(String displayName) throws IllegalStateException, IllegalArgumentException {
        Validate.notNull((Object)displayName, (String)"Display name cannot be null", (Object[])new Object[0]);
        Validate.isTrue((displayName.length() <= 128 ? 1 : 0) != 0, (String)("Display name '" + displayName + "' is longer than the limit of 128 characters"), (Object[])new Object[0]);
        CraftScoreboard scoreboard = this.checkState();
        this.objective.method_1121(CraftChatMessage.fromString(displayName)[0]);
    }

    @Override
    public String getCriteria() throws IllegalStateException {
        CraftScoreboard scoreboard = this.checkState();
        return this.criteria.bukkitName;
    }

    @Override
    public Criteria getTrackedCriteria() throws IllegalStateException {
        CraftScoreboard scoreboard = this.checkState();
        return this.criteria;
    }

    @Override
    public boolean isModifiable() throws IllegalStateException {
        CraftScoreboard scoreboard = this.checkState();
        return !this.criteria.criteria.method_1226();
    }

    @Override
    public void setDisplaySlot(DisplaySlot slot) throws IllegalStateException {
        CraftScoreboard scoreboard = this.checkState();
        class_269 board = scoreboard.board;
        class_266 objective = this.objective;
        for (int i = 0; i < 19; ++i) {
            if (board.method_1189(i) != objective) continue;
            board.method_1158(i, null);
        }
        if (slot != null) {
            int slotNumber = CraftScoreboardTranslations.fromBukkitSlot(slot);
            board.method_1158(slotNumber, this.getHandle());
        }
    }

    @Override
    public DisplaySlot getDisplaySlot() throws IllegalStateException {
        CraftScoreboard scoreboard = this.checkState();
        class_269 board = scoreboard.board;
        class_266 objective = this.objective;
        for (int i = 0; i < 19; ++i) {
            if (board.method_1189(i) != objective) continue;
            return CraftScoreboardTranslations.toBukkitSlot(i);
        }
        return null;
    }

    @Override
    public void setRenderType(RenderType renderType) throws IllegalStateException {
        Validate.notNull((Object)((Object)renderType), (String)"RenderType cannot be null", (Object[])new Object[0]);
        CraftScoreboard scoreboard = this.checkState();
        this.objective.method_1115(CraftScoreboardTranslations.fromBukkitRender(renderType));
    }

    @Override
    public RenderType getRenderType() throws IllegalStateException {
        CraftScoreboard scoreboard = this.checkState();
        return CraftScoreboardTranslations.toBukkitRender(this.objective.method_1118());
    }

    @Override
    public Score getScore(OfflinePlayer player) throws IllegalArgumentException, IllegalStateException {
        Validate.notNull((Object)player, (String)"Player cannot be null", (Object[])new Object[0]);
        CraftScoreboard scoreboard = this.checkState();
        return new CraftScore(this, player.getName());
    }

    @Override
    public Score getScore(String entry) throws IllegalArgumentException, IllegalStateException {
        Validate.notNull((Object)entry, (String)"Entry cannot be null", (Object[])new Object[0]);
        Validate.isTrue((entry.length() <= Short.MAX_VALUE ? 1 : 0) != 0, (String)("Score '" + entry + "' is longer than the limit of 32767 characters"), (Object[])new Object[0]);
        CraftScoreboard scoreboard = this.checkState();
        return new CraftScore(this, entry);
    }

    @Override
    public void unregister() throws IllegalStateException {
        CraftScoreboard scoreboard = this.checkState();
        scoreboard.board.method_1194(this.objective);
    }

    @Override
    CraftScoreboard checkState() throws IllegalStateException {
        if (((CraftScoreboard)this.getScoreboard()).board.method_1170(this.objective.method_1113()) == null) {
            throw new IllegalStateException("Unregistered scoreboard component");
        }
        return this.getScoreboard();
    }

    public int hashCode() {
        int hash = 7;
        hash = 31 * hash + (this.objective != null ? this.objective.hashCode() : 0);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CraftObjective other = (CraftObjective)obj;
        return this.objective == other.objective || this.objective != null && this.objective.equals(other.objective);
    }
}

