/*
 * Decompiled with CFR 0.152.
 */
package com.mohistmc.banner.command;

import com.google.common.collect.ImmutableList;
import java.util.List;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.defaults.BukkitCommand;
import org.jetbrains.annotations.NotNull;

public class ModListCommand
extends BukkitCommand {
    public ModListCommand(@NotNull String name) {
        super(name);
        this.description = "Gets the version of this server including any plugins in use";
        this.usageMessage = "/fabricmods";
        this.setPermission("banner.command.mods");
        this.setAliases(List.of("fabricmods"));
    }

    @Override
    public boolean execute(@NotNull CommandSender sender, @NotNull String commandLabel, @NotNull String[] args) {
        if (sender.hasPermission("banner.command.mods")) {
            StringBuilder mods = new StringBuilder();
            for (ModContainer mod : FabricLoader.getInstance().getAllMods()) {
                String name = mod.getMetadata().getName();
                if (name.startsWith("Fabric") && name.endsWith(")")) continue;
                if (name.startsWith("Fabric API Base")) {
                    name = "Fabric API";
                }
                if (name.startsWith("OpenJDK")) {
                    name = name.replace(" 64-Bit Server VM", "");
                }
                if (name.startsWith("Minecraft") || mods.toString().contains(name)) continue;
                mods.append(", " + ChatColor.GREEN).append(name).append((Object)ChatColor.WHITE);
            }
            sender.sendMessage("Mods: " + mods.substring(2));
        } else {
            sender.sendMessage("No Permission for command!");
        }
        return true;
    }

    @Override
    public List<String> tabComplete(CommandSender sender, String alias, String[] args) {
        return ImmutableList.of();
    }
}

