/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_20_R1;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.stream.Stream;
import net.minecraft.class_2378;
import net.minecraft.class_3195;
import net.minecraft.class_5455;
import net.minecraft.class_7151;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_8054;
import net.minecraft.class_8056;
import org.bukkit.Keyed;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.bukkit.craftbukkit.v1_20_R1.generator.strucutre.CraftStructure;
import org.bukkit.craftbukkit.v1_20_R1.generator.strucutre.CraftStructureType;
import org.bukkit.craftbukkit.v1_20_R1.inventory.trim.CraftTrimMaterial;
import org.bukkit.craftbukkit.v1_20_R1.inventory.trim.CraftTrimPattern;
import org.bukkit.craftbukkit.v1_20_R1.util.CraftNamespacedKey;
import org.bukkit.generator.structure.Structure;
import org.bukkit.generator.structure.StructureType;
import org.bukkit.inventory.meta.trim.TrimMaterial;
import org.bukkit.inventory.meta.trim.TrimPattern;

public class CraftRegistry<B extends Keyed, M>
implements Registry<B> {
    private final Map<NamespacedKey, B> cache = new HashMap<NamespacedKey, B>();
    private final class_2378<M> minecraftRegistry;
    private final BiFunction<NamespacedKey, M, B> minecraftToBukkit;

    public static <B extends Keyed> Registry<?> createRegistry(Class<B> bukkitClass, class_5455 registryHolder) {
        if (bukkitClass == Structure.class) {
            return new CraftRegistry<CraftStructure, class_3195>(registryHolder.method_30530(class_7924.field_41246), CraftStructure::new);
        }
        if (bukkitClass == StructureType.class) {
            return new CraftRegistry<CraftStructureType, class_7151>(class_7923.field_41147, CraftStructureType::new);
        }
        if (bukkitClass == TrimMaterial.class) {
            return new CraftRegistry<CraftTrimMaterial, class_8054>(registryHolder.method_30530(class_7924.field_42083), CraftTrimMaterial::new);
        }
        if (bukkitClass == TrimPattern.class) {
            return new CraftRegistry<CraftTrimPattern, class_8056>(registryHolder.method_30530(class_7924.field_42082), CraftTrimPattern::new);
        }
        return null;
    }

    public CraftRegistry(class_2378<M> minecraftRegistry, BiFunction<NamespacedKey, M, B> minecraftToBukkit) {
        this.minecraftRegistry = minecraftRegistry;
        this.minecraftToBukkit = minecraftToBukkit;
    }

    @Override
    public B get(NamespacedKey namespacedKey) {
        Keyed cached = (Keyed)this.cache.get(namespacedKey);
        if (cached != null) {
            return (B)cached;
        }
        B bukkit = this.createBukkit(namespacedKey, this.minecraftRegistry.method_17966(CraftNamespacedKey.toMinecraft(namespacedKey)).orElse(null));
        if (bukkit == null) {
            return null;
        }
        this.cache.put(namespacedKey, bukkit);
        return bukkit;
    }

    @Override
    public Iterator<B> iterator() {
        return this.values().iterator();
    }

    public B createBukkit(NamespacedKey namespacedKey, M minecraft) {
        if (minecraft == null) {
            return null;
        }
        return (B)((Keyed)this.minecraftToBukkit.apply(namespacedKey, minecraft));
    }

    public Stream<B> values() {
        return this.minecraftRegistry.method_10235().stream().map(minecraftKey -> this.get(CraftNamespacedKey.fromMinecraft(minecraftKey)));
    }
}

