/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_20_R1.ban;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.net.InetAddresses;
import java.net.InetAddress;
import java.time.Duration;
import java.time.Instant;
import java.util.Date;
import java.util.Set;
import net.minecraft.class_3317;
import net.minecraft.class_3320;
import net.minecraft.class_3330;
import org.bukkit.BanEntry;
import org.bukkit.ban.IpBanList;
import org.bukkit.craftbukkit.v1_20_R1.ban.CraftIpBanEntry;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CraftIpBanList
implements IpBanList {
    private final class_3317 list;

    public CraftIpBanList(class_3317 list) {
        this.list = list;
    }

    @Override
    public BanEntry<InetAddress> getBanEntry(String target) {
        Preconditions.checkArgument((target != null ? 1 : 0) != 0, (Object)"Target cannot be null");
        class_3320 entry = (class_3320)this.list.method_14640((Object)target);
        if (entry == null) {
            return null;
        }
        return new CraftIpBanEntry(target, entry, this.list);
    }

    @Override
    public BanEntry<InetAddress> getBanEntry(InetAddress target) {
        return this.getBanEntry(this.getIpFromAddress(target));
    }

    @Override
    public BanEntry<InetAddress> addBan(String target, String reason, Date expires, String source) {
        Preconditions.checkArgument((target != null ? 1 : 0) != 0, (Object)"Ban target cannot be null");
        class_3320 entry = new class_3320(target, new Date(), source == null || source.isBlank() ? null : source, expires, reason == null || reason.isBlank() ? null : reason);
        this.list.method_14633((class_3330)entry);
        return new CraftIpBanEntry(target, entry, this.list);
    }

    @Override
    @Nullable
    public BanEntry<InetAddress> addBan(@NotNull InetAddress target, @Nullable String reason, @Nullable Date expires, @Nullable String source) {
        return this.addBan(this.getIpFromAddress(target), reason, expires, source);
    }

    @Override
    public BanEntry<InetAddress> addBan(InetAddress target, String reason, Instant expires, String source) {
        Date date = expires != null ? Date.from(expires) : null;
        return this.addBan(target, reason, date, source);
    }

    @Override
    public BanEntry<InetAddress> addBan(InetAddress target, String reason, Duration duration, String source) {
        Instant instant = duration != null ? Instant.now().plus(duration) : null;
        return this.addBan(target, reason, instant, source);
    }

    @Override
    public Set<BanEntry> getBanEntries() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (String target : this.list.method_14636()) {
            class_3320 ipBanEntry = (class_3320)this.list.method_14640((Object)target);
            if (ipBanEntry == null) continue;
            builder.add((Object)new CraftIpBanEntry(target, ipBanEntry, this.list));
        }
        return builder.build();
    }

    @Override
    public Set<BanEntry<InetAddress>> getEntries() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (String target : this.list.method_14636()) {
            class_3320 ipBanEntry = (class_3320)this.list.method_14640((Object)target);
            if (ipBanEntry == null) continue;
            builder.add((Object)new CraftIpBanEntry(target, ipBanEntry, this.list));
        }
        return builder.build();
    }

    @Override
    public boolean isBanned(String target) {
        Preconditions.checkArgument((target != null ? 1 : 0) != 0, (Object)"Target cannot be null");
        return this.list.method_14529(target);
    }

    @Override
    public boolean isBanned(InetAddress target) {
        return this.isBanned(this.getIpFromAddress(target));
    }

    @Override
    public void pardon(String target) {
        Preconditions.checkArgument((target != null ? 1 : 0) != 0, (Object)"Target cannot be null");
        this.list.method_14635((Object)target);
    }

    @Override
    public void pardon(InetAddress target) {
        this.pardon(this.getIpFromAddress(target));
    }

    private String getIpFromAddress(InetAddress address) {
        if (address == null) {
            return null;
        }
        return InetAddresses.toAddrString((InetAddress)address);
    }
}

