/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_20_R1.inventory;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import com.mojang.authlib.GameProfile;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import net.minecraft.class_2487;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2631;
import net.minecraft.class_2960;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.OfflinePlayer;
import org.bukkit.configuration.serialization.DelegateDeserialization;
import org.bukkit.craftbukkit.v1_20_R1.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_20_R1.inventory.CraftMetaItem;
import org.bukkit.craftbukkit.v1_20_R1.profile.CraftPlayerProfile;
import org.bukkit.craftbukkit.v1_20_R1.util.CraftNamespacedKey;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.profile.PlayerProfile;

@DelegateDeserialization(value=CraftMetaItem.SerializableMeta.class)
class CraftMetaSkull
extends CraftMetaItem
implements SkullMeta {
    private static final Set<Material> SKULL_MATERIALS = Sets.newHashSet((Object[])new Material[]{Material.CREEPER_HEAD, Material.CREEPER_WALL_HEAD, Material.DRAGON_HEAD, Material.DRAGON_WALL_HEAD, Material.PIGLIN_HEAD, Material.PIGLIN_WALL_HEAD, Material.PLAYER_HEAD, Material.PLAYER_WALL_HEAD, Material.SKELETON_SKULL, Material.SKELETON_WALL_SKULL, Material.WITHER_SKELETON_SKULL, Material.WITHER_SKELETON_WALL_SKULL, Material.ZOMBIE_HEAD, Material.ZOMBIE_WALL_HEAD});
    static final CraftMetaItem.ItemMetaKey SKULL_PROFILE = new CraftMetaItem.ItemMetaKey("SkullProfile");
    static final CraftMetaItem.ItemMetaKey SKULL_OWNER = new CraftMetaItem.ItemMetaKey("SkullOwner", "skull-owner");
    static final CraftMetaItem.ItemMetaKey BLOCK_ENTITY_TAG = new CraftMetaItem.ItemMetaKey("BlockEntityTag");
    static final CraftMetaItem.ItemMetaKey NOTE_BLOCK_SOUND = new CraftMetaItem.ItemMetaKey("note_block_sound");
    static final int MAX_OWNER_LENGTH = 16;
    private GameProfile profile;
    private class_2487 serializedProfile;
    private class_2960 noteBlockSound;

    CraftMetaSkull(CraftMetaItem meta) {
        super(meta);
        if (!(meta instanceof CraftMetaSkull)) {
            return;
        }
        CraftMetaSkull skullMeta = (CraftMetaSkull)meta;
        this.setProfile(skullMeta.profile);
        this.noteBlockSound = skullMeta.noteBlockSound;
    }

    CraftMetaSkull(class_2487 tag) {
        super(tag);
        class_2487 nbtTagCompound;
        if (tag.method_10573(CraftMetaSkull.SKULL_OWNER.NBT, 10)) {
            this.setProfile(class_2512.method_10683((class_2487)tag.method_10562(CraftMetaSkull.SKULL_OWNER.NBT)));
        } else if (tag.method_10573(CraftMetaSkull.SKULL_OWNER.NBT, 8) && !tag.method_10558(CraftMetaSkull.SKULL_OWNER.NBT).isEmpty()) {
            this.setProfile(new GameProfile(null, tag.method_10558(CraftMetaSkull.SKULL_OWNER.NBT)));
        }
        if (tag.method_10573(CraftMetaSkull.BLOCK_ENTITY_TAG.NBT, 10) && (nbtTagCompound = tag.method_10562(CraftMetaSkull.BLOCK_ENTITY_TAG.NBT).method_10553()).method_10573(CraftMetaSkull.NOTE_BLOCK_SOUND.NBT, 8)) {
            this.noteBlockSound = class_2960.method_12829((String)nbtTagCompound.method_10558(CraftMetaSkull.NOTE_BLOCK_SOUND.NBT));
        }
    }

    CraftMetaSkull(Map<String, Object> map) {
        super(map);
        Object object;
        if (this.profile == null) {
            object = map.get(CraftMetaSkull.SKULL_OWNER.BUKKIT);
            if (object instanceof PlayerProfile) {
                this.setOwnerProfile((PlayerProfile)object);
            } else {
                this.setOwner(CraftMetaItem.SerializableMeta.getString(map, CraftMetaSkull.SKULL_OWNER.BUKKIT, true));
            }
        }
        if (this.noteBlockSound == null) {
            object = map.get(CraftMetaSkull.NOTE_BLOCK_SOUND.BUKKIT);
            if (object instanceof NamespacedKey) {
                this.setNoteBlockSound((NamespacedKey)object);
            } else {
                this.setNoteBlockSound(CraftMetaItem.SerializableMeta.getObject(NamespacedKey.class, map, CraftMetaSkull.NOTE_BLOCK_SOUND.BUKKIT, true));
            }
        }
    }

    @Override
    void deserializeInternal(class_2487 tag, Object context) {
        class_2487 nbtTagCompound;
        super.deserializeInternal(tag, context);
        if (tag.method_10573(CraftMetaSkull.SKULL_PROFILE.NBT, 10)) {
            class_2487 skullTag = tag.method_10562(CraftMetaSkull.SKULL_PROFILE.NBT);
            if (skullTag.method_10573("Id", 8)) {
                UUID uuid = UUID.fromString(skullTag.method_10558("Id"));
                skullTag.method_25927("Id", uuid);
            }
            this.setProfile(class_2512.method_10683((class_2487)skullTag));
        }
        if (tag.method_10573(CraftMetaSkull.BLOCK_ENTITY_TAG.NBT, 10) && (nbtTagCompound = tag.method_10562(CraftMetaSkull.BLOCK_ENTITY_TAG.NBT).method_10553()).method_10573(CraftMetaSkull.NOTE_BLOCK_SOUND.NBT, 8)) {
            this.noteBlockSound = class_2960.method_12829((String)nbtTagCompound.method_10558(CraftMetaSkull.NOTE_BLOCK_SOUND.NBT));
        }
    }

    private void setProfile(GameProfile profile) {
        this.profile = profile;
        this.serializedProfile = profile == null ? null : class_2512.method_10684((class_2487)new class_2487(), (GameProfile)profile);
    }

    @Override
    void applyToItem(class_2487 tag) {
        super.applyToItem(tag);
        if (this.profile != null) {
            tag.method_10566(CraftMetaSkull.SKULL_OWNER.NBT, (class_2520)this.serializedProfile);
            class_2631.method_11335((GameProfile)this.profile, filledProfile -> {
                this.setProfile((GameProfile)filledProfile);
                tag.method_10566(CraftMetaSkull.SKULL_OWNER.NBT, (class_2520)this.serializedProfile);
            });
        }
        if (this.noteBlockSound != null) {
            class_2487 nbtTagCompound = new class_2487();
            nbtTagCompound.method_10582(CraftMetaSkull.NOTE_BLOCK_SOUND.NBT, this.noteBlockSound.toString());
            tag.method_10566(CraftMetaSkull.BLOCK_ENTITY_TAG.NBT, (class_2520)nbtTagCompound);
        }
    }

    @Override
    boolean isEmpty() {
        return super.isEmpty() && this.isSkullEmpty();
    }

    boolean isSkullEmpty() {
        return this.profile == null && this.noteBlockSound == null;
    }

    @Override
    boolean applicableTo(Material type) {
        return SKULL_MATERIALS.contains(type);
    }

    @Override
    public CraftMetaSkull clone() {
        return (CraftMetaSkull)super.clone();
    }

    @Override
    public boolean hasOwner() {
        return this.profile != null && this.profile.getName() != null;
    }

    @Override
    public String getOwner() {
        return this.hasOwner() ? this.profile.getName() : null;
    }

    @Override
    public OfflinePlayer getOwningPlayer() {
        if (this.hasOwner()) {
            if (this.profile.getId() != null) {
                return Bukkit.getOfflinePlayer(this.profile.getId());
            }
            if (this.profile.getName() != null) {
                return Bukkit.getOfflinePlayer(this.profile.getName());
            }
        }
        return null;
    }

    @Override
    public boolean setOwner(String name) {
        if (name != null && name.length() > 16) {
            return false;
        }
        if (name == null) {
            this.setProfile(null);
        } else {
            this.setProfile(new GameProfile(null, name));
        }
        return true;
    }

    @Override
    public boolean setOwningPlayer(OfflinePlayer owner) {
        if (owner == null) {
            this.setProfile(null);
        } else if (owner instanceof CraftPlayer) {
            this.setProfile(((CraftPlayer)owner).getProfile());
        } else {
            this.setProfile(new GameProfile(owner.getUniqueId(), owner.getName()));
        }
        return true;
    }

    @Override
    public PlayerProfile getOwnerProfile() {
        if (!this.hasOwner()) {
            return null;
        }
        return new CraftPlayerProfile(this.profile);
    }

    @Override
    public void setOwnerProfile(PlayerProfile profile) {
        if (profile == null) {
            this.setProfile(null);
        } else {
            this.setProfile(CraftPlayerProfile.validateSkullProfile(((CraftPlayerProfile)profile).buildGameProfile()));
        }
    }

    @Override
    public void setNoteBlockSound(NamespacedKey noteBlockSound) {
        this.noteBlockSound = noteBlockSound == null ? null : CraftNamespacedKey.toMinecraft(noteBlockSound);
    }

    @Override
    public NamespacedKey getNoteBlockSound() {
        return this.noteBlockSound == null ? null : CraftNamespacedKey.fromMinecraft(this.noteBlockSound);
    }

    @Override
    int applyHash() {
        int original;
        int hash = original = super.applyHash();
        if (this.hasOwner()) {
            hash = 61 * hash + this.profile.hashCode();
        }
        if (this.noteBlockSound != null) {
            hash = 61 * hash + this.noteBlockSound.hashCode();
        }
        return original != hash ? CraftMetaSkull.class.hashCode() ^ hash : hash;
    }

    @Override
    boolean equalsCommon(CraftMetaItem meta) {
        if (!super.equalsCommon(meta)) {
            return false;
        }
        if (meta instanceof CraftMetaSkull) {
            CraftMetaSkull that = (CraftMetaSkull)meta;
            return (this.profile != null ? that.profile != null && this.serializedProfile.equals((Object)that.serializedProfile) : that.profile == null) && Objects.equals(this.noteBlockSound, that.noteBlockSound);
        }
        return true;
    }

    @Override
    boolean notUncommon(CraftMetaItem meta) {
        return super.notUncommon(meta) && (meta instanceof CraftMetaSkull || this.isSkullEmpty());
    }

    @Override
    ImmutableMap.Builder<String, Object> serialize(ImmutableMap.Builder<String, Object> builder) {
        super.serialize(builder);
        if (this.profile != null) {
            return builder.put((Object)CraftMetaSkull.SKULL_OWNER.BUKKIT, (Object)new CraftPlayerProfile(this.profile));
        }
        NamespacedKey namespacedKeyNB = this.getNoteBlockSound();
        if (namespacedKeyNB != null) {
            return builder.put((Object)CraftMetaSkull.NOTE_BLOCK_SOUND.BUKKIT, (Object)namespacedKeyNB);
        }
        return builder;
    }
}

