/*
 * Decompiled with CFR 0.152.
 */
package com.mohistmc.banner.bukkit.nms.remappers;

import com.mohistmc.banner.bukkit.nms.remappers.BannerClassRepo;
import com.mohistmc.banner.bukkit.nms.utils.RemapUtils;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import net.md_5.specialsource.provider.InheritanceProvider;
import org.objectweb.asm.tree.ClassNode;

public class BannerInheritanceProvider
implements InheritanceProvider {
    public Set<String> getParents(String className) {
        if (className.startsWith("org/springframework/")) {
            return null;
        }
        return this.fineParents(className, true);
    }

    protected Set<String> fineParents(String className, boolean remap) {
        if (className.startsWith("net/minecraft/")) {
            return this.fineNMSParents(className, remap);
        }
        return this.findNormalParents(className, remap);
    }

    protected Set<String> fineNMSParents(String className, boolean remap) {
        if (remap) {
            className = RemapUtils.map(className);
        }
        HashSet<String> parents = new HashSet<String>();
        try {
            Class<?> reference = Class.forName(className.replace('/', '.'), false, this.getClass().getClassLoader());
            Class<?> extend = reference.getSuperclass();
            if (extend != null) {
                parents.add(RemapUtils.reverseMap(extend));
            }
            for (Class<?> inter : reference.getInterfaces()) {
                if (inter == null) continue;
                parents.add(RemapUtils.reverseMap(inter));
            }
            return parents;
        }
        catch (Exception exception) {
            return parents;
        }
    }

    protected Set<String> findNormalParents(String className, boolean remap) {
        ClassNode cn = BannerClassRepo.getInstance().findClass(className);
        if (cn == null) {
            if (!remap) {
                return null;
            }
            String remapClassName = RemapUtils.map(className);
            if (Objects.equals(remapClassName, className)) {
                return null;
            }
            return this.fineParents(remapClassName, false);
        }
        HashSet<String> parents = new HashSet<String>();
        if (cn.superName != null) {
            parents.add(RemapUtils.reverseMap(cn.superName));
        }
        if (cn.interfaces != null) {
            for (String anInterface : cn.interfaces) {
                parents.add(RemapUtils.reverseMap(anInterface));
            }
        }
        return parents.isEmpty() ? null : parents;
    }
}

