/*
 * Decompiled with CFR 0.152.
 */
package com.mohistmc.banner.stackdeobf.http;

import com.mohistmc.banner.BannerMCStart;
import com.mohistmc.banner.stackdeobf.http.FailedHttpRequestException;
import com.mohistmc.banner.stackdeobf.util.CompatUtil;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ForkJoinPool;
import org.apache.commons.io.FileUtils;

public final class HttpUtil {
    private static final Map<Executor, HttpClient> HTTP = new WeakHashMap<Executor, HttpClient>();

    private HttpUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static HttpClient getHttpClient(Executor executor) {
        Map<Executor, HttpClient> map = HTTP;
        synchronized (map) {
            return HTTP.computeIfAbsent(executor, $ -> HttpClient.newBuilder().executor(executor).build());
        }
    }

    public static byte[] getSync(URI uri) {
        return HttpUtil.getSync(uri, ForkJoinPool.commonPool());
    }

    public static byte[] getSync(URI uri, Executor executor) {
        return HttpUtil.getAsync(uri, executor).join();
    }

    public static CompletableFuture<byte[]> getAsync(URI uri) {
        return HttpUtil.getAsync(uri, ForkJoinPool.commonPool());
    }

    public static CompletableFuture<byte[]> getAsync(URI uri, Executor executor) {
        HttpRequest request = HttpRequest.newBuilder(uri).build();
        HttpResponse.BodyHandler<byte[]> handler = HttpResponse.BodyHandlers.ofByteArray();
        CompatUtil.LOGGER.info(BannerMCStart.I18N.get("stackdeobf.requesting"), (Object)uri);
        long start = System.currentTimeMillis();
        return HttpUtil.getHttpClient(executor).sendAsync(request, handler).thenApplyAsync(resp -> {
            long timeDiff = System.currentTimeMillis() - start;
            byte[] bodyBytes = (byte[])resp.body();
            String message = BannerMCStart.I18N.get("stackdeobf.received");
            Object[] args = new Object[]{bodyBytes.length, FileUtils.byteCountToDisplaySize((long)bodyBytes.length), resp.statusCode(), uri, timeDiff};
            if (!HttpUtil.isSuccess(resp.statusCode())) {
                CompatUtil.LOGGER.error(message, args);
                throw new FailedHttpRequestException((HttpResponse<?>)resp);
            }
            CompatUtil.LOGGER.info(message, args);
            return bodyBytes;
        }, executor);
    }

    private static boolean isSuccess(int code) {
        return code >= 200 && code <= 299;
    }
}

