/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_20_R1.block;

import net.minecraft.class_1263;
import net.minecraft.class_1799;
import net.minecraft.class_2387;
import net.minecraft.class_2586;
import net.minecraft.class_2619;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import org.bukkit.Effect;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Jukebox;
import org.bukkit.craftbukkit.v1_20_R1.CraftWorld;
import org.bukkit.craftbukkit.v1_20_R1.block.CraftBlockEntityState;
import org.bukkit.craftbukkit.v1_20_R1.inventory.CraftInventoryJukebox;
import org.bukkit.craftbukkit.v1_20_R1.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_20_R1.util.CraftMagicNumbers;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.JukeboxInventory;

public class CraftJukebox
extends CraftBlockEntityState<class_2619>
implements Jukebox {
    public CraftJukebox(World world, class_2619 te) {
        super(world, te);
    }

    @Override
    public JukeboxInventory getSnapshotInventory() {
        return new CraftInventoryJukebox((class_1263)this.getSnapshot());
    }

    @Override
    public JukeboxInventory getInventory() {
        if (!this.isPlaced()) {
            return this.getSnapshotInventory();
        }
        return new CraftInventoryJukebox((class_1263)this.getTileEntity());
    }

    @Override
    public boolean update(boolean force, boolean applyPhysics) {
        boolean result = super.update(force, applyPhysics);
        if (result && this.isPlaced() && this.getType() == Material.JUKEBOX) {
            Material record = this.getPlaying();
            this.getWorldHandle().method_8652(this.getPosition(), this.data, 3);
            class_2586 tileEntity = this.getTileEntityFromWorld();
            if (tileEntity instanceof class_2619) {
                class_2619 jukebox = (class_2619)tileEntity;
                CraftWorld world = (CraftWorld)this.getWorld();
                if (record.isAir()) {
                    jukebox.method_49210(class_1799.field_8037);
                    world.playEffect(this.getLocation(), Effect.IRON_DOOR_CLOSE, 0);
                } else {
                    world.playEffect(this.getLocation(), Effect.RECORD_PLAY, record);
                }
            }
        }
        return result;
    }

    @Override
    public Material getPlaying() {
        return this.getRecord().getType();
    }

    @Override
    public void setPlaying(Material record) {
        if (record == null || CraftMagicNumbers.getItem(record) == null) {
            record = Material.AIR;
        }
        this.setRecord(new ItemStack(record));
    }

    @Override
    public boolean hasRecord() {
        return (Boolean)this.getHandle().method_11654((class_2769)class_2387.field_11180) != false && !this.getPlaying().isAir();
    }

    @Override
    public ItemStack getRecord() {
        class_1799 record = ((class_2619)this.getSnapshot()).method_49274();
        return CraftItemStack.asBukkitCopy(record);
    }

    @Override
    public void setRecord(ItemStack record) {
        class_1799 nms = CraftItemStack.asNMSCopy(record);
        class_2619 snapshot = (class_2619)this.getSnapshot();
        snapshot.method_49210(nms);
        snapshot.field_39483 = snapshot.field_39482;
        snapshot.field_39484 = !nms.method_7960();
        this.data = (class_2680)this.data.method_11657((class_2769)class_2387.field_11180, (Comparable)Boolean.valueOf(!nms.method_7960()));
    }

    @Override
    public boolean isPlaying() {
        class_2619 jukebox;
        this.requirePlaced();
        class_2586 tileEntity = this.getTileEntityFromWorld();
        return tileEntity instanceof class_2619 && (jukebox = (class_2619)tileEntity).method_44373();
    }

    @Override
    public boolean startPlaying() {
        this.requirePlaced();
        class_2586 tileEntity = this.getTileEntityFromWorld();
        if (!(tileEntity instanceof class_2619)) {
            return false;
        }
        class_2619 jukebox = (class_2619)tileEntity;
        class_1799 record = jukebox.method_49274();
        if (record.method_7960() || this.isPlaying()) {
            return false;
        }
        jukebox.field_39484 = true;
        jukebox.field_39483 = jukebox.field_39482;
        this.getWorld().playEffect(this.getLocation(), Effect.RECORD_PLAY, CraftMagicNumbers.getMaterial(record.method_7909()));
        return true;
    }

    @Override
    public void stopPlaying() {
        this.requirePlaced();
        class_2586 tileEntity = this.getTileEntityFromWorld();
        if (!(tileEntity instanceof class_2619)) {
            return;
        }
        class_2619 jukebox = (class_2619)tileEntity;
        jukebox.field_39484 = false;
        this.getWorld().playEffect(this.getLocation(), Effect.IRON_DOOR_CLOSE, 0);
    }

    @Override
    public boolean eject() {
        this.ensureNoWorldGeneration();
        class_2586 tileEntity = this.getTileEntityFromWorld();
        if (!(tileEntity instanceof class_2619)) {
            return false;
        }
        class_2619 jukebox = (class_2619)tileEntity;
        boolean result = !jukebox.method_49274().method_7960();
        jukebox.method_49213();
        return result;
    }
}

