/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_20_R1.entity;

import com.google.common.base.Preconditions;
import java.util.UUID;
import net.minecraft.class_1263;
import net.minecraft.class_1429;
import net.minecraft.class_1496;
import net.minecraft.class_5134;
import org.bukkit.craftbukkit.v1_20_R1.CraftServer;
import org.bukkit.craftbukkit.v1_20_R1.entity.CraftAnimals;
import org.bukkit.craftbukkit.v1_20_R1.inventory.CraftInventoryAbstractHorse;
import org.bukkit.entity.AbstractHorse;
import org.bukkit.entity.AnimalTamer;
import org.bukkit.entity.Horse;
import org.bukkit.inventory.AbstractHorseInventory;

public abstract class CraftAbstractHorse
extends CraftAnimals
implements AbstractHorse {
    public CraftAbstractHorse(CraftServer server, class_1496 entity) {
        super(server, (class_1429)entity);
    }

    public class_1496 getHandle() {
        return (class_1496)this.entity;
    }

    @Override
    public void setVariant(Horse.Variant variant) {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public int getDomestication() {
        return this.getHandle().method_6729();
    }

    @Override
    public void setDomestication(int value) {
        Preconditions.checkArgument((value >= 0 && value <= this.getMaxDomestication() ? 1 : 0) != 0, (String)"Domestication level (%s) need to be between %s and %s (max domestication)", (Object)value, (Object)0, (Object)this.getMaxDomestication());
        this.getHandle().method_6749(value);
    }

    @Override
    public int getMaxDomestication() {
        return this.getHandle().method_6755();
    }

    @Override
    public void setMaxDomestication(int value) {
        Preconditions.checkArgument((value > 0 ? 1 : 0) != 0, (String)"Max domestication (%s) cannot be zero or less", (int)value);
        this.getHandle().banner$setMaxDomestication(value);
    }

    @Override
    public double getJumpStrength() {
        return this.getHandle().method_6771();
    }

    @Override
    public void setJumpStrength(double strength) {
        Preconditions.checkArgument((strength >= 0.0 ? 1 : 0) != 0, (String)"Jump strength (%s) cannot be less than zero", (Object)strength);
        this.getHandle().method_5996(class_5134.field_23728).method_6192(strength);
    }

    @Override
    public boolean isTamed() {
        return this.getHandle().method_6727();
    }

    @Override
    public void setTamed(boolean tamed) {
        this.getHandle().method_6766(tamed);
    }

    @Override
    public AnimalTamer getOwner() {
        if (this.getOwnerUUID() == null) {
            return null;
        }
        return this.getServer().getOfflinePlayer(this.getOwnerUUID());
    }

    @Override
    public void setOwner(AnimalTamer owner) {
        if (owner != null) {
            this.setTamed(true);
            this.getHandle().setTarget(null, null, false);
            this.setOwnerUUID(owner.getUniqueId());
        } else {
            this.setTamed(false);
            this.setOwnerUUID(null);
        }
    }

    public UUID getOwnerUUID() {
        return this.getHandle().method_6139();
    }

    public void setOwnerUUID(UUID uuid) {
        this.getHandle().method_6732(uuid);
    }

    @Override
    public boolean isEatingHaystack() {
        return this.getHandle().method_6724();
    }

    @Override
    public void setEatingHaystack(boolean eatingHaystack) {
        this.getHandle().method_6740(eatingHaystack);
    }

    @Override
    public AbstractHorseInventory getInventory() {
        return new CraftInventoryAbstractHorse((class_1263)this.getHandle().field_6962);
    }
}

