/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_20_R1.inventory;

import com.google.common.base.Preconditions;
import net.minecraft.class_1304;
import net.minecraft.class_1308;
import org.bukkit.craftbukkit.v1_20_R1.CraftEquipmentSlot;
import org.bukkit.craftbukkit.v1_20_R1.entity.CraftLivingEntity;
import org.bukkit.craftbukkit.v1_20_R1.inventory.CraftItemStack;
import org.bukkit.entity.Entity;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;

public class CraftEntityEquipment
implements EntityEquipment {
    private final CraftLivingEntity entity;

    public CraftEntityEquipment(CraftLivingEntity entity) {
        this.entity = entity;
    }

    @Override
    public void setItem(EquipmentSlot slot, ItemStack item) {
        this.setItem(slot, item, false);
    }

    @Override
    public void setItem(EquipmentSlot slot, ItemStack item, boolean silent) {
        Preconditions.checkArgument((slot != null ? 1 : 0) != 0, (Object)"slot must not be null");
        class_1304 nmsSlot = CraftEquipmentSlot.getNMS(slot);
        this.setEquipment(nmsSlot, item, silent);
    }

    @Override
    public ItemStack getItem(EquipmentSlot slot) {
        Preconditions.checkArgument((slot != null ? 1 : 0) != 0, (Object)"slot must not be null");
        class_1304 nmsSlot = CraftEquipmentSlot.getNMS(slot);
        return this.getEquipment(nmsSlot);
    }

    @Override
    public ItemStack getItemInMainHand() {
        return this.getEquipment(class_1304.field_6173);
    }

    @Override
    public void setItemInMainHand(ItemStack item) {
        this.setItemInMainHand(item, false);
    }

    @Override
    public void setItemInMainHand(ItemStack item, boolean silent) {
        this.setEquipment(class_1304.field_6173, item, silent);
    }

    @Override
    public ItemStack getItemInOffHand() {
        return this.getEquipment(class_1304.field_6171);
    }

    @Override
    public void setItemInOffHand(ItemStack item) {
        this.setItemInOffHand(item, false);
    }

    @Override
    public void setItemInOffHand(ItemStack item, boolean silent) {
        this.setEquipment(class_1304.field_6171, item, silent);
    }

    @Override
    public ItemStack getItemInHand() {
        return this.getItemInMainHand();
    }

    @Override
    public void setItemInHand(ItemStack stack) {
        this.setItemInMainHand(stack);
    }

    @Override
    public ItemStack getHelmet() {
        return this.getEquipment(class_1304.field_6169);
    }

    @Override
    public void setHelmet(ItemStack helmet) {
        this.setHelmet(helmet, false);
    }

    @Override
    public void setHelmet(ItemStack helmet, boolean silent) {
        this.setEquipment(class_1304.field_6169, helmet, silent);
    }

    @Override
    public ItemStack getChestplate() {
        return this.getEquipment(class_1304.field_6174);
    }

    @Override
    public void setChestplate(ItemStack chestplate) {
        this.setChestplate(chestplate, false);
    }

    @Override
    public void setChestplate(ItemStack chestplate, boolean silent) {
        this.setEquipment(class_1304.field_6174, chestplate, silent);
    }

    @Override
    public ItemStack getLeggings() {
        return this.getEquipment(class_1304.field_6172);
    }

    @Override
    public void setLeggings(ItemStack leggings) {
        this.setLeggings(leggings, false);
    }

    @Override
    public void setLeggings(ItemStack leggings, boolean silent) {
        this.setEquipment(class_1304.field_6172, leggings, silent);
    }

    @Override
    public ItemStack getBoots() {
        return this.getEquipment(class_1304.field_6166);
    }

    @Override
    public void setBoots(ItemStack boots) {
        this.setBoots(boots, false);
    }

    @Override
    public void setBoots(ItemStack boots, boolean silent) {
        this.setEquipment(class_1304.field_6166, boots, silent);
    }

    @Override
    public ItemStack[] getArmorContents() {
        ItemStack[] armor = new ItemStack[]{this.getEquipment(class_1304.field_6166), this.getEquipment(class_1304.field_6172), this.getEquipment(class_1304.field_6174), this.getEquipment(class_1304.field_6169)};
        return armor;
    }

    @Override
    public void setArmorContents(ItemStack[] items) {
        this.setEquipment(class_1304.field_6166, items.length >= 1 ? items[0] : null, false);
        this.setEquipment(class_1304.field_6172, items.length >= 2 ? items[1] : null, false);
        this.setEquipment(class_1304.field_6174, items.length >= 3 ? items[2] : null, false);
        this.setEquipment(class_1304.field_6169, items.length >= 4 ? items[3] : null, false);
    }

    private ItemStack getEquipment(class_1304 slot) {
        return CraftItemStack.asBukkitCopy(this.entity.getHandle().method_6118(slot));
    }

    private void setEquipment(class_1304 slot, ItemStack stack, boolean silent) {
        this.entity.getHandle().setItemSlot(slot, CraftItemStack.asNMSCopy(stack), silent);
    }

    @Override
    public void clear() {
        for (class_1304 slot : class_1304.values()) {
            this.setEquipment(slot, null, false);
        }
    }

    @Override
    public Entity getHolder() {
        return this.entity;
    }

    @Override
    public float getItemInHandDropChance() {
        return this.getItemInMainHandDropChance();
    }

    @Override
    public void setItemInHandDropChance(float chance) {
        this.setItemInMainHandDropChance(chance);
    }

    @Override
    public float getItemInMainHandDropChance() {
        return this.getDropChance(class_1304.field_6173);
    }

    @Override
    public void setItemInMainHandDropChance(float chance) {
        this.setDropChance(class_1304.field_6173, chance);
    }

    @Override
    public float getItemInOffHandDropChance() {
        return this.getDropChance(class_1304.field_6171);
    }

    @Override
    public void setItemInOffHandDropChance(float chance) {
        this.setDropChance(class_1304.field_6171, chance);
    }

    @Override
    public float getHelmetDropChance() {
        return this.getDropChance(class_1304.field_6169);
    }

    @Override
    public void setHelmetDropChance(float chance) {
        this.setDropChance(class_1304.field_6169, chance);
    }

    @Override
    public float getChestplateDropChance() {
        return this.getDropChance(class_1304.field_6174);
    }

    @Override
    public void setChestplateDropChance(float chance) {
        this.setDropChance(class_1304.field_6174, chance);
    }

    @Override
    public float getLeggingsDropChance() {
        return this.getDropChance(class_1304.field_6172);
    }

    @Override
    public void setLeggingsDropChance(float chance) {
        this.setDropChance(class_1304.field_6172, chance);
    }

    @Override
    public float getBootsDropChance() {
        return this.getDropChance(class_1304.field_6166);
    }

    @Override
    public void setBootsDropChance(float chance) {
        this.setDropChance(class_1304.field_6166, chance);
    }

    private void setDropChance(class_1304 slot, float chance) {
        Preconditions.checkArgument((boolean)(this.entity.getHandle() instanceof class_1308), (Object)"Cannot set drop chance for non-Mob entity");
        if (slot == class_1304.field_6173 || slot == class_1304.field_6171) {
            ((class_1308)this.entity.getHandle()).field_6187[slot.method_5927()] = chance;
        } else {
            ((class_1308)this.entity.getHandle()).field_6186[slot.method_5927()] = chance;
        }
    }

    private float getDropChance(class_1304 slot) {
        if (!(this.entity.getHandle() instanceof class_1308)) {
            return 1.0f;
        }
        if (slot == class_1304.field_6173 || slot == class_1304.field_6171) {
            return ((class_1308)this.entity.getHandle()).field_6187[slot.method_5927()];
        }
        return ((class_1308)this.entity.getHandle()).field_6186[slot.method_5927()];
    }
}

