/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_20_R1.entity;

import com.google.common.base.Preconditions;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_3414;
import org.bukkit.Bukkit;
import org.bukkit.NamespacedKey;
import org.bukkit.Sound;
import org.bukkit.craftbukkit.v1_20_R1.CraftServer;
import org.bukkit.craftbukkit.v1_20_R1.CraftSound;
import org.bukkit.craftbukkit.v1_20_R1.entity.CraftLivingEntity;
import org.bukkit.craftbukkit.v1_20_R1.util.CraftNamespacedKey;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Mob;
import org.bukkit.loot.LootTable;

public abstract class CraftMob
extends CraftLivingEntity
implements Mob {
    public CraftMob(CraftServer server, class_1308 entity) {
        super(server, (class_1309)entity);
    }

    @Override
    public void setTarget(LivingEntity target) {
        Preconditions.checkState((!this.getHandle().bridge$generation() ? 1 : 0) != 0, (Object)"Cannot set target during world generation");
        class_1308 entity = this.getHandle();
        if (target == null) {
            entity.setTarget(null, null, false);
        } else if (target instanceof CraftLivingEntity) {
            entity.setTarget(((CraftLivingEntity)target).getHandle(), null, false);
        }
    }

    @Override
    public CraftLivingEntity getTarget() {
        if (this.getHandle().method_5968() == null) {
            return null;
        }
        return (CraftLivingEntity)this.getHandle().method_5968().getBukkitEntity();
    }

    @Override
    public void setAware(boolean aware) {
        this.getHandle().banner$setAware(aware);
    }

    @Override
    public boolean isAware() {
        return this.getHandle().bridge$aware();
    }

    @Override
    public Sound getAmbientSound() {
        class_3414 sound = this.getHandle().getAmbientSound0();
        return sound != null ? CraftSound.getBukkit(sound) : null;
    }

    public class_1308 getHandle() {
        return (class_1308)this.entity;
    }

    @Override
    public String toString() {
        return "CraftMob";
    }

    @Override
    public void setLootTable(LootTable table) {
        this.getHandle().field_6198 = table == null ? null : CraftNamespacedKey.toMinecraft(table.getKey());
    }

    @Override
    public LootTable getLootTable() {
        NamespacedKey key = CraftNamespacedKey.fromMinecraft(this.getHandle().method_5989());
        return Bukkit.getLootTable(key);
    }

    @Override
    public void setSeed(long seed) {
        this.getHandle().field_6184 = seed;
    }

    @Override
    public long getSeed() {
        return this.getHandle().field_6184;
    }
}

