/*
 * Decompiled with CFR 0.152.
 */
package com.mohistmc.banner.bukkit.remapping;

import com.google.common.io.ByteStreams;
import com.mohistmc.banner.bukkit.remapping.GlobalClassRepo;
import com.mohistmc.banner.bukkit.remapping.Remapper;
import com.mohistmc.banner.bukkit.remapping.Unsafe;
import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.MethodHandle;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.util.Hashtable;
import net.md_5.specialsource.repo.ClassRepo;

public class RemapSourceHandler
extends URLStreamHandler {
    @Override
    protected URLConnection openConnection(URL u) throws IOException {
        return new RemapSourceConnection(new URL(u.getFile()));
    }

    public static void register() {
        try {
            Unsafe.ensureClassInitialized(URL.class);
            MethodHandle getter = Unsafe.lookup().findStaticGetter(URL.class, "handlers", Hashtable.class);
            Hashtable handlers = getter.invokeExact();
            handlers.put("remap", new RemapSourceHandler());
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    private static class RemapSourceConnection
    extends URLConnection {
        private byte[] array;

        protected RemapSourceConnection(URL url) {
            super(url);
        }

        @Override
        public void connect() throws IOException {
            byte[] bytes = ByteStreams.toByteArray((InputStream)this.url.openStream());
            this.array = Remapper.getResourceMapper().remapClassFile(bytes, (ClassRepo)GlobalClassRepo.INSTANCE);
        }

        @Override
        public InputStream getInputStream() throws IOException {
            this.connect();
            if (this.array == null) {
                throw new FileNotFoundException(this.url.getFile());
            }
            return new ByteArrayInputStream(this.array);
        }
    }
}

