/*
 * Decompiled with CFR 0.152.
 */
package com.mohistmc.banner.fabric;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableMap;
import com.mohistmc.banner.BannerServer;
import com.mohistmc.banner.api.ServerAPI;
import com.mohistmc.banner.bukkit.type.BannerPotionEffect;
import com.mohistmc.banner.util.I18n;
import com.mohistmc.dynamicenum.MohistDynamEnum;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1299;
import net.minecraft.class_1311;
import net.minecraft.class_1527;
import net.minecraft.class_1535;
import net.minecraft.class_1792;
import net.minecraft.class_1842;
import net.minecraft.class_1847;
import net.minecraft.class_1887;
import net.minecraft.class_1959;
import net.minecraft.class_2248;
import net.minecraft.class_2281;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2478;
import net.minecraft.class_2595;
import net.minecraft.class_2625;
import net.minecraft.class_2646;
import net.minecraft.class_2960;
import net.minecraft.class_3176;
import net.minecraft.class_3448;
import net.minecraft.class_3481;
import net.minecraft.class_3611;
import net.minecraft.class_3852;
import net.minecraft.class_4050;
import net.minecraft.class_5321;
import net.minecraft.class_5363;
import net.minecraft.class_7709;
import net.minecraft.class_7717;
import net.minecraft.class_7922;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import org.bukkit.Art;
import org.bukkit.Fluid;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Statistic;
import org.bukkit.World;
import org.bukkit.attribute.Attribute;
import org.bukkit.block.Biome;
import org.bukkit.craftbukkit.v1_20_R1.block.CraftBlockStates;
import org.bukkit.craftbukkit.v1_20_R1.block.CraftChest;
import org.bukkit.craftbukkit.v1_20_R1.block.CraftHangingSign;
import org.bukkit.craftbukkit.v1_20_R1.block.CraftSign;
import org.bukkit.craftbukkit.v1_20_R1.enchantments.CraftEnchantment;
import org.bukkit.craftbukkit.v1_20_R1.inventory.CraftRecipe;
import org.bukkit.craftbukkit.v1_20_R1.potion.CraftPotionUtil;
import org.bukkit.craftbukkit.v1_20_R1.util.CraftMagicNumbers;
import org.bukkit.craftbukkit.v1_20_R1.util.CraftNamespacedKey;
import org.bukkit.craftbukkit.v1_20_R1.util.CraftSpawnCategory;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.EnderDragon;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Pose;
import org.bukkit.entity.SpawnCategory;
import org.bukkit.entity.Villager;
import org.bukkit.inventory.recipe.CookingBookCategory;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.potion.PotionType;

public class BukkitRegistry {
    public static final BiMap<class_5321<class_5363>, World.Environment> environment = HashBiMap.create((Map)ImmutableMap.builder().put((Object)class_5363.field_25412, (Object)World.Environment.NORMAL).put((Object)class_5363.field_25413, (Object)World.Environment.NETHER).put((Object)class_5363.field_25414, (Object)World.Environment.THE_END).build());
    public static BiMap<World.Environment, class_5321<class_5363>> environment0 = HashBiMap.create((Map)ImmutableMap.builder().put((Object)World.Environment.NORMAL, (Object)class_5363.field_25412).put((Object)World.Environment.NETHER, (Object)class_5363.field_25413).put((Object)World.Environment.THE_END, (Object)class_5363.field_25414).build());
    public static Map<Villager.Profession, class_2960> profession = new HashMap<Villager.Profession, class_2960>();
    public static Map<Attribute, class_2960> attributemap = new HashMap<Attribute, class_2960>();
    public static Map<class_3448<?>, Statistic> statisticMap = new HashMap();
    public static Map<class_1959, Biome> biomeBiomeMap = new HashMap<class_1959, Biome>();

    public static void registerAll(class_3176 console) {
        BukkitRegistry.loadItems();
        BukkitRegistry.loadBlocks();
        BukkitRegistry.loadPotions();
        BukkitRegistry.loadEnchantments();
        BukkitRegistry.loadEntities();
        BukkitRegistry.loadVillagerProfessions();
        BukkitRegistry.loadBiomes(console);
        BukkitRegistry.addPose();
        BukkitRegistry.loadArts();
        BukkitRegistry.loadStats();
        BukkitRegistry.loadSpawnCategory();
        BukkitRegistry.loadEndDragonPhase();
        BukkitRegistry.loadCookingBookCategory();
        BukkitRegistry.loadFluids();
    }

    public static void loadItems() {
        class_7922 registry = class_7923.field_41178;
        ArrayList<Material> newTypes = new ArrayList<Material>();
        for (class_1792 item : registry) {
            class_2960 resourceLocation = registry.method_10221((Object)item);
            if (!BukkitRegistry.isMods(resourceLocation)) continue;
            String materialName = BukkitRegistry.normalizeName(resourceLocation.toString());
            int id = class_1792.method_7880((class_1792)item);
            Material material = Material.addMaterial(materialName, id, item.method_7882(), false, true, resourceLocation);
            newTypes.add(material);
            CraftMagicNumbers.ITEM_MATERIAL.put(item, material);
            CraftMagicNumbers.MATERIAL_ITEM.put(material, item);
            BannerServer.LOGGER.debug("Save-ITEM: " + material.name() + " - " + material.key);
        }
        BannerServer.LOGGER.info(I18n.as("registry.item"), (Object)newTypes.size());
    }

    public static void loadBlocks() {
        class_7922 registry = class_7923.field_41175;
        ArrayList<Material> newTypes = new ArrayList<Material>();
        for (class_2248 block : registry) {
            class_2960 resourceLocation = registry.method_10221((Object)block);
            if (!BukkitRegistry.isMods(resourceLocation)) continue;
            String materialName = BukkitRegistry.normalizeName(resourceLocation.toString());
            int id = class_1792.method_7880((class_1792)block.method_8389());
            class_1792 item = class_1792.method_7875((int)id);
            Material material = Material.addMaterial(materialName, id, item.method_7882(), true, false, resourceLocation);
            newTypes.add(material);
            if (material == null) continue;
            CraftMagicNumbers.BLOCK_MATERIAL.put(block, material);
            CraftMagicNumbers.MATERIAL_BLOCK.put(material, block);
            if (block.method_9564().method_26164(class_3481.field_15500)) {
                CraftBlockStates.register(material, CraftSign.class, CraftSign::new, class_2625::new);
            } else if (block.method_9564().method_26164(class_3481.field_40105)) {
                CraftBlockStates.register(material, CraftHangingSign.class, CraftHangingSign::new, class_7717::new);
            } else if (block instanceof class_2478) {
                class_2478 signBlock = (class_2478)block;
                blockEntity = signBlock.method_10123(class_2338.field_10980, block.method_9564());
                if (blockEntity instanceof class_7717) {
                    CraftBlockStates.register(material, CraftHangingSign.class, CraftHangingSign::new, class_7717::new);
                } else if (blockEntity instanceof class_2625) {
                    CraftBlockStates.register(material, CraftSign.class, CraftSign::new, class_2625::new);
                }
            } else if (block instanceof class_2281) {
                class_2281 chestBlock = (class_2281)block;
                blockEntity = chestBlock.method_10123(class_2338.field_10980, block.method_9564());
                if (blockEntity instanceof class_2646) {
                    CraftBlockStates.register(material, CraftChest.class, CraftChest::new, class_2646::new);
                } else if (blockEntity instanceof class_2595) {
                    CraftBlockStates.register(material, CraftChest.class, CraftChest::new, class_2595::new);
                }
            }
            BannerServer.LOGGER.debug("Registered {0} as block {1}" + material.name() + " - " + material.key);
        }
        BannerServer.LOGGER.info(I18n.as("registry.block"), (Object)newTypes.size());
    }

    private static void loadFluids() {
        class_7922 registry = class_7923.field_41173;
        for (class_3611 fluidType : class_7923.field_41173) {
            class_2960 resourceLocation = registry.method_10221((Object)fluidType);
            String name = BukkitRegistry.normalizeName(resourceLocation.method_12832());
            if (!BukkitRegistry.isMods(resourceLocation)) continue;
            Fluid fluid = (Fluid)MohistDynamEnum.addEnum(Fluid.class, (String)name);
            BannerServer.LOGGER.debug("Registered Fluid as Fluid(Bukkit) {}", (Object)fluid.name());
        }
    }

    private static void loadCookingBookCategory() {
        for (class_7709 category : class_7709.values()) {
            try {
                CraftRecipe.getCategory(category);
            }
            catch (Exception e) {
                String name = category.name();
                CookingBookCategory bukkit = (CookingBookCategory)((Object)MohistDynamEnum.addEnum(CookingBookCategory.class, (String)name));
                BannerServer.LOGGER.debug("Registered {} as cooking category {}", (Object)name, (Object)bukkit);
            }
        }
    }

    private static void loadEndDragonPhase() {
        int max = class_1527.method_6869();
        for (int id = EnderDragon.Phase.values().length; id < max; ++id) {
            String name = "MOD_PHASE_" + id;
            EnderDragon.Phase newPhase = (EnderDragon.Phase)((Object)MohistDynamEnum.addEnum(EnderDragon.Phase.class, (String)name));
            BannerServer.LOGGER.debug("Registered {} as ender dragon phase {}", (Object)name, (Object)newPhase);
        }
    }

    private static void loadSpawnCategory() {
        for (class_1311 category : class_1311.values()) {
            try {
                CraftSpawnCategory.toBukkit(category);
            }
            catch (Exception e) {
                String name = category.name();
                SpawnCategory spawnCategory = (SpawnCategory)((Object)MohistDynamEnum.addEnum(SpawnCategory.class, (String)name));
                BannerServer.LOGGER.debug("Registered {} as spawn category {}", (Object)name, (Object)spawnCategory);
            }
        }
    }

    private static void loadStats() {
        class_2378 registry = class_7923.field_41193;
        for (class_3448 statType : registry) {
            class_2960 resourceLocation = registry.method_10221((Object)statType);
            String name = BukkitRegistry.normalizeName(resourceLocation.method_12832());
            if (!BukkitRegistry.isMods(resourceLocation)) continue;
            Statistic statistic = (Statistic)MohistDynamEnum.addEnum(Statistic.class, (String)name);
            statisticMap.put(statType, statistic);
            BannerServer.LOGGER.debug("Registered mod StatType as Statistic(Bukkit) {}", (Object)statistic.name());
        }
    }

    private static void addPose() {
        for (class_4050 pose : class_4050.values()) {
            if (pose.ordinal() <= 14) continue;
            Pose bukkit = (Pose)((Object)MohistDynamEnum.addEnum(Pose.class, (String)pose.name()));
            BannerServer.LOGGER.debug("Registered mod Pose as Pose(Bukkit) {}", (Object)bukkit);
        }
    }

    private static void loadArts() {
        int i = Art.values().length;
        class_7922 registry = class_7923.field_41182;
        for (class_1535 entry : registry) {
            int width = entry.method_6945();
            int height = entry.method_6943();
            class_2960 resourceLocation = registry.method_10221((Object)entry);
            if (resourceLocation.method_12836().equals("minecraft")) continue;
            String name = BukkitRegistry.normalizeName(resourceLocation.toString());
            String lookupName = resourceLocation.method_12832().toLowerCase(Locale.ROOT);
            int id = i - 1;
            Art art = (Art)MohistDynamEnum.addEnum(Art.class, (String)name, List.of(Integer.TYPE, Integer.TYPE, Integer.TYPE), List.of(Integer.valueOf(id), Integer.valueOf(width), Integer.valueOf(height)));
            Art.BY_NAME.put(lookupName, art);
            Art.BY_ID.put(id, art);
            BannerServer.LOGGER.debug("Registered mod PaintingType as Art {}", (Object)art);
            ++i;
        }
    }

    private static void loadBiomes(class_3176 console) {
        ArrayList<String> map = new ArrayList<String>();
        class_2378 registry = console.method_30611().method_30530(class_7924.field_41236);
        for (class_1959 biome : registry) {
            class_2960 resourceLocation = registry.method_10221((Object)biome);
            String biomeName = BukkitRegistry.normalizeName(resourceLocation.toString());
            if (!BukkitRegistry.isMods(resourceLocation) || map.contains(biomeName)) continue;
            map.add(biomeName);
            Biome biomeCB = (Biome)MohistDynamEnum.addEnum(Biome.class, (String)biomeName);
            biomeBiomeMap.put(biome, biomeCB);
            BannerServer.LOGGER.debug("Save-BIOME:" + biomeCB.name() + " - " + biomeName);
        }
    }

    private static void loadVillagerProfessions() {
        class_7922 registry = class_7923.field_41195;
        for (class_3852 villagerProfession : registry) {
            class_2960 resourceLocation = registry.method_10221((Object)villagerProfession);
            if (!BukkitRegistry.isMods(resourceLocation)) continue;
            String name = BukkitRegistry.normalizeName(resourceLocation.toString());
            Villager.Profession vp = (Villager.Profession)MohistDynamEnum.addEnum(Villager.Profession.class, (String)name);
            profession.put(vp, resourceLocation);
            BannerServer.LOGGER.debug("Registered mod VillagerProfession as Profession {}", (Object)vp.name());
        }
    }

    public static void registerEnvironments(class_2378<class_5363> registry) {
        int i = World.Environment.values().length;
        ArrayList newTypes = new ArrayList();
        for (Map.Entry entry : registry.method_29722()) {
            class_5321 key = (class_5321)entry.getKey();
            World.Environment environment1 = (World.Environment)((Object)environment.get((Object)key));
            if (environment1 != null) continue;
            String name = BukkitRegistry.normalizeName(key.method_29177().toString());
            int id = i - 1;
            environment1 = (World.Environment)((Object)MohistDynamEnum.addEnum(World.Environment.class, (String)name, List.of(Integer.TYPE), List.of(Integer.valueOf(id))));
            environment.put((Object)key, (Object)environment1);
            environment0.put((Object)environment1, (Object)key);
            BannerServer.LOGGER.debug("Registered mod DimensionType as environment {}", (Object)environment1);
            ++i;
        }
    }

    private static void loadEntities() {
        class_7922 registry = class_7923.field_41177;
        for (class_1299 entity : registry) {
            class_2960 resourceLocation = registry.method_10221((Object)entity);
            NamespacedKey key = CraftNamespacedKey.fromMinecraft(resourceLocation);
            String entityType = BukkitRegistry.normalizeName(resourceLocation.toString());
            if (BukkitRegistry.isMods(resourceLocation)) {
                int typeId = entityType.hashCode();
                EntityType bukkitType = (EntityType)MohistDynamEnum.addEnum(EntityType.class, (String)entityType, List.of(String.class, Class.class, Integer.TYPE, Boolean.TYPE), List.of(entityType.toLowerCase(), Entity.class, Integer.valueOf(typeId), Boolean.valueOf(false)));
                bukkitType.key = key;
                EntityType.NAME_MAP.put(entityType.toLowerCase(), bukkitType);
                EntityType.ID_MAP.put((short)typeId, bukkitType);
                ServerAPI.entityTypeMap.put(entity, entityType);
                BannerServer.LOGGER.debug("Registered {} as entity {}", (Object)entityType, (Object)bukkitType);
                continue;
            }
            ServerAPI.entityTypeMap.put(entity, BukkitRegistry.normalizeName(resourceLocation.method_12832()));
        }
    }

    private static void loadEnchantments() {
        for (class_1887 enc : class_7923.field_41176) {
            try {
                Enchantment.registerEnchantment(new CraftEnchantment(enc));
            }
            catch (Exception e) {
                BannerServer.LOGGER.error("Failed to register enchantment {}: {}", (Object)enc, (Object)e);
            }
        }
        Enchantment.stopAcceptingRegistrations();
    }

    private static void loadPotions() {
        String name;
        class_2960 location;
        for (class_1291 eff : class_7923.field_41174) {
            try {
                location = class_7923.field_41174.method_10221((Object)eff);
                name = BukkitRegistry.normalizeName(location.toString());
                BannerPotionEffect effect = new BannerPotionEffect(eff, name);
                PotionEffectType.registerPotionEffectType(effect);
                BannerServer.LOGGER.debug("Registered {} as potion {}", (Object)location, (Object)effect);
            }
            catch (Exception e) {
                BannerServer.LOGGER.error("Failed to register potion type {}: {}", (Object)eff, (Object)e);
            }
        }
        PotionEffectType.stopAcceptingRegistrations();
        for (class_1842 potion : class_7923.field_41179) {
            location = class_7923.field_41179.method_10221((Object)potion);
            if (!BukkitRegistry.isMods(location) || CraftPotionUtil.toBukkit(location.toString()).getType() != PotionType.UNCRAFTABLE || potion == class_1847.field_8984) continue;
            name = BukkitRegistry.normalizeName(location.toString());
            class_1293 effectInstance = potion.method_8049().isEmpty() ? null : (class_1293)potion.method_8049().get(0);
            PotionType potionType = (PotionType)((Object)MohistDynamEnum.addEnum(PotionType.class, (String)name, Arrays.asList(PotionEffectType.class, Boolean.TYPE, Boolean.TYPE), Arrays.asList(effectInstance == null ? null : PotionEffectType.getById(class_1291.method_5554((class_1291)effectInstance.method_5579())), false, false)));
            if (potionType == null) continue;
            CraftPotionUtil.mods.put(potionType, location.toString());
            BannerServer.LOGGER.debug("Registered {} as potion type {}", (Object)location, (Object)potionType);
        }
    }

    public static String normalizeName(String name) {
        return name.replace(':', '_').replaceAll("\\s+", "_").replaceAll("\\W", "").toUpperCase(Locale.ENGLISH);
    }

    public static boolean isMods(class_2960 resourceLocation) {
        return !resourceLocation.method_12836().equals("minecraft");
    }

    public static boolean isMods(NamespacedKey namespacedkey) {
        return !namespacedkey.getNamespace().equals("minecraft");
    }
}

