/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_20_R1;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicates;
import java.util.function.Predicate;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2680;
import net.minecraft.class_2841;
import net.minecraft.class_2902;
import net.minecraft.class_6880;
import net.minecraft.class_7522;
import org.bukkit.ChunkSnapshot;
import org.bukkit.Material;
import org.bukkit.block.Biome;
import org.bukkit.block.data.BlockData;
import org.bukkit.craftbukkit.v1_20_R1.CraftChunk;
import org.bukkit.craftbukkit.v1_20_R1.block.CraftBlock;
import org.bukkit.craftbukkit.v1_20_R1.block.data.CraftBlockData;
import org.bukkit.craftbukkit.v1_20_R1.util.CraftMagicNumbers;

public class CraftChunkSnapshot
implements ChunkSnapshot {
    private final int x;
    private final int z;
    private final int minHeight;
    private final int maxHeight;
    private final String worldname;
    private final class_2841<class_2680>[] blockids;
    private final byte[][] skylight;
    private final byte[][] emitlight;
    private final boolean[] empty;
    private final class_2902 hmap;
    private final long captureFulltime;
    private final class_2378<class_1959> biomeRegistry;
    private final class_7522<class_6880<class_1959>>[] biome;

    CraftChunkSnapshot(int x, int z, int minHeight, int maxHeight, String wname, long wtime, class_2841<class_2680>[] sectionBlockIDs, byte[][] sectionSkyLights, byte[][] sectionEmitLights, boolean[] sectionEmpty, class_2902 hmap, class_2378<class_1959> biomeRegistry, class_7522<class_6880<class_1959>>[] biome) {
        this.x = x;
        this.z = z;
        this.minHeight = minHeight;
        this.maxHeight = maxHeight;
        this.worldname = wname;
        this.captureFulltime = wtime;
        this.blockids = sectionBlockIDs;
        this.skylight = sectionSkyLights;
        this.emitlight = sectionEmitLights;
        this.empty = sectionEmpty;
        this.hmap = hmap;
        this.biomeRegistry = biomeRegistry;
        this.biome = biome;
    }

    @Override
    public int getX() {
        return this.x;
    }

    @Override
    public int getZ() {
        return this.z;
    }

    @Override
    public String getWorldName() {
        return this.worldname;
    }

    @Override
    public boolean contains(BlockData block) {
        Preconditions.checkArgument((block != null ? 1 : 0) != 0, (Object)"Block cannot be null");
        com.google.common.base.Predicate nms = Predicates.equalTo((Object)((CraftBlockData)block).getState());
        for (class_2841<class_2680> palette : this.blockids) {
            if (!palette.method_19526((Predicate)nms)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean contains(Biome biome) {
        Preconditions.checkArgument((biome != null ? 1 : 0) != 0, (Object)"Biome cannot be null");
        com.google.common.base.Predicate nms = Predicates.equalTo(CraftBlock.biomeToBiomeBase(this.biomeRegistry, biome));
        for (class_7522<class_6880<class_1959>> palette : this.biome) {
            if (!palette.method_19526((Predicate)nms)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Material getBlockType(int x, int y, int z) {
        this.validateChunkCoordinates(x, y, z);
        return CraftMagicNumbers.getMaterial(((class_2680)this.blockids[this.getSectionIndex(y)].method_12321(x, y & 0xF, z)).method_26204());
    }

    @Override
    public final BlockData getBlockData(int x, int y, int z) {
        this.validateChunkCoordinates(x, y, z);
        return CraftBlockData.fromData((class_2680)this.blockids[this.getSectionIndex(y)].method_12321(x, y & 0xF, z));
    }

    @Override
    public final int getData(int x, int y, int z) {
        this.validateChunkCoordinates(x, y, z);
        return CraftMagicNumbers.toLegacyData((class_2680)this.blockids[this.getSectionIndex(y)].method_12321(x, y & 0xF, z));
    }

    @Override
    public final int getBlockSkyLight(int x, int y, int z) {
        this.validateChunkCoordinates(x, y, z);
        int off = (y & 0xF) << 7 | z << 3 | x >> 1;
        return this.skylight[this.getSectionIndex(y)][off] >> ((x & 1) << 2) & 0xF;
    }

    @Override
    public final int getBlockEmittedLight(int x, int y, int z) {
        this.validateChunkCoordinates(x, y, z);
        int off = (y & 0xF) << 7 | z << 3 | x >> 1;
        return this.emitlight[this.getSectionIndex(y)][off] >> ((x & 1) << 2) & 0xF;
    }

    @Override
    public final int getHighestBlockYAt(int x, int z) {
        Preconditions.checkState((this.hmap != null ? 1 : 0) != 0, (Object)"ChunkSnapshot created without height map. Please call getSnapshot with includeMaxblocky=true");
        this.validateChunkCoordinates(x, 0, z);
        return this.hmap.method_35334(x, z);
    }

    @Override
    public final Biome getBiome(int x, int z) {
        return this.getBiome(x, 0, z);
    }

    @Override
    public final Biome getBiome(int x, int y, int z) {
        Preconditions.checkState((this.biome != null ? 1 : 0) != 0, (Object)"ChunkSnapshot created without biome. Please call getSnapshot with includeBiome=true");
        this.validateChunkCoordinates(x, y, z);
        class_7522<class_6880<class_1959>> biome = this.biome[this.getSectionIndex(y)];
        return CraftBlock.biomeBaseToBiome(this.biomeRegistry, (class_6880<class_1959>)((class_6880)biome.method_12321(x >> 2, (y & 0xF) >> 2, z >> 2)));
    }

    @Override
    public final double getRawBiomeTemperature(int x, int z) {
        return this.getRawBiomeTemperature(x, 0, z);
    }

    @Override
    public final double getRawBiomeTemperature(int x, int y, int z) {
        Preconditions.checkState((this.biome != null ? 1 : 0) != 0, (Object)"ChunkSnapshot created without biome. Please call getSnapshot with includeBiome=true");
        this.validateChunkCoordinates(x, y, z);
        class_7522<class_6880<class_1959>> biome = this.biome[this.getSectionIndex(y)];
        return ((class_1959)((class_6880)biome.method_12321(x >> 2, (y & 0xF) >> 2, z >> 2)).comp_349()).method_21740(class_2338.method_49637((double)(this.x << 4 | x), (double)y, (double)(this.z << 4 | z)));
    }

    @Override
    public final long getCaptureFullTime() {
        return this.captureFulltime;
    }

    @Override
    public final boolean isSectionEmpty(int sy) {
        return this.empty[sy];
    }

    private int getSectionIndex(int y) {
        return y - this.minHeight >> 4;
    }

    private void validateChunkCoordinates(int x, int y, int z) {
        CraftChunk.validateChunkCoordinates(this.minHeight, this.maxHeight, x, y, z);
    }
}

