/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_20_R1;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.mohistmc.banner.bukkit.BukkitExtraConstants;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.function.Consumer;
import net.minecraft.class_1295;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1303;
import net.minecraft.class_1308;
import net.minecraft.class_1315;
import net.minecraft.class_1530;
import net.minecraft.class_1531;
import net.minecraft.class_1532;
import net.minecraft.class_1533;
import net.minecraft.class_1534;
import net.minecraft.class_1540;
import net.minecraft.class_1541;
import net.minecraft.class_1642;
import net.minecraft.class_1667;
import net.minecraft.class_1668;
import net.minecraft.class_1669;
import net.minecraft.class_1671;
import net.minecraft.class_1672;
import net.minecraft.class_1680;
import net.minecraft.class_1681;
import net.minecraft.class_1686;
import net.minecraft.class_1694;
import net.minecraft.class_1695;
import net.minecraft.class_1696;
import net.minecraft.class_1697;
import net.minecraft.class_1699;
import net.minecraft.class_1700;
import net.minecraft.class_1701;
import net.minecraft.class_1799;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2246;
import net.minecraft.class_2279;
import net.minecraft.class_2312;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2378;
import net.minecraft.class_238;
import net.minecraft.class_2680;
import net.minecraft.class_2794;
import net.minecraft.class_2975;
import net.minecraft.class_3218;
import net.minecraft.class_3730;
import net.minecraft.class_5281;
import net.minecraft.class_5321;
import net.minecraft.class_5425;
import net.minecraft.class_5819;
import net.minecraft.class_5915;
import net.minecraft.class_6808;
import net.minecraft.class_6880;
import net.minecraft.class_7264;
import net.minecraft.class_7924;
import net.minecraft.class_8150;
import org.bukkit.HeightMap;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.RegionAccessor;
import org.bukkit.TreeType;
import org.bukkit.block.Biome;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.block.data.BlockData;
import org.bukkit.craftbukkit.v1_20_R1.CraftHeightMap;
import org.bukkit.craftbukkit.v1_20_R1.block.CraftBlock;
import org.bukkit.craftbukkit.v1_20_R1.block.data.CraftBlockData;
import org.bukkit.craftbukkit.v1_20_R1.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_20_R1.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_20_R1.potion.CraftPotionUtil;
import org.bukkit.craftbukkit.v1_20_R1.util.BlockStateListPopulator;
import org.bukkit.craftbukkit.v1_20_R1.util.CraftLocation;
import org.bukkit.craftbukkit.v1_20_R1.util.CraftMagicNumbers;
import org.bukkit.craftbukkit.v1_20_R1.util.RandomSourceWrapper;
import org.bukkit.entity.AbstractArrow;
import org.bukkit.entity.AbstractHorse;
import org.bukkit.entity.AbstractSkeleton;
import org.bukkit.entity.AbstractVillager;
import org.bukkit.entity.Allay;
import org.bukkit.entity.Ambient;
import org.bukkit.entity.AreaEffectCloud;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Axolotl;
import org.bukkit.entity.Bat;
import org.bukkit.entity.Bee;
import org.bukkit.entity.Blaze;
import org.bukkit.entity.BlockDisplay;
import org.bukkit.entity.Boat;
import org.bukkit.entity.Camel;
import org.bukkit.entity.Cat;
import org.bukkit.entity.CaveSpider;
import org.bukkit.entity.ChestedHorse;
import org.bukkit.entity.Chicken;
import org.bukkit.entity.Cod;
import org.bukkit.entity.ComplexLivingEntity;
import org.bukkit.entity.Cow;
import org.bukkit.entity.Creeper;
import org.bukkit.entity.Display;
import org.bukkit.entity.Dolphin;
import org.bukkit.entity.Donkey;
import org.bukkit.entity.DragonFireball;
import org.bukkit.entity.Drowned;
import org.bukkit.entity.Egg;
import org.bukkit.entity.ElderGuardian;
import org.bukkit.entity.EnderCrystal;
import org.bukkit.entity.EnderDragon;
import org.bukkit.entity.EnderPearl;
import org.bukkit.entity.EnderSignal;
import org.bukkit.entity.Enderman;
import org.bukkit.entity.Endermite;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Evoker;
import org.bukkit.entity.EvokerFangs;
import org.bukkit.entity.ExperienceOrb;
import org.bukkit.entity.FallingBlock;
import org.bukkit.entity.Fireball;
import org.bukkit.entity.Firework;
import org.bukkit.entity.Fish;
import org.bukkit.entity.Fox;
import org.bukkit.entity.Frog;
import org.bukkit.entity.Ghast;
import org.bukkit.entity.Giant;
import org.bukkit.entity.GlowItemFrame;
import org.bukkit.entity.GlowSquid;
import org.bukkit.entity.Goat;
import org.bukkit.entity.Golem;
import org.bukkit.entity.Guardian;
import org.bukkit.entity.Hanging;
import org.bukkit.entity.Hoglin;
import org.bukkit.entity.Husk;
import org.bukkit.entity.Illager;
import org.bukkit.entity.Illusioner;
import org.bukkit.entity.IronGolem;
import org.bukkit.entity.ItemDisplay;
import org.bukkit.entity.ItemFrame;
import org.bukkit.entity.LeashHitch;
import org.bukkit.entity.LightningStrike;
import org.bukkit.entity.LingeringPotion;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Llama;
import org.bukkit.entity.LlamaSpit;
import org.bukkit.entity.MagmaCube;
import org.bukkit.entity.Marker;
import org.bukkit.entity.Minecart;
import org.bukkit.entity.Mule;
import org.bukkit.entity.MushroomCow;
import org.bukkit.entity.Ocelot;
import org.bukkit.entity.Painting;
import org.bukkit.entity.Panda;
import org.bukkit.entity.Parrot;
import org.bukkit.entity.Phantom;
import org.bukkit.entity.Pig;
import org.bukkit.entity.PigZombie;
import org.bukkit.entity.Piglin;
import org.bukkit.entity.PiglinBrute;
import org.bukkit.entity.Pillager;
import org.bukkit.entity.Player;
import org.bukkit.entity.PolarBear;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.PufferFish;
import org.bukkit.entity.Rabbit;
import org.bukkit.entity.Ravager;
import org.bukkit.entity.Salmon;
import org.bukkit.entity.Sheep;
import org.bukkit.entity.Shulker;
import org.bukkit.entity.ShulkerBullet;
import org.bukkit.entity.Silverfish;
import org.bukkit.entity.Skeleton;
import org.bukkit.entity.SkeletonHorse;
import org.bukkit.entity.Slime;
import org.bukkit.entity.SmallFireball;
import org.bukkit.entity.Snowball;
import org.bukkit.entity.Snowman;
import org.bukkit.entity.SpectralArrow;
import org.bukkit.entity.Spellcaster;
import org.bukkit.entity.Spider;
import org.bukkit.entity.Squid;
import org.bukkit.entity.Stray;
import org.bukkit.entity.Strider;
import org.bukkit.entity.TNTPrimed;
import org.bukkit.entity.Tadpole;
import org.bukkit.entity.Tameable;
import org.bukkit.entity.TextDisplay;
import org.bukkit.entity.ThrownExpBottle;
import org.bukkit.entity.ThrownPotion;
import org.bukkit.entity.TippedArrow;
import org.bukkit.entity.TraderLlama;
import org.bukkit.entity.Trident;
import org.bukkit.entity.TropicalFish;
import org.bukkit.entity.Turtle;
import org.bukkit.entity.Vex;
import org.bukkit.entity.Villager;
import org.bukkit.entity.Vindicator;
import org.bukkit.entity.WanderingTrader;
import org.bukkit.entity.Warden;
import org.bukkit.entity.Witch;
import org.bukkit.entity.Wither;
import org.bukkit.entity.WitherSkeleton;
import org.bukkit.entity.WitherSkull;
import org.bukkit.entity.Wolf;
import org.bukkit.entity.Zoglin;
import org.bukkit.entity.Zombie;
import org.bukkit.entity.ZombieHorse;
import org.bukkit.entity.ZombieVillager;
import org.bukkit.entity.minecart.CommandMinecart;
import org.bukkit.entity.minecart.ExplosiveMinecart;
import org.bukkit.entity.minecart.HopperMinecart;
import org.bukkit.entity.minecart.PoweredMinecart;
import org.bukkit.entity.minecart.SpawnerMinecart;
import org.bukkit.entity.minecart.StorageMinecart;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.potion.PotionData;
import org.bukkit.potion.PotionType;
import org.bukkit.util.Vector;

public abstract class CraftRegionAccessor
implements RegionAccessor {
    public abstract class_5281 getHandle();

    public boolean isNormalWorld() {
        return this.getHandle() instanceof class_3218;
    }

    @Override
    public Biome getBiome(Location location) {
        return this.getBiome(location.getBlockX(), location.getBlockY(), location.getBlockZ());
    }

    @Override
    public Biome getBiome(int x, int y, int z) {
        return CraftBlock.biomeBaseToBiome((class_2378<class_1959>)this.getHandle().method_30349().method_30530(class_7924.field_41236), (class_6880<class_1959>)this.getHandle().method_16359(x >> 2, y >> 2, z >> 2));
    }

    @Override
    public void setBiome(Location location, Biome biome) {
        this.setBiome(location.getBlockX(), location.getBlockY(), location.getBlockZ(), biome);
    }

    @Override
    public void setBiome(int x, int y, int z, Biome biome) {
        Preconditions.checkArgument((biome != Biome.CUSTOM ? 1 : 0) != 0, (String)"Cannot set the biome to %s", (Object)biome);
        class_6880<class_1959> biomeBase = CraftBlock.biomeToBiomeBase((class_2378<class_1959>)this.getHandle().method_30349().method_30530(class_7924.field_41236), biome);
        this.setBiome(x, y, z, biomeBase);
    }

    public abstract void setBiome(int var1, int var2, int var3, class_6880<class_1959> var4);

    @Override
    public BlockState getBlockState(Location location) {
        return this.getBlockState(location.getBlockX(), location.getBlockY(), location.getBlockZ());
    }

    @Override
    public BlockState getBlockState(int x, int y, int z) {
        return CraftBlock.at((class_1936)this.getHandle(), class_2338.method_49637((double)x, (double)y, (double)z)).getState();
    }

    @Override
    public BlockData getBlockData(Location location) {
        return this.getBlockData(location.getBlockX(), location.getBlockY(), location.getBlockZ());
    }

    @Override
    public BlockData getBlockData(int x, int y, int z) {
        return CraftBlockData.fromData(this.getData(x, y, z));
    }

    @Override
    public Material getType(Location location) {
        return this.getType(location.getBlockX(), location.getBlockY(), location.getBlockZ());
    }

    @Override
    public Material getType(int x, int y, int z) {
        return CraftMagicNumbers.getMaterial(this.getData(x, y, z).method_26204());
    }

    private class_2680 getData(int x, int y, int z) {
        return this.getHandle().method_8320(class_2338.method_49637((double)x, (double)y, (double)z));
    }

    @Override
    public void setBlockData(Location location, BlockData blockData) {
        this.setBlockData(location.getBlockX(), location.getBlockY(), location.getBlockZ(), blockData);
    }

    @Override
    public void setBlockData(int x, int y, int z, BlockData blockData) {
        class_5281 world = this.getHandle();
        class_2338 pos = class_2338.method_49637((double)x, (double)y, (double)z);
        class_2680 old = this.getHandle().method_8320(pos);
        CraftBlock.setTypeAndData((class_1936)world, pos, old, ((CraftBlockData)blockData).getState(), true);
    }

    @Override
    public void setType(Location location, Material material) {
        this.setType(location.getBlockX(), location.getBlockY(), location.getBlockZ(), material);
    }

    @Override
    public void setType(int x, int y, int z, Material material) {
        this.setBlockData(x, y, z, material.createBlockData());
    }

    @Override
    public int getHighestBlockYAt(int x, int z) {
        return this.getHighestBlockYAt(x, z, HeightMap.MOTION_BLOCKING);
    }

    @Override
    public int getHighestBlockYAt(Location location) {
        return this.getHighestBlockYAt(location.getBlockX(), location.getBlockZ());
    }

    @Override
    public int getHighestBlockYAt(int x, int z, HeightMap heightMap) {
        return this.getHandle().method_8624(CraftHeightMap.toNMS(heightMap), x, z);
    }

    @Override
    public int getHighestBlockYAt(Location location, HeightMap heightMap) {
        return this.getHighestBlockYAt(location.getBlockX(), location.getBlockZ(), heightMap);
    }

    @Override
    public boolean generateTree(Location location, Random random, TreeType treeType) {
        class_2338 pos = CraftLocation.toBlockPosition(location);
        return this.generateTree(this.getHandle(), this.getHandle().getMinecraftWorld().method_14178().method_12129(), pos, new RandomSourceWrapper(random), treeType);
    }

    @Override
    public boolean generateTree(Location location, Random random, TreeType treeType, Consumer<BlockState> consumer) {
        return this.generateTree(location, random, treeType, (Predicate<BlockState>)(consumer == null ? null : block -> {
            consumer.accept((BlockState)block);
            return true;
        }));
    }

    public boolean generateTree(Location location, Random random, TreeType treeType, Predicate<BlockState> predicate) {
        class_2338 pos = CraftLocation.toBlockPosition(location);
        BlockStateListPopulator populator = new BlockStateListPopulator((class_1936)this.getHandle());
        boolean result = this.generateTree(populator, this.getHandle().getMinecraftWorld().method_14178().method_12129(), pos, new RandomSourceWrapper(random), treeType);
        populator.refreshTiles();
        for (BlockState blockState : populator.getList()) {
            if (predicate != null && !predicate.test((Object)blockState)) continue;
            blockState.update(true, true);
        }
        return result;
    }

    public boolean generateTree(class_5281 access, class_2794 chunkGenerator, class_2338 pos, class_5819 random, TreeType treeType) {
        class_5321 gen;
        switch (treeType) {
            case BIG_TREE: {
                gen = class_6808.field_35912;
                break;
            }
            case BIRCH: {
                gen = class_6808.field_35907;
                break;
            }
            case REDWOOD: {
                gen = class_6808.field_35909;
                break;
            }
            case TALL_REDWOOD: {
                gen = class_6808.field_35910;
                break;
            }
            case JUNGLE: {
                gen = class_6808.field_35914;
                break;
            }
            case SMALL_JUNGLE: {
                gen = class_6808.field_35913;
                break;
            }
            case COCOA_TREE: {
                gen = class_6808.field_35911;
                break;
            }
            case JUNGLE_BUSH: {
                gen = class_6808.field_35920;
                break;
            }
            case RED_MUSHROOM: {
                gen = class_6808.field_35904;
                break;
            }
            case BROWN_MUSHROOM: {
                gen = class_6808.field_35903;
                break;
            }
            case SWAMP: {
                gen = class_6808.field_35919;
                break;
            }
            case ACACIA: {
                gen = class_6808.field_35908;
                break;
            }
            case DARK_OAK: {
                gen = class_6808.field_35906;
                break;
            }
            case MEGA_REDWOOD: {
                gen = class_6808.field_35916;
                break;
            }
            case TALL_BIRCH: {
                gen = class_6808.field_35917;
                break;
            }
            case CHORUS_PLANT: {
                class_2279 cfr_ignored_0 = (class_2279)class_2246.field_10528;
                class_2279.method_9744((class_1936)access, (class_2338)pos, (class_5819)random, (int)8);
                return true;
            }
            case CRIMSON_FUNGUS: {
                gen = class_6808.field_35900;
                break;
            }
            case WARPED_FUNGUS: {
                gen = class_6808.field_35902;
                break;
            }
            case AZALEA: {
                gen = class_6808.field_35921;
                break;
            }
            case MANGROVE: {
                gen = class_6808.field_38810;
                break;
            }
            case TALL_MANGROVE: {
                gen = class_6808.field_38811;
                break;
            }
            case CHERRY: {
                gen = class_6808.field_42960;
                break;
            }
            default: {
                gen = class_6808.field_35905;
            }
        }
        class_6880 holder = access.method_30349().method_30530(class_7924.field_41239).method_40264(gen).orElse(null);
        return holder != null ? ((class_2975)holder.comp_349()).method_12862(access, chunkGenerator, random, pos) : false;
    }

    @Override
    public Entity spawnEntity(Location location, EntityType entityType) {
        return this.spawn(location, entityType.getEntityClass());
    }

    @Override
    public Entity spawnEntity(Location loc, EntityType type, boolean randomizeData) {
        return this.spawn(loc, type.getEntityClass(), null, CreatureSpawnEvent.SpawnReason.CUSTOM, randomizeData);
    }

    @Override
    public List<Entity> getEntities() {
        ArrayList<Entity> list = new ArrayList<Entity>();
        this.getNMSEntities().forEach(entity -> {
            CraftEntity bukkitEntity = entity.getBukkitEntity();
            if (bukkitEntity != null && (!this.isNormalWorld() || bukkitEntity.isValid())) {
                list.add(bukkitEntity);
            }
        });
        return list;
    }

    @Override
    public List<LivingEntity> getLivingEntities() {
        ArrayList<LivingEntity> list = new ArrayList<LivingEntity>();
        this.getNMSEntities().forEach(entity -> {
            CraftEntity bukkitEntity = entity.getBukkitEntity();
            if (bukkitEntity != null && bukkitEntity instanceof LivingEntity && (!this.isNormalWorld() || bukkitEntity.isValid())) {
                list.add((LivingEntity)((Object)bukkitEntity));
            }
        });
        return list;
    }

    @Override
    public <T extends Entity> Collection<T> getEntitiesByClass(Class<T> clazz) {
        ArrayList list = new ArrayList();
        this.getNMSEntities().forEach(entity -> {
            CraftEntity bukkitEntity = entity.getBukkitEntity();
            if (bukkitEntity == null) {
                return;
            }
            Class<?> bukkitClass = bukkitEntity.getClass();
            if (clazz.isAssignableFrom(bukkitClass) && (!this.isNormalWorld() || bukkitEntity.isValid())) {
                list.add(bukkitEntity);
            }
        });
        return list;
    }

    @Override
    public Collection<Entity> getEntitiesByClasses(Class<?> ... classes) {
        ArrayList<Entity> list = new ArrayList<Entity>();
        this.getNMSEntities().forEach(entity -> {
            CraftEntity bukkitEntity = entity.getBukkitEntity();
            if (bukkitEntity == null) {
                return;
            }
            Class<?> bukkitClass = bukkitEntity.getClass();
            for (Class clazz : classes) {
                if (!clazz.isAssignableFrom(bukkitClass)) continue;
                if (this.isNormalWorld() && !bukkitEntity.isValid()) break;
                list.add(bukkitEntity);
                break;
            }
        });
        return list;
    }

    public abstract Iterable<class_1297> getNMSEntities();

    @Override
    public <T extends Entity> T spawn(Location location, Class<T> clazz) throws IllegalArgumentException {
        return this.spawn(location, clazz, null, CreatureSpawnEvent.SpawnReason.CUSTOM);
    }

    @Override
    public <T extends Entity> T spawn(Location location, Class<T> clazz, Consumer<T> function) throws IllegalArgumentException {
        return this.spawn(location, clazz, function, CreatureSpawnEvent.SpawnReason.CUSTOM);
    }

    @Override
    public <T extends Entity> T spawn(Location location, Class<T> clazz, boolean randomizeData, Consumer<T> function) throws IllegalArgumentException {
        return this.spawn(location, clazz, function, CreatureSpawnEvent.SpawnReason.CUSTOM, randomizeData);
    }

    public <T extends Entity> T spawn(Location location, Class<T> clazz, Consumer<T> function, CreatureSpawnEvent.SpawnReason reason) throws IllegalArgumentException {
        return this.spawn(location, clazz, function, reason, true);
    }

    public <T extends Entity> T spawn(Location location, Class<T> clazz, Consumer<T> function, CreatureSpawnEvent.SpawnReason reason, boolean randomizeData) throws IllegalArgumentException {
        class_1297 entity = this.createEntity(location, clazz, randomizeData);
        return this.addEntity(entity, reason, function, randomizeData);
    }

    public <T extends Entity> T addEntity(class_1297 entity, CreatureSpawnEvent.SpawnReason reason) throws IllegalArgumentException {
        return this.addEntity(entity, reason, null, true);
    }

    public <T extends Entity> T addEntity(class_1297 entity, CreatureSpawnEvent.SpawnReason reason, Consumer<T> function, boolean randomizeData) throws IllegalArgumentException {
        Preconditions.checkArgument((entity != null ? 1 : 0) != 0, (Object)"Cannot spawn null entity");
        if (randomizeData && entity instanceof class_1308) {
            ((class_1308)entity).method_5943((class_5425)this.getHandle(), this.getHandle().method_8404(entity.method_24515()), class_3730.field_16462, (class_1315)null, null);
        }
        if (!this.isNormalWorld()) {
            entity.banner$setGeneration(true);
        }
        if (function != null) {
            function.accept(entity.getBukkitEntity());
        }
        this.addEntityToWorld(entity, reason);
        return (T)entity.getBukkitEntity();
    }

    public abstract void addEntityToWorld(class_1297 var1, CreatureSpawnEvent.SpawnReason var2);

    public class_1297 createEntity(Location location, Class<? extends Entity> clazz) throws IllegalArgumentException {
        return this.createEntity(location, clazz, true);
    }

    public class_1297 createEntity(Location location, Class<? extends Entity> clazz, boolean randomizeData) throws IllegalArgumentException {
        Preconditions.checkArgument((location != null ? 1 : 0) != 0, (Object)"Location cannot be null");
        Preconditions.checkArgument((clazz != null ? 1 : 0) != 0, (Object)"Entity class cannot be null");
        Object entity = null;
        class_3218 world = this.getHandle().getMinecraftWorld();
        double x = location.getX();
        double y = location.getY();
        double z = location.getZ();
        float pitch = location.getPitch();
        float yaw = location.getYaw();
        if (Boat.class.isAssignableFrom(clazz)) {
            entity = class_7264.class.isAssignableFrom(clazz) ? class_1299.field_38096.method_5883((class_1937)world) : class_1299.field_6121.method_5883((class_1937)world);
            entity.method_5808(x, y, z, yaw, pitch);
        } else if (FallingBlock.class.isAssignableFrom(clazz)) {
            class_2338 pos = class_2338.method_49637((double)x, (double)y, (double)z);
            entity = class_1540.method_40005((class_1937)world, (class_2338)pos, (class_2680)this.getHandle().method_8320(pos));
        } else if (Projectile.class.isAssignableFrom(clazz)) {
            if (Snowball.class.isAssignableFrom(clazz)) {
                entity = new class_1680((class_1937)world, x, y, z);
            } else if (Egg.class.isAssignableFrom(clazz)) {
                entity = new class_1681((class_1937)world, x, y, z);
            } else if (AbstractArrow.class.isAssignableFrom(clazz)) {
                if (TippedArrow.class.isAssignableFrom(clazz)) {
                    entity = class_1299.field_6122.method_5883((class_1937)world);
                    ((class_1667)entity).setPotionType(CraftPotionUtil.fromBukkit(new PotionData(PotionType.WATER, false, false)));
                } else {
                    entity = SpectralArrow.class.isAssignableFrom(clazz) ? class_1299.field_6135.method_5883((class_1937)world) : (Trident.class.isAssignableFrom(clazz) ? class_1299.field_6127.method_5883((class_1937)world) : class_1299.field_6122.method_5883((class_1937)world));
                }
                entity.method_5808(x, y, z, 0.0f, 0.0f);
            } else if (ThrownExpBottle.class.isAssignableFrom(clazz)) {
                entity = class_1299.field_6064.method_5883((class_1937)world);
                entity.method_5808(x, y, z, 0.0f, 0.0f);
            } else if (EnderPearl.class.isAssignableFrom(clazz)) {
                entity = class_1299.field_6082.method_5883((class_1937)world);
                entity.method_5808(x, y, z, 0.0f, 0.0f);
            } else if (ThrownPotion.class.isAssignableFrom(clazz)) {
                if (LingeringPotion.class.isAssignableFrom(clazz)) {
                    entity = new class_1686((class_1937)world, x, y, z);
                    ((class_1686)entity).method_16940(CraftItemStack.asNMSCopy(new ItemStack(Material.LINGERING_POTION, 1)));
                } else {
                    entity = new class_1686((class_1937)world, x, y, z);
                    ((class_1686)entity).method_16940(CraftItemStack.asNMSCopy(new ItemStack(Material.SPLASH_POTION, 1)));
                }
            } else if (Fireball.class.isAssignableFrom(clazz)) {
                entity = SmallFireball.class.isAssignableFrom(clazz) ? class_1299.field_6049.method_5883((class_1937)world) : (WitherSkull.class.isAssignableFrom(clazz) ? class_1299.field_6130.method_5883((class_1937)world) : (DragonFireball.class.isAssignableFrom(clazz) ? class_1299.field_6129.method_5883((class_1937)world) : class_1299.field_6066.method_5883((class_1937)world)));
                entity.method_5808(x, y, z, yaw, pitch);
                Vector direction = location.getDirection().multiply(10);
                ((class_1668)entity).setDirection(direction.getX(), direction.getY(), direction.getZ());
            } else if (ShulkerBullet.class.isAssignableFrom(clazz)) {
                entity = class_1299.field_6100.method_5883((class_1937)world);
                entity.method_5808(x, y, z, yaw, pitch);
            } else if (LlamaSpit.class.isAssignableFrom(clazz)) {
                entity = class_1299.field_6124.method_5883((class_1937)world);
                entity.method_5808(x, y, z, yaw, pitch);
            } else if (Firework.class.isAssignableFrom(clazz)) {
                entity = new class_1671((class_1937)world, x, y, z, class_1799.field_8037);
            }
        } else if (Minecart.class.isAssignableFrom(clazz)) {
            entity = PoweredMinecart.class.isAssignableFrom(clazz) ? new class_1696((class_1937)world, x, y, z) : (StorageMinecart.class.isAssignableFrom(clazz) ? new class_1694((class_1937)world, x, y, z) : (ExplosiveMinecart.class.isAssignableFrom(clazz) ? new class_1701((class_1937)world, x, y, z) : (HopperMinecart.class.isAssignableFrom(clazz) ? new class_1700((class_1937)world, x, y, z) : (SpawnerMinecart.class.isAssignableFrom(clazz) ? new class_1699((class_1937)world, x, y, z) : (CommandMinecart.class.isAssignableFrom(clazz) ? new class_1697((class_1937)world, x, y, z) : new class_1695((class_1937)world, x, y, z))))));
        } else if (EnderSignal.class.isAssignableFrom(clazz)) {
            entity = new class_1672((class_1937)world, x, y, z);
        } else if (EnderCrystal.class.isAssignableFrom(clazz)) {
            entity = class_1299.field_6110.method_5883((class_1937)world);
            entity.method_5808(x, y, z, 0.0f, 0.0f);
        } else if (LivingEntity.class.isAssignableFrom(clazz)) {
            if (Chicken.class.isAssignableFrom(clazz)) {
                entity = class_1299.field_6132.method_5883((class_1937)world);
            } else if (Cow.class.isAssignableFrom(clazz)) {
                entity = MushroomCow.class.isAssignableFrom(clazz) ? class_1299.field_6143.method_5883((class_1937)world) : class_1299.field_6085.method_5883((class_1937)world);
            } else if (Golem.class.isAssignableFrom(clazz)) {
                if (Snowman.class.isAssignableFrom(clazz)) {
                    entity = class_1299.field_6047.method_5883((class_1937)world);
                } else if (IronGolem.class.isAssignableFrom(clazz)) {
                    entity = class_1299.field_6147.method_5883((class_1937)world);
                } else if (Shulker.class.isAssignableFrom(clazz)) {
                    entity = class_1299.field_6109.method_5883((class_1937)world);
                }
            } else if (Creeper.class.isAssignableFrom(clazz)) {
                entity = class_1299.field_6046.method_5883((class_1937)world);
            } else if (Ghast.class.isAssignableFrom(clazz)) {
                entity = class_1299.field_6107.method_5883((class_1937)world);
            } else if (Pig.class.isAssignableFrom(clazz)) {
                entity = class_1299.field_6093.method_5883((class_1937)world);
            } else if (!Player.class.isAssignableFrom(clazz)) {
                if (Sheep.class.isAssignableFrom(clazz)) {
                    entity = class_1299.field_6115.method_5883((class_1937)world);
                } else if (AbstractHorse.class.isAssignableFrom(clazz)) {
                    if (ChestedHorse.class.isAssignableFrom(clazz)) {
                        if (Donkey.class.isAssignableFrom(clazz)) {
                            entity = class_1299.field_6067.method_5883((class_1937)world);
                        } else if (Mule.class.isAssignableFrom(clazz)) {
                            entity = class_1299.field_6057.method_5883((class_1937)world);
                        } else if (Llama.class.isAssignableFrom(clazz)) {
                            entity = TraderLlama.class.isAssignableFrom(clazz) ? class_1299.field_17714.method_5883((class_1937)world) : class_1299.field_6074.method_5883((class_1937)world);
                        }
                    } else {
                        entity = SkeletonHorse.class.isAssignableFrom(clazz) ? class_1299.field_6075.method_5883((class_1937)world) : (ZombieHorse.class.isAssignableFrom(clazz) ? class_1299.field_6048.method_5883((class_1937)world) : (Camel.class.isAssignableFrom(clazz) ? class_1299.field_40116.method_5883((class_1937)world) : class_1299.field_6139.method_5883((class_1937)world)));
                    }
                } else if (AbstractSkeleton.class.isAssignableFrom(clazz)) {
                    if (Stray.class.isAssignableFrom(clazz)) {
                        entity = class_1299.field_6098.method_5883((class_1937)world);
                    } else if (WitherSkeleton.class.isAssignableFrom(clazz)) {
                        entity = class_1299.field_6076.method_5883((class_1937)world);
                    } else if (Skeleton.class.isAssignableFrom(clazz)) {
                        entity = class_1299.field_6137.method_5883((class_1937)world);
                    }
                } else if (Slime.class.isAssignableFrom(clazz)) {
                    entity = MagmaCube.class.isAssignableFrom(clazz) ? class_1299.field_6102.method_5883((class_1937)world) : class_1299.field_6069.method_5883((class_1937)world);
                } else if (Spider.class.isAssignableFrom(clazz)) {
                    entity = CaveSpider.class.isAssignableFrom(clazz) ? class_1299.field_6084.method_5883((class_1937)world) : class_1299.field_6079.method_5883((class_1937)world);
                } else if (Squid.class.isAssignableFrom(clazz)) {
                    entity = GlowSquid.class.isAssignableFrom(clazz) ? class_1299.field_28402.method_5883((class_1937)world) : class_1299.field_6114.method_5883((class_1937)world);
                } else if (Tameable.class.isAssignableFrom(clazz)) {
                    if (Wolf.class.isAssignableFrom(clazz)) {
                        entity = class_1299.field_6055.method_5883((class_1937)world);
                    } else if (Parrot.class.isAssignableFrom(clazz)) {
                        entity = class_1299.field_6104.method_5883((class_1937)world);
                    } else if (Cat.class.isAssignableFrom(clazz)) {
                        entity = class_1299.field_16281.method_5883((class_1937)world);
                    }
                } else if (PigZombie.class.isAssignableFrom(clazz)) {
                    entity = class_1299.field_6050.method_5883((class_1937)world);
                } else if (Zombie.class.isAssignableFrom(clazz)) {
                    entity = Husk.class.isAssignableFrom(clazz) ? class_1299.field_6071.method_5883((class_1937)world) : (ZombieVillager.class.isAssignableFrom(clazz) ? class_1299.field_6054.method_5883((class_1937)world) : (Drowned.class.isAssignableFrom(clazz) ? class_1299.field_6123.method_5883((class_1937)world) : new class_1642((class_1937)world)));
                } else if (Giant.class.isAssignableFrom(clazz)) {
                    entity = class_1299.field_6095.method_5883((class_1937)world);
                } else if (Silverfish.class.isAssignableFrom(clazz)) {
                    entity = class_1299.field_6125.method_5883((class_1937)world);
                } else if (Enderman.class.isAssignableFrom(clazz)) {
                    entity = class_1299.field_6091.method_5883((class_1937)world);
                } else if (Blaze.class.isAssignableFrom(clazz)) {
                    entity = class_1299.field_6099.method_5883((class_1937)world);
                } else if (AbstractVillager.class.isAssignableFrom(clazz)) {
                    if (Villager.class.isAssignableFrom(clazz)) {
                        entity = class_1299.field_6077.method_5883((class_1937)world);
                    } else if (WanderingTrader.class.isAssignableFrom(clazz)) {
                        entity = class_1299.field_17713.method_5883((class_1937)world);
                    }
                } else if (Witch.class.isAssignableFrom(clazz)) {
                    entity = class_1299.field_6145.method_5883((class_1937)world);
                } else if (Wither.class.isAssignableFrom(clazz)) {
                    entity = class_1299.field_6119.method_5883((class_1937)world);
                } else if (ComplexLivingEntity.class.isAssignableFrom(clazz)) {
                    if (EnderDragon.class.isAssignableFrom(clazz)) {
                        Preconditions.checkArgument((boolean)this.isNormalWorld(), (String)"Cannot spawn entity %s during world generation", (Object)clazz.getName());
                        entity = class_1299.field_6116.method_5883((class_1937)this.getHandle().getMinecraftWorld());
                    }
                } else if (Ambient.class.isAssignableFrom(clazz)) {
                    if (Bat.class.isAssignableFrom(clazz)) {
                        entity = class_1299.field_6108.method_5883((class_1937)world);
                    }
                } else if (Rabbit.class.isAssignableFrom(clazz)) {
                    entity = class_1299.field_6140.method_5883((class_1937)world);
                } else if (Endermite.class.isAssignableFrom(clazz)) {
                    entity = class_1299.field_6128.method_5883((class_1937)world);
                } else if (Guardian.class.isAssignableFrom(clazz)) {
                    entity = ElderGuardian.class.isAssignableFrom(clazz) ? class_1299.field_6086.method_5883((class_1937)world) : class_1299.field_6118.method_5883((class_1937)world);
                } else if (ArmorStand.class.isAssignableFrom(clazz)) {
                    entity = new class_1531((class_1937)world, x, y, z);
                } else if (PolarBear.class.isAssignableFrom(clazz)) {
                    entity = class_1299.field_6042.method_5883((class_1937)world);
                } else if (Vex.class.isAssignableFrom(clazz)) {
                    entity = class_1299.field_6059.method_5883((class_1937)world);
                } else if (Illager.class.isAssignableFrom(clazz)) {
                    if (Spellcaster.class.isAssignableFrom(clazz)) {
                        if (Evoker.class.isAssignableFrom(clazz)) {
                            entity = class_1299.field_6090.method_5883((class_1937)world);
                        } else if (Illusioner.class.isAssignableFrom(clazz)) {
                            entity = class_1299.field_6065.method_5883((class_1937)world);
                        }
                    } else if (Vindicator.class.isAssignableFrom(clazz)) {
                        entity = class_1299.field_6117.method_5883((class_1937)world);
                    } else if (Pillager.class.isAssignableFrom(clazz)) {
                        entity = class_1299.field_6105.method_5883((class_1937)world);
                    }
                } else if (Turtle.class.isAssignableFrom(clazz)) {
                    entity = class_1299.field_6113.method_5883((class_1937)world);
                } else if (Phantom.class.isAssignableFrom(clazz)) {
                    entity = class_1299.field_6078.method_5883((class_1937)world);
                } else if (Fish.class.isAssignableFrom(clazz)) {
                    if (Cod.class.isAssignableFrom(clazz)) {
                        entity = class_1299.field_6070.method_5883((class_1937)world);
                    } else if (PufferFish.class.isAssignableFrom(clazz)) {
                        entity = class_1299.field_6062.method_5883((class_1937)world);
                    } else if (Salmon.class.isAssignableFrom(clazz)) {
                        entity = class_1299.field_6073.method_5883((class_1937)world);
                    } else if (TropicalFish.class.isAssignableFrom(clazz)) {
                        entity = class_1299.field_6111.method_5883((class_1937)world);
                    } else if (Tadpole.class.isAssignableFrom(clazz)) {
                        entity = class_1299.field_37420.method_5883((class_1937)world);
                    }
                } else if (Dolphin.class.isAssignableFrom(clazz)) {
                    entity = class_1299.field_6087.method_5883((class_1937)world);
                } else if (Ocelot.class.isAssignableFrom(clazz)) {
                    entity = class_1299.field_6081.method_5883((class_1937)world);
                } else if (Ravager.class.isAssignableFrom(clazz)) {
                    entity = class_1299.field_6134.method_5883((class_1937)world);
                } else if (Panda.class.isAssignableFrom(clazz)) {
                    entity = class_1299.field_6146.method_5883((class_1937)world);
                } else if (Fox.class.isAssignableFrom(clazz)) {
                    entity = class_1299.field_17943.method_5883((class_1937)world);
                } else if (Bee.class.isAssignableFrom(clazz)) {
                    entity = class_1299.field_20346.method_5883((class_1937)world);
                } else if (Hoglin.class.isAssignableFrom(clazz)) {
                    entity = class_1299.field_21973.method_5883((class_1937)world);
                } else if (Piglin.class.isAssignableFrom(clazz)) {
                    entity = class_1299.field_22281.method_5883((class_1937)world);
                } else if (PiglinBrute.class.isAssignableFrom(clazz)) {
                    entity = class_1299.field_25751.method_5883((class_1937)world);
                } else if (Strider.class.isAssignableFrom(clazz)) {
                    entity = class_1299.field_23214.method_5883((class_1937)world);
                } else if (Zoglin.class.isAssignableFrom(clazz)) {
                    entity = class_1299.field_23696.method_5883((class_1937)world);
                } else if (Axolotl.class.isAssignableFrom(clazz)) {
                    entity = class_1299.field_28315.method_5883((class_1937)world);
                } else if (Goat.class.isAssignableFrom(clazz)) {
                    entity = class_1299.field_30052.method_5883((class_1937)world);
                } else if (Allay.class.isAssignableFrom(clazz)) {
                    entity = class_1299.field_38384.method_5883((class_1937)world);
                } else if (Frog.class.isAssignableFrom(clazz)) {
                    entity = class_1299.field_37419.method_5883((class_1937)world);
                } else if (Warden.class.isAssignableFrom(clazz)) {
                    entity = class_1299.field_38095.method_5883((class_1937)world);
                }
            }
            if (entity != null) {
                entity.method_5641(x, y, z, yaw, pitch);
                entity.method_5847(yaw);
            }
        } else if (Hanging.class.isAssignableFrom(clazz)) {
            if (LeashHitch.class.isAssignableFrom(clazz)) {
                entity = new class_1532((class_1937)world, class_2338.method_49637((double)x, (double)y, (double)z));
            } else {
                BlockFace face = BlockFace.SELF;
                BlockFace[] faces = new BlockFace[]{BlockFace.EAST, BlockFace.NORTH, BlockFace.WEST, BlockFace.SOUTH};
                int width = 16;
                int height = 16;
                if (ItemFrame.class.isAssignableFrom(clazz)) {
                    width = 12;
                    height = 12;
                    faces = new BlockFace[]{BlockFace.EAST, BlockFace.NORTH, BlockFace.WEST, BlockFace.SOUTH, BlockFace.UP, BlockFace.DOWN};
                }
                class_2338 pos = class_2338.method_49637((double)x, (double)y, (double)z);
                for (BlockFace dir : faces) {
                    class_2680 nmsBlock = this.getHandle().method_8320(pos.method_10093(CraftBlock.blockFaceToNotch(dir)));
                    if (!nmsBlock.method_51367() && !class_2312.method_9999((class_2680)nmsBlock)) continue;
                    boolean taken = false;
                    class_238 bb = ItemFrame.class.isAssignableFrom(clazz) ? BukkitExtraConstants.recalculateBoundingBox(null, pos, CraftBlock.blockFaceToNotch(dir).method_10153(), width, height) : BukkitExtraConstants.recalculateBoundingBox(null, pos, CraftBlock.blockFaceToNotch(dir).method_10153(), width, height);
                    List list = this.getHandle().method_8335(null, bb);
                    Iterator it = list.iterator();
                    while (!taken && it.hasNext()) {
                        class_1297 e = (class_1297)it.next();
                        if (!(e instanceof class_1530)) continue;
                        taken = true;
                    }
                    if (taken) continue;
                    face = dir;
                    break;
                }
                if (face == BlockFace.SELF) {
                    face = BlockFace.SOUTH;
                    randomizeData = false;
                }
                class_2350 dir = CraftBlock.blockFaceToNotch(face).method_10153();
                if (Painting.class.isAssignableFrom(clazz)) {
                    if (this.isNormalWorld() && randomizeData) {
                        entity = class_1534.method_43401((class_1937)world, (class_2338)pos, (class_2350)dir).orElse(null);
                    } else {
                        entity = new class_1534(class_1299.field_6120, (class_1937)this.getHandle().getMinecraftWorld());
                        entity.method_5641(x, y, z, yaw, pitch);
                        ((class_1534)entity).method_6892(dir);
                    }
                } else if (ItemFrame.class.isAssignableFrom(clazz)) {
                    entity = GlowItemFrame.class.isAssignableFrom(clazz) ? new class_5915((class_1937)world, class_2338.method_49637((double)x, (double)y, (double)z), dir) : new class_1533((class_1937)world, class_2338.method_49637((double)x, (double)y, (double)z), dir);
                }
            }
        } else if (TNTPrimed.class.isAssignableFrom(clazz)) {
            entity = new class_1541((class_1937)world, x, y, z, null);
        } else if (ExperienceOrb.class.isAssignableFrom(clazz)) {
            entity = new class_1303((class_1937)world, x, y, z, 0);
        } else if (LightningStrike.class.isAssignableFrom(clazz)) {
            entity = class_1299.field_6112.method_5883((class_1937)world);
            entity.method_24203(location.getX(), location.getY(), location.getZ());
        } else if (AreaEffectCloud.class.isAssignableFrom(clazz)) {
            entity = new class_1295((class_1937)world, x, y, z);
        } else if (EvokerFangs.class.isAssignableFrom(clazz)) {
            entity = new class_1669((class_1937)world, x, y, z, (float)Math.toRadians(yaw), 0, null);
        } else if (Marker.class.isAssignableFrom(clazz)) {
            entity = class_1299.field_33456.method_5883((class_1937)world);
            entity.method_5814(x, y, z);
        } else if (class_8150.class.isAssignableFrom(clazz)) {
            entity = class_1299.field_42623.method_5883((class_1937)world);
            entity.method_5814(x, y, z);
        } else if (Display.class.isAssignableFrom(clazz)) {
            if (BlockDisplay.class.isAssignableFrom(clazz)) {
                entity = class_1299.field_42460.method_5883((class_1937)world);
            } else if (ItemDisplay.class.isAssignableFrom(clazz)) {
                entity = class_1299.field_42456.method_5883((class_1937)world);
            } else if (TextDisplay.class.isAssignableFrom(clazz)) {
                entity = class_1299.field_42457.method_5883((class_1937)world);
            }
            if (entity != null) {
                entity.method_5814(x, y, z);
            }
        }
        if (entity != null) {
            return entity;
        }
        throw new IllegalArgumentException("Cannot spawn an entity for " + clazz.getName());
    }
}

