/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_20_R1.inventory;

import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.List;
import net.minecraft.class_1263;
import net.minecraft.class_1799;
import net.minecraft.class_1860;
import org.bukkit.craftbukkit.v1_20_R1.inventory.CraftInventory;
import org.bukkit.craftbukkit.v1_20_R1.inventory.CraftItemStack;
import org.bukkit.inventory.CraftingInventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;

public class CraftInventoryCrafting
extends CraftInventory
implements CraftingInventory {
    private final class_1263 resultInventory;

    public CraftInventoryCrafting(class_1263 inventory, class_1263 resultInventory) {
        super(inventory);
        this.resultInventory = resultInventory;
    }

    public class_1263 getResultInventory() {
        return this.resultInventory;
    }

    public class_1263 getMatrixInventory() {
        return this.inventory;
    }

    @Override
    public int getSize() {
        return this.getResultInventory().method_5439() + this.getMatrixInventory().method_5439();
    }

    @Override
    public void setContents(ItemStack[] items) {
        Preconditions.checkArgument((items.length <= this.getSize() ? 1 : 0) != 0, (String)"Invalid inventory size (%s); expected %s or less", (int)items.length, (int)this.getSize());
        this.setContents(items[0], Arrays.copyOfRange(items, 1, items.length));
    }

    @Override
    public ItemStack[] getContents() {
        ItemStack[] items = new ItemStack[this.getSize()];
        List mcResultItems = this.getResultInventory().getContents();
        int i = 0;
        for (i = 0; i < mcResultItems.size(); ++i) {
            items[i] = CraftItemStack.asCraftMirror((class_1799)mcResultItems.get(i));
        }
        List mcItems = this.getMatrixInventory().getContents();
        for (int j = 0; j < mcItems.size(); ++j) {
            items[i + j] = CraftItemStack.asCraftMirror((class_1799)mcItems.get(j));
        }
        return items;
    }

    public void setContents(ItemStack result, ItemStack[] contents) {
        this.setResult(result);
        this.setMatrix(contents);
    }

    @Override
    public CraftItemStack getItem(int index) {
        if (index < this.getResultInventory().method_5439()) {
            class_1799 item = this.getResultInventory().method_5438(index);
            return item.method_7960() ? null : CraftItemStack.asCraftMirror(item);
        }
        class_1799 item = this.getMatrixInventory().method_5438(index - this.getResultInventory().method_5439());
        return item.method_7960() ? null : CraftItemStack.asCraftMirror(item);
    }

    @Override
    public void setItem(int index, ItemStack item) {
        if (index < this.getResultInventory().method_5439()) {
            this.getResultInventory().method_5447(index, CraftItemStack.asNMSCopy(item));
        } else {
            this.getMatrixInventory().method_5447(index - this.getResultInventory().method_5439(), CraftItemStack.asNMSCopy(item));
        }
    }

    @Override
    public ItemStack[] getMatrix() {
        List matrix = this.getMatrixInventory().getContents();
        return this.asCraftMirror(matrix);
    }

    @Override
    public ItemStack getResult() {
        class_1799 item = this.getResultInventory().method_5438(0);
        if (!item.method_7960()) {
            return CraftItemStack.asCraftMirror(item);
        }
        return null;
    }

    @Override
    public void setMatrix(ItemStack[] contents) {
        Preconditions.checkArgument((contents.length <= this.getMatrixInventory().method_5439() ? 1 : 0) != 0, (String)"Invalid inventory size (%s); expected %s or less", (int)contents.length, (int)this.getMatrixInventory().method_5439());
        for (int i = 0; i < this.getMatrixInventory().method_5439(); ++i) {
            if (i < contents.length) {
                this.getMatrixInventory().method_5447(i, CraftItemStack.asNMSCopy(contents[i]));
                continue;
            }
            this.getMatrixInventory().method_5447(i, class_1799.field_8037);
        }
    }

    @Override
    public void setResult(ItemStack item) {
        List contents = this.getResultInventory().getContents();
        contents.set(0, CraftItemStack.asNMSCopy(item));
    }

    @Override
    public Recipe getRecipe() {
        class_1860 recipe = this.getInventory().getCurrentRecipe();
        return recipe == null ? null : recipe.toBukkitRecipe();
    }
}

