/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.plugin.java;

import com.mohistmc.banner.BannerServer;
import com.mohistmc.banner.bukkit.PluginsLibrarySource;
import com.mohistmc.banner.bukkit.remapping.RemappingURLClassLoader;
import com.mohistmc.banner.util.I18n;
import com.mohistmc.tools.ConnectionUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import mjson.Json;
import org.bukkit.plugin.PluginDescriptionFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class LibraryLoader {
    @Nullable
    public ClassLoader createLoader(@NotNull PluginDescriptionFile desc) throws IOException {
        Object mavenUrl;
        String fileName;
        String group;
        if (desc.getLibraries().isEmpty()) {
            return null;
        }
        BannerServer.LOGGER.info(I18n.as("spigot.lib.loading"), (Object)desc.getName(), (Object)desc.getLibraries().size());
        ArrayList dependencies = new ArrayList();
        for (String libraries : desc.getLibraries()) {
            String[] args = libraries.split(":");
            if (args.length <= 1) continue;
            Iterator dependency = new Dependency(args[0], args[1], args[2], false);
            dependencies.add(dependency);
        }
        ArrayList<File> libraries = new ArrayList<File>();
        ArrayList<Dependency> newDependencies = new ArrayList<Dependency>();
        List<String> d = this.mohistLibs();
        for (Dependency dependency : dependencies) {
            group = dependency.group().replace(".", "/");
            fileName = "%s-%s.jar".formatted(dependency.name(), dependency.version());
            if (d.contains(fileName)) continue;
            if (dependency.version().toString().equalsIgnoreCase("LATEST")) {
                mavenUrl = URI.create(PluginsLibrarySource.DEFAULT + "%s/%s/%s".formatted(group, dependency.name(), "maven-metadata.xml")).toURL();
                Json compile_json2Json = Json.readXml((URL)mavenUrl).at("metadata");
                List v = compile_json2Json.at("versioning").at("versions").at("version").asList();
                Dependency dependency0 = new Dependency(group, dependency.name(), v.get(v.size() - 1), false);
                newDependencies.add(dependency0);
                continue;
            }
            newDependencies.add(dependency);
            String pomUrl = PluginsLibrarySource.DEFAULT + "%s/%s/%s/%s".formatted(group, dependency.name(), dependency.version(), fileName.replace("jar", "pom"));
            newDependencies.addAll(this.initDependencies0(new URL(pomUrl)));
        }
        BannerServer.LOGGER.info(I18n.as("spigot.lib.loading.extra"), (Object)desc.getName(), (Object)(newDependencies.size() - desc.getLibraries().size()));
        for (Dependency dependency : newDependencies) {
            group = dependency.group().replace(".", "/");
            fileName = "%s-%s.jar".formatted(dependency.name(), dependency.version());
            mavenUrl = PluginsLibrarySource.DEFAULT + "%s/%s/%s/%s".formatted(group, dependency.name(), dependency.version(), fileName);
            File file = new File(new File("libraries", "spigot-lib"), "%s/%s/%s/%s".formatted(group, dependency.name(), dependency.version(), fileName));
            if (file.exists()) {
                BannerServer.LOGGER.info(I18n.as("spigot.lib.found"), (Object)desc.getName(), (Object)file);
                libraries.add(file);
                continue;
            }
            try {
                file.getParentFile().mkdirs();
                InputStream inputStream = new URL((String)mavenUrl).openStream();
                ReadableByteChannel rbc = Channels.newChannel(inputStream);
                FileChannel fc = FileChannel.open(file.toPath(), StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING);
                fc.transferFrom(rbc, 0L, Long.MAX_VALUE);
                fc.close();
                rbc.close();
                libraries.add(file);
            }
            catch (IOException e) {
                BannerServer.LOGGER.error(e.getMessage());
            }
        }
        ArrayList<URL> jarFiles = new ArrayList<URL>();
        for (File file : libraries) {
            try {
                jarFiles.add(file.toURI().toURL());
                BannerServer.LOGGER.info(I18n.as("spigot.lib.loaded"), (Object)desc.getName(), (Object)file);
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
        }
        return new RemappingURLClassLoader(jarFiles.toArray(new URL[0]), this.getClass().getClassLoader());
    }

    public List<Dependency> initDependencies0(URL url) throws IOException {
        ArrayList<Dependency> list = new ArrayList<Dependency>();
        for (Dependency dependency : this.initDependencies(url)) {
            list.add(dependency);
            if (!dependency.extra()) continue;
            String group = dependency.group().replace(".", "/");
            String fileName = "%s-%s.jar".formatted(dependency.name(), dependency.version());
            String pomUrl = PluginsLibrarySource.DEFAULT + "%s/%s/%s/%s".formatted(group, dependency.name(), dependency.version(), fileName.replace("jar", "pom"));
            if (!ConnectionUtil.hasUrl((String)pomUrl)) continue;
            list.addAll(this.initDependencies(new URL(pomUrl)));
        }
        return list;
    }

    public List<Dependency> initDependencies(URL url) {
        String groupId;
        ArrayList<Dependency> list = new ArrayList<Dependency>();
        Json json2Json = Json.readXml((URL)url).at("project");
        String version = json2Json.has("parent") ? json2Json.at("parent").asString("version") : json2Json.asString("version");
        String string = groupId = json2Json.has("parent") ? json2Json.at("parent").asString("groupId") : json2Json.asString("groupId");
        if (!json2Json.has("dependencies")) {
            return list;
        }
        if (!json2Json.at("dependencies").toString().startsWith("{\"dependency\"")) {
            return list;
        }
        Json json3Json = json2Json.at("dependencies").at("dependency");
        if (json3Json.isArray()) {
            for (Json o : json2Json.at("dependencies").asJsonList("dependency")) {
                this.dependency(o, list, version, groupId);
            }
        } else {
            this.dependency(json3Json, list, version, groupId);
        }
        return list;
    }

    public void dependency(Json json, List<Dependency> list, String version, String parent_groupId) {
        try {
            if (json.toString().contains("groupId") && json.toString().contains("artifactId")) {
                String groupId = json.asString("groupId");
                String artifactId = json.asString("artifactId");
                if (json.toString().contains("version")) {
                    String versionAsString;
                    if (json.has("scope") && json.asString("scope").equals("test")) {
                        return;
                    }
                    if (groupId.equals("${project.parent.groupId}")) {
                        groupId = parent_groupId;
                    }
                    if ((versionAsString = json.asString("version")).contains("${project.version}") || versionAsString.contains("${project.parent.version}")) {
                        Dependency dependency = new Dependency(groupId, artifactId, version, true);
                        list.add(dependency);
                    } else if (!versionAsString.contains("${")) {
                        Dependency dependency = new Dependency(groupId, artifactId, versionAsString, true);
                        list.add(dependency);
                    }
                } else if (json.has("scope") && json.asString("scope").equals("compile")) {
                    URL mavenUrl = URI.create(PluginsLibrarySource.DEFAULT + "%s/%s/%s".formatted(groupId.replace(".", "/"), artifactId, "maven-metadata.xml")).toURL();
                    Json compile_json2Json = Json.readXml((URL)mavenUrl).at("metadata");
                    List v = compile_json2Json.at("versioning").at("versions").at("version").asList();
                    Dependency dependency = new Dependency(groupId, artifactId, v.get(v.size() - 1), true);
                    list.add(dependency);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public List<String> mohistLibs() {
        ArrayList<String> temp = new ArrayList<String>();
        BufferedReader b = new BufferedReader(new InputStreamReader(LibraryLoader.class.getClassLoader().getResourceAsStream("libraries.txt")));
        try {
            String str;
            while ((str = b.readLine()) != null) {
                String[] s = str.split("\\|");
                temp.add(new File(s[0]).getName());
            }
            b.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return temp;
    }

    public record Dependency(String group, String name, Object version, boolean extra) {
    }
}

