/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_20_R1.inventory;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.mohistmc.banner.bukkit.BukkitExtraConstants;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_3218;
import net.minecraft.class_5321;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.configuration.serialization.DelegateDeserialization;
import org.bukkit.craftbukkit.v1_20_R1.CraftWorld;
import org.bukkit.craftbukkit.v1_20_R1.inventory.CraftMetaItem;
import org.bukkit.inventory.meta.CompassMeta;

@DelegateDeserialization(value=CraftMetaItem.SerializableMeta.class)
public class CraftMetaCompass
extends CraftMetaItem
implements CompassMeta {
    static final CraftMetaItem.ItemMetaKey LODESTONE_DIMENSION = new CraftMetaItem.ItemMetaKey("LodestoneDimension");
    static final CraftMetaItem.ItemMetaKey LODESTONE_POS = new CraftMetaItem.ItemMetaKey("LodestonePos", "lodestone");
    static final CraftMetaItem.ItemMetaKey LODESTONE_POS_WORLD = new CraftMetaItem.ItemMetaKey("LodestonePosWorld");
    static final CraftMetaItem.ItemMetaKey LODESTONE_POS_X = new CraftMetaItem.ItemMetaKey("LodestonePosX");
    static final CraftMetaItem.ItemMetaKey LODESTONE_POS_Y = new CraftMetaItem.ItemMetaKey("LodestonePosY");
    static final CraftMetaItem.ItemMetaKey LODESTONE_POS_Z = new CraftMetaItem.ItemMetaKey("LodestonePosZ");
    static final CraftMetaItem.ItemMetaKey LODESTONE_TRACKED = new CraftMetaItem.ItemMetaKey("LodestoneTracked");
    private class_2519 lodestoneWorld;
    private int lodestoneX;
    private int lodestoneY;
    private int lodestoneZ;
    private Boolean tracked;

    CraftMetaCompass(CraftMetaItem meta) {
        super(meta);
        if (!(meta instanceof CraftMetaCompass)) {
            return;
        }
        CraftMetaCompass compassMeta = (CraftMetaCompass)meta;
        this.lodestoneWorld = compassMeta.lodestoneWorld;
        this.lodestoneX = compassMeta.lodestoneX;
        this.lodestoneY = compassMeta.lodestoneY;
        this.lodestoneZ = compassMeta.lodestoneZ;
        this.tracked = compassMeta.tracked;
    }

    CraftMetaCompass(class_2487 tag) {
        super(tag);
        if (tag.method_10545(CraftMetaCompass.LODESTONE_DIMENSION.NBT) && tag.method_10545(CraftMetaCompass.LODESTONE_POS.NBT)) {
            this.lodestoneWorld = (class_2519)tag.method_10580(CraftMetaCompass.LODESTONE_DIMENSION.NBT);
            class_2487 pos = tag.method_10562(CraftMetaCompass.LODESTONE_POS.NBT);
            this.lodestoneX = pos.method_10550("X");
            this.lodestoneY = pos.method_10550("Y");
            this.lodestoneZ = pos.method_10550("Z");
        }
        if (tag.method_10545(CraftMetaCompass.LODESTONE_TRACKED.NBT)) {
            this.tracked = tag.method_10577(CraftMetaCompass.LODESTONE_TRACKED.NBT);
        }
    }

    CraftMetaCompass(Map<String, Object> map) {
        super(map);
        String lodestoneWorldString = CraftMetaItem.SerializableMeta.getString(map, CraftMetaCompass.LODESTONE_POS_WORLD.BUKKIT, true);
        if (lodestoneWorldString != null) {
            this.lodestoneWorld = class_2519.method_23256((String)lodestoneWorldString);
            this.lodestoneX = (Integer)map.get(CraftMetaCompass.LODESTONE_POS_X.BUKKIT);
            this.lodestoneY = (Integer)map.get(CraftMetaCompass.LODESTONE_POS_Y.BUKKIT);
            this.lodestoneZ = (Integer)map.get(CraftMetaCompass.LODESTONE_POS_Z.BUKKIT);
        } else {
            Location lodestone = CraftMetaItem.SerializableMeta.getObject(Location.class, map, CraftMetaCompass.LODESTONE_POS.BUKKIT, true);
            if (lodestone != null && lodestone.getWorld() != null) {
                this.setLodestone(lodestone);
            }
        }
        this.tracked = CraftMetaItem.SerializableMeta.getBoolean(map, CraftMetaCompass.LODESTONE_TRACKED.BUKKIT);
    }

    @Override
    void applyToItem(class_2487 tag) {
        super.applyToItem(tag);
        if (this.lodestoneWorld != null) {
            class_2487 pos = new class_2487();
            pos.method_10569("X", this.lodestoneX);
            pos.method_10569("Y", this.lodestoneY);
            pos.method_10569("Z", this.lodestoneZ);
            tag.method_10566(CraftMetaCompass.LODESTONE_POS.NBT, (class_2520)pos);
            tag.method_10566(CraftMetaCompass.LODESTONE_DIMENSION.NBT, (class_2520)this.lodestoneWorld);
        }
        if (this.tracked != null) {
            tag.method_10556(CraftMetaCompass.LODESTONE_TRACKED.NBT, this.tracked.booleanValue());
        }
    }

    @Override
    boolean isEmpty() {
        return super.isEmpty() && this.isCompassEmpty();
    }

    boolean isCompassEmpty() {
        return !this.hasLodestone() && !this.hasLodestoneTracked();
    }

    @Override
    boolean applicableTo(Material type) {
        return type == Material.COMPASS;
    }

    @Override
    public CraftMetaCompass clone() {
        CraftMetaCompass clone = (CraftMetaCompass)super.clone();
        return clone;
    }

    @Override
    public boolean hasLodestone() {
        return this.lodestoneWorld != null;
    }

    @Override
    public Location getLodestone() {
        if (this.lodestoneWorld == null) {
            return null;
        }
        Optional key = class_1937.field_25178.parse((DynamicOps)class_2509.field_11560, (Object)this.lodestoneWorld).result();
        class_3218 worldServer = key.isPresent() ? BukkitExtraConstants.getServer().method_3847((class_5321)key.get()) : null;
        CraftWorld world = worldServer != null ? worldServer.getWorld() : null;
        return new Location(world, this.lodestoneX, this.lodestoneY, this.lodestoneZ);
    }

    @Override
    public void setLodestone(Location lodestone) {
        Preconditions.checkArgument((lodestone == null || lodestone.getWorld() != null ? 1 : 0) != 0, (Object)"world is null");
        if (lodestone == null) {
            this.lodestoneWorld = null;
        } else {
            class_5321 key = ((CraftWorld)lodestone.getWorld()).getHandle().method_27983();
            DataResult dataresult = class_1937.field_25178.encodeStart((DynamicOps)class_2509.field_11560, (Object)key);
            this.lodestoneWorld = (class_2519)dataresult.get().orThrow();
            this.lodestoneX = lodestone.getBlockX();
            this.lodestoneY = lodestone.getBlockY();
            this.lodestoneZ = lodestone.getBlockZ();
        }
    }

    boolean hasLodestoneTracked() {
        return this.tracked != null;
    }

    @Override
    public boolean isLodestoneTracked() {
        return this.hasLodestoneTracked() && this.tracked != false;
    }

    @Override
    public void setLodestoneTracked(boolean tracked) {
        this.tracked = tracked;
    }

    @Override
    int applyHash() {
        int original;
        int hash = original = super.applyHash();
        if (this.hasLodestone()) {
            hash = 73 * hash + this.lodestoneWorld.hashCode();
            hash = 73 * hash + this.lodestoneX;
            hash = 73 * hash + this.lodestoneY;
            hash = 73 * hash + this.lodestoneZ;
        }
        if (this.hasLodestoneTracked()) {
            hash = 73 * hash + (this.isLodestoneTracked() ? 1231 : 1237);
        }
        return original != hash ? CraftMetaCompass.class.hashCode() ^ hash : hash;
    }

    @Override
    boolean equalsCommon(CraftMetaItem meta) {
        if (!super.equalsCommon(meta)) {
            return false;
        }
        if (meta instanceof CraftMetaCompass) {
            CraftMetaCompass that = (CraftMetaCompass)meta;
            return (this.hasLodestone() ? that.hasLodestone() && this.lodestoneWorld.method_10714().equals(that.lodestoneWorld.method_10714()) && this.lodestoneX == that.lodestoneX && this.lodestoneY == that.lodestoneY && this.lodestoneZ == that.lodestoneZ : !that.hasLodestone()) && this.tracked == that.tracked;
        }
        return true;
    }

    @Override
    boolean notUncommon(CraftMetaItem meta) {
        return super.notUncommon(meta) && (meta instanceof CraftMetaCompass || this.isCompassEmpty());
    }

    @Override
    ImmutableMap.Builder<String, Object> serialize(ImmutableMap.Builder<String, Object> builder) {
        super.serialize(builder);
        if (this.hasLodestone()) {
            builder.put((Object)CraftMetaCompass.LODESTONE_POS_WORLD.BUKKIT, (Object)this.lodestoneWorld.method_10714());
            builder.put((Object)CraftMetaCompass.LODESTONE_POS_X.BUKKIT, (Object)this.lodestoneX);
            builder.put((Object)CraftMetaCompass.LODESTONE_POS_Y.BUKKIT, (Object)this.lodestoneY);
            builder.put((Object)CraftMetaCompass.LODESTONE_POS_Z.BUKKIT, (Object)this.lodestoneZ);
        }
        if (this.hasLodestoneTracked()) {
            builder.put((Object)CraftMetaCompass.LODESTONE_TRACKED.BUKKIT, (Object)this.tracked);
        }
        return builder;
    }
}

