/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_20_R1.persistence;

import com.google.common.base.Preconditions;
import com.google.common.primitives.Primitives;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import net.minecraft.class_2479;
import net.minecraft.class_2481;
import net.minecraft.class_2487;
import net.minecraft.class_2489;
import net.minecraft.class_2494;
import net.minecraft.class_2495;
import net.minecraft.class_2497;
import net.minecraft.class_2499;
import net.minecraft.class_2501;
import net.minecraft.class_2503;
import net.minecraft.class_2516;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import org.bukkit.craftbukkit.v1_20_R1.persistence.CraftPersistentDataContainer;
import org.bukkit.persistence.PersistentDataContainer;

public final class CraftPersistentDataTypeRegistry {
    private final Function<Class, TagAdapter> CREATE_ADAPTER = this::createAdapter;
    private final Map<Class, TagAdapter> adapters = new HashMap<Class, TagAdapter>();

    private <T> TagAdapter createAdapter(Class<T> type) {
        if (!Primitives.isWrapperType(type)) {
            type = Primitives.wrap(type);
        }
        if (Objects.equals(Byte.class, type)) {
            return this.createAdapter(Byte.class, class_2481.class, class_2481::method_23233, class_2481::method_10698);
        }
        if (Objects.equals(Short.class, type)) {
            return this.createAdapter(Short.class, class_2516.class, class_2516::method_23254, class_2516::method_10696);
        }
        if (Objects.equals(Integer.class, type)) {
            return this.createAdapter(Integer.class, class_2497.class, class_2497::method_23247, class_2497::method_10701);
        }
        if (Objects.equals(Long.class, type)) {
            return this.createAdapter(Long.class, class_2503.class, class_2503::method_23251, class_2503::method_10699);
        }
        if (Objects.equals(Float.class, type)) {
            return this.createAdapter(Float.class, class_2494.class, class_2494::method_23244, class_2494::method_10700);
        }
        if (Objects.equals(Double.class, type)) {
            return this.createAdapter(Double.class, class_2489.class, class_2489::method_23241, class_2489::method_10697);
        }
        if (Objects.equals(String.class, type)) {
            return this.createAdapter(String.class, class_2519.class, class_2519::method_23256, class_2519::method_10714);
        }
        if (Objects.equals(byte[].class, type)) {
            return this.createAdapter(byte[].class, class_2479.class, array -> new class_2479(Arrays.copyOf(array, ((byte[])array).length)), n -> Arrays.copyOf(n.method_10521(), n.size()));
        }
        if (Objects.equals(int[].class, type)) {
            return this.createAdapter(int[].class, class_2495.class, array -> new class_2495(Arrays.copyOf(array, ((int[])array).length)), n -> Arrays.copyOf(n.method_10588(), n.size()));
        }
        if (Objects.equals(long[].class, type)) {
            return this.createAdapter(long[].class, class_2501.class, array -> new class_2501(Arrays.copyOf(array, ((long[])array).length)), n -> Arrays.copyOf(n.method_10615(), n.size()));
        }
        if (Objects.equals(PersistentDataContainer[].class, type)) {
            return this.createAdapter(PersistentDataContainer[].class, class_2499.class, containerArray -> {
                class_2499 list = new class_2499();
                for (int i = 0; i < ((PersistentDataContainer[])containerArray).length; ++i) {
                    list.add((Object)((CraftPersistentDataContainer)containerArray[i]).toTagCompound());
                }
                return list;
            }, tag -> {
                PersistentDataContainer[] containerArray = new CraftPersistentDataContainer[tag.size()];
                for (int i = 0; i < tag.size(); ++i) {
                    CraftPersistentDataContainer container = new CraftPersistentDataContainer(this);
                    class_2487 compound = tag.method_10602(i);
                    for (String key : compound.method_10541()) {
                        container.put(key, compound.method_10580(key));
                    }
                    containerArray[i] = container;
                }
                return containerArray;
            });
        }
        if (Objects.equals(PersistentDataContainer.class, type)) {
            return this.createAdapter(CraftPersistentDataContainer.class, class_2487.class, CraftPersistentDataContainer::toTagCompound, tag -> {
                CraftPersistentDataContainer container = new CraftPersistentDataContainer(this);
                for (String key : tag.method_10541()) {
                    container.put(key, tag.method_10580(key));
                }
                return container;
            });
        }
        throw new IllegalArgumentException("Could not find a valid TagAdapter implementation for the requested type " + type.getSimpleName());
    }

    private <T, Z extends class_2520> TagAdapter<T, Z> createAdapter(Class<T> primitiveType, Class<Z> nbtBaseType, Function<T, Z> builder, Function<Z, T> extractor) {
        return new TagAdapter<T, Z>(primitiveType, nbtBaseType, builder, extractor);
    }

    public <T> class_2520 wrap(Class<T> type, T value) {
        return this.adapters.computeIfAbsent(type, this.CREATE_ADAPTER).build(value);
    }

    public <T> boolean isInstanceOf(Class<T> type, class_2520 base) {
        return this.adapters.computeIfAbsent(type, this.CREATE_ADAPTER).isInstance(base);
    }

    public <T> T extract(Class<T> type, class_2520 tag) throws ClassCastException, IllegalArgumentException {
        TagAdapter adapter = this.adapters.computeIfAbsent(type, this.CREATE_ADAPTER);
        Preconditions.checkArgument((boolean)adapter.isInstance(tag), (String)"The found tag instance (%s) cannot store %s", (Object)tag.getClass().getSimpleName(), (Object)type.getSimpleName());
        Object foundValue = adapter.extract(tag);
        Preconditions.checkArgument((boolean)type.isInstance(foundValue), (String)"The found object is of the type %s. Expected type %s", (Object)foundValue.getClass().getSimpleName(), (Object)type.getSimpleName());
        return type.cast(foundValue);
    }

    private class TagAdapter<T, Z extends class_2520> {
        private final Function<T, Z> builder;
        private final Function<Z, T> extractor;
        private final Class<T> primitiveType;
        private final Class<Z> nbtBaseType;

        public TagAdapter(Class<T> primitiveType, Class<Z> nbtBaseType, Function<T, Z> builder, Function<Z, T> extractor) {
            this.primitiveType = primitiveType;
            this.nbtBaseType = nbtBaseType;
            this.builder = builder;
            this.extractor = extractor;
        }

        T extract(class_2520 base) {
            Preconditions.checkArgument((boolean)this.nbtBaseType.isInstance(base), (String)"The provided NBTBase was of the type %s. Expected type %s", (Object)base.getClass().getSimpleName(), (Object)this.nbtBaseType.getSimpleName());
            return this.extractor.apply((class_2520)this.nbtBaseType.cast(base));
        }

        Z build(Object value) {
            Preconditions.checkArgument((boolean)this.primitiveType.isInstance(value), (String)"The provided value was of the type %s. Expected type %s", (Object)value.getClass().getSimpleName(), (Object)this.primitiveType.getSimpleName());
            return (Z)((class_2520)this.builder.apply(this.primitiveType.cast(value)));
        }

        boolean isInstance(class_2520 base) {
            return this.nbtBaseType.isInstance(base);
        }
    }
}

