/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_20_R1.boss;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.stream.Collectors;
import net.minecraft.class_1297;
import net.minecraft.class_2700;
import net.minecraft.class_2876;
import net.minecraft.class_2881;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.boss.BossBar;
import org.bukkit.boss.DragonBattle;
import org.bukkit.craftbukkit.v1_20_R1.CraftWorld;
import org.bukkit.craftbukkit.v1_20_R1.boss.CraftBossBar;
import org.bukkit.craftbukkit.v1_20_R1.entity.CraftEnderCrystal;
import org.bukkit.craftbukkit.v1_20_R1.util.CraftLocation;
import org.bukkit.entity.EnderCrystal;
import org.bukkit.entity.EnderDragon;

public class CraftDragonBattle
implements DragonBattle {
    private final class_2881 handle;

    public CraftDragonBattle(class_2881 handle) {
        this.handle = handle;
    }

    @Override
    public EnderDragon getEnderDragon() {
        class_1297 entity = this.handle.field_13108.method_14190(this.handle.field_13116);
        return entity != null ? (EnderDragon)((Object)entity.getBukkitEntity()) : null;
    }

    @Override
    public BossBar getBossBar() {
        return new CraftBossBar(this.handle.field_13119);
    }

    @Override
    public Location getEndPortalLocation() {
        if (this.handle.field_13117 == null) {
            return null;
        }
        return CraftLocation.toBukkit(this.handle.field_13117, (World)this.handle.field_13108.getWorld());
    }

    @Override
    public boolean generateEndPortal(boolean withPortals) {
        if (this.handle.field_13117 != null || this.handle.method_12531() != null) {
            return false;
        }
        this.handle.method_12518(withPortals);
        return true;
    }

    @Override
    public boolean hasBeenPreviouslyKilled() {
        return this.handle.method_12536();
    }

    @Override
    public void initiateRespawn() {
        this.handle.method_12522();
    }

    @Override
    public boolean initiateRespawn(Collection<EnderCrystal> list) {
        if (this.hasBeenPreviouslyKilled() && this.getRespawnPhase() == DragonBattle.RespawnPhase.NONE) {
            class_2700.class_2702 shapedetector_shapedetectorcollection;
            if (this.handle.field_13117 == null && (shapedetector_shapedetectorcollection = this.handle.method_12531()) == null) {
                this.handle.method_12518(true);
            }
            list = list != null ? new ArrayList<EnderCrystal>(list) : Collections.emptyList();
            list.removeIf(enderCrystal -> {
                if (enderCrystal == null) {
                    return true;
                }
                World world = enderCrystal.getWorld();
                return !((CraftWorld)world).getHandle().equals(this.handle.field_13108);
            });
            this.handle.method_12529(list.stream().map(enderCrystal -> ((CraftEnderCrystal)enderCrystal).getHandle()).collect(Collectors.toList()));
            return this.handle.bridge$isRespawnDragon();
        }
        return false;
    }

    @Override
    public DragonBattle.RespawnPhase getRespawnPhase() {
        return this.toBukkitRespawnPhase(this.handle.field_13120);
    }

    @Override
    public boolean setRespawnPhase(DragonBattle.RespawnPhase phase) {
        Preconditions.checkArgument((phase != null && phase != DragonBattle.RespawnPhase.NONE ? 1 : 0) != 0, (String)"Invalid respawn phase provided: %s", (Object)((Object)phase));
        if (this.handle.field_13120 == null) {
            return false;
        }
        this.handle.method_12521(this.toNMSRespawnPhase(phase));
        return true;
    }

    @Override
    public void resetCrystals() {
        this.handle.method_12524();
    }

    public int hashCode() {
        return this.handle.hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof CraftDragonBattle && ((CraftDragonBattle)obj).handle == this.handle;
    }

    private DragonBattle.RespawnPhase toBukkitRespawnPhase(class_2876 phase) {
        return phase != null ? DragonBattle.RespawnPhase.values()[phase.ordinal()] : DragonBattle.RespawnPhase.NONE;
    }

    private class_2876 toNMSRespawnPhase(DragonBattle.RespawnPhase phase) {
        return phase != DragonBattle.RespawnPhase.NONE ? class_2876.values()[phase.ordinal()] : null;
    }
}

