/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_20_R1.entity;

import com.google.common.base.Preconditions;
import net.minecraft.class_1548;
import net.minecraft.class_1588;
import org.bukkit.craftbukkit.v1_20_R1.CraftServer;
import org.bukkit.craftbukkit.v1_20_R1.entity.CraftMonster;
import org.bukkit.entity.Creeper;
import org.bukkit.event.entity.CreeperPowerEvent;

public class CraftCreeper
extends CraftMonster
implements Creeper {
    public CraftCreeper(CraftServer server, class_1548 entity) {
        super(server, (class_1588)entity);
    }

    @Override
    public boolean isPowered() {
        return this.getHandle().method_6872();
    }

    @Override
    public void setPowered(boolean powered) {
        CreeperPowerEvent.PowerCause cause;
        CreeperPowerEvent.PowerCause powerCause = cause = powered ? CreeperPowerEvent.PowerCause.SET_ON : CreeperPowerEvent.PowerCause.SET_OFF;
        if (this.getHandle().bridge$generation() || !this.callPowerEvent(cause)) {
            this.getHandle().setPowered(powered);
        }
    }

    private boolean callPowerEvent(CreeperPowerEvent.PowerCause cause) {
        CreeperPowerEvent event = new CreeperPowerEvent((Creeper)((Object)this.getHandle().getBukkitEntity()), cause);
        this.server.getPluginManager().callEvent(event);
        return event.isCancelled();
    }

    @Override
    public void setMaxFuseTicks(int ticks) {
        Preconditions.checkArgument((ticks >= 0 ? 1 : 0) != 0, (Object)"ticks < 0");
        this.getHandle().field_7228 = ticks;
    }

    @Override
    public int getMaxFuseTicks() {
        return this.getHandle().field_7228;
    }

    @Override
    public void setFuseTicks(int ticks) {
        Preconditions.checkArgument((ticks >= 0 ? 1 : 0) != 0, (Object)"ticks < 0");
        Preconditions.checkArgument((ticks <= this.getMaxFuseTicks() ? 1 : 0) != 0, (Object)"ticks > maxFuseTicks");
        this.getHandle().field_7227 = ticks;
    }

    @Override
    public int getFuseTicks() {
        return this.getHandle().field_7227;
    }

    @Override
    public void setExplosionRadius(int radius) {
        Preconditions.checkArgument((radius >= 0 ? 1 : 0) != 0, (Object)"radius < 0");
        this.getHandle().field_7225 = radius;
    }

    @Override
    public int getExplosionRadius() {
        return this.getHandle().field_7225;
    }

    @Override
    public void explode() {
        this.getHandle().method_7006();
    }

    @Override
    public void ignite() {
        this.getHandle().method_7004();
    }

    public class_1548 getHandle() {
        return (class_1548)this.entity;
    }

    @Override
    public String toString() {
        return "CraftCreeper";
    }
}

