/*
 * Decompiled with CFR 0.152.
 */
package com.mohistmc.banner.mixin.server.network;

import com.destroystokyo.paper.proxy.VelocityProxy;
import com.mohistmc.banner.config.BannerConfig;
import com.mohistmc.banner.injection.server.network.InjectionServerLoginPacketListenerImpl;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.exceptions.AuthenticationUnavailableException;
import io.netty.buffer.Unpooled;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.security.Key;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicInteger;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import net.minecraft.class_140;
import net.minecraft.class_2535;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2661;
import net.minecraft.class_2899;
import net.minecraft.class_2901;
import net.minecraft.class_2905;
import net.minecraft.class_2907;
import net.minecraft.class_2911;
import net.minecraft.class_2913;
import net.minecraft.class_2915;
import net.minecraft.class_2917;
import net.minecraft.class_3222;
import net.minecraft.class_3248;
import net.minecraft.class_3515;
import net.minecraft.class_4844;
import net.minecraft.class_5250;
import net.minecraft.class_5525;
import net.minecraft.class_7633;
import net.minecraft.class_7648;
import net.minecraft.server.MinecraftServer;
import org.apache.commons.lang3.Validate;
import org.bukkit.Bukkit;
import org.bukkit.craftbukkit.v1_20_R1.CraftServer;
import org.bukkit.craftbukkit.v1_20_R1.util.Waitable;
import org.bukkit.event.player.AsyncPlayerPreLoginEvent;
import org.bukkit.event.player.PlayerPreLoginEvent;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value={class_3248.class})
public abstract class MixinServerLoginPacketListenerImpl
implements class_2911,
class_7633,
InjectionServerLoginPacketListenerImpl {
    @Shadow
    @Nullable
    GameProfile field_14160;
    @Shadow
    @Final
    MinecraftServer field_14162;
    @Shadow
    @Final
    public class_2535 field_14158;
    @Shadow
    class_3248.class_3249 field_14163;
    @Shadow
    @Nullable
    private class_3222 field_14161;
    @Shadow
    @Final
    static Logger field_14166;
    @Shadow
    @Final
    private byte[] field_14167;
    @Shadow
    @Final
    private static AtomicInteger field_14157;
    @Unique
    private static final AtomicInteger threadId;
    @Unique
    private static final ExecutorService authenticatorPool;
    @Unique
    private int velocityLoginMessageId = -1;

    @Shadow
    public abstract void method_14380(class_2561 var1);

    @Shadow
    protected abstract GameProfile method_14375(GameProfile var1);

    @Shadow
    protected abstract void method_33800(class_3222 var1);

    @Override
    @Deprecated
    public void disconnect(String s) {
        this.method_14380((class_2561)class_2561.method_43470((String)s));
    }

    @Unique
    public void initUUID() {
        UUID uid = class_4844.method_43344((String)this.field_14160.getName());
        this.field_14160 = new GameProfile(uid, this.field_14160.getName());
    }

    @Overwrite
    public void method_14384() {
        class_2561 component;
        if (!this.field_14160.isComplete()) {
            // empty if block
        }
        if ((component = this.field_14162.method_3760().method_14586(this.field_14158.method_10755(), this.field_14160)) != null) {
            this.method_14380(component);
        } else {
            this.field_14163 = class_3248.class_3249.field_14172;
            if (this.field_14162.method_3773() >= 0 && !this.field_14158.method_10756()) {
                this.field_14158.method_10752((class_2596)new class_2907(this.field_14162.method_3773()), class_7648.method_45084(() -> this.field_14158.method_10760(this.field_14162.method_3773(), true)));
            }
            this.field_14158.method_10743((class_2596)new class_2901(this.field_14160));
            class_3222 serverPlayer = this.field_14162.method_3760().method_14602(this.field_14160.getId());
            try {
                class_3222 serverPlayer2 = this.field_14162.method_3760().method_14613(this.field_14160);
                if (serverPlayer != null) {
                    this.field_14163 = class_3248.class_3249.field_14171;
                    this.field_14161 = serverPlayer2;
                } else {
                    this.method_33800(serverPlayer2);
                }
            }
            catch (Exception var5) {
                field_14166.error("Couldn't place player in world", (Throwable)var5);
                class_5250 component2 = class_2561.method_43471((String)"multiplayer.disconnect.invalid_player_data");
                this.field_14158.method_10743((class_2596)new class_2661((class_2561)component2));
                this.field_14158.method_10747((class_2561)component2);
            }
        }
    }

    @Overwrite
    public void method_12641(class_2915 packet) {
        Validate.validState((this.field_14163 == class_3248.class_3249.field_14170 ? 1 : 0) != 0, (String)"Unexpected hello packet", (Object[])new Object[0]);
        GameProfile gameProfile = this.field_14162.method_43824();
        if (gameProfile != null && packet.comp_765().equalsIgnoreCase(gameProfile.getName())) {
            this.field_14160 = gameProfile;
            this.field_14163 = class_3248.class_3249.field_14168;
        } else {
            this.field_14160 = new GameProfile((UUID)null, packet.comp_765());
            if (this.field_14162.method_3828() && !this.field_14158.method_10756()) {
                this.field_14163 = class_3248.class_3249.field_14175;
                this.field_14158.method_10743((class_2596)new class_2905("", this.field_14162.method_3716().getPublic().getEncoded(), this.field_14167));
            } else {
                if (BannerConfig.velocityEnabled) {
                    this.velocityLoginMessageId = ThreadLocalRandom.current().nextInt();
                    class_2540 buf = new class_2540(Unpooled.buffer());
                    buf.writeByte(4);
                    this.field_14158.method_10743((class_2596)new class_2899(this.velocityLoginMessageId, VelocityProxy.PLAYER_INFO_CHANNEL, buf));
                    return;
                }
                authenticatorPool.execute(() -> {
                    try {
                        this.initUUID();
                        this.banner$preLogin();
                    }
                    catch (Exception ex) {
                        this.disconnect("Failed to verify username!");
                        field_14166.warn("Exception verifying " + this.field_14160.getName(), (Throwable)ex);
                    }
                });
            }
        }
    }

    @Overwrite
    public void method_12642(class_2917 packetIn) {
        String s;
        Validate.validState((this.field_14163 == class_3248.class_3249.field_14175 ? 1 : 0) != 0, (String)"Unexpected key packet", (Object[])new Object[0]);
        try {
            PrivateKey privatekey = this.field_14162.method_3716().getPrivate();
            if (!packetIn.method_43643(this.field_14167, privatekey)) {
                throw new IllegalStateException("Protocol error");
            }
            SecretKey secretKey = packetIn.method_12654(privatekey);
            Cipher cipher = class_3515.method_15235((int)2, (Key)secretKey);
            Cipher cipher1 = class_3515.method_15235((int)1, (Key)secretKey);
            s = new BigInteger(class_3515.method_15240((String)"", (PublicKey)this.field_14162.method_3716().getPublic(), (SecretKey)secretKey)).toString(16);
            this.field_14163 = class_3248.class_3249.field_14169;
            this.field_14158.method_10746(cipher, cipher1);
        }
        catch (class_5525 cryptexception) {
            throw new IllegalStateException("Protocol error", cryptexception);
        }
        class Handler
        extends Thread {
            Handler(int i) {
                super("User Authenticator #" + i);
            }

            @Override
            public void run() {
                GameProfile gameprofile = MixinServerLoginPacketListenerImpl.this.field_14160;
                try {
                    MixinServerLoginPacketListenerImpl.this.field_14160 = MixinServerLoginPacketListenerImpl.this.field_14162.method_3844().hasJoinedServer(new GameProfile(null, gameprofile.getName()), s, this.getAddress());
                    if (MixinServerLoginPacketListenerImpl.this.field_14160 != null) {
                        if (!MixinServerLoginPacketListenerImpl.this.field_14158.method_10758()) {
                            return;
                        }
                        MixinServerLoginPacketListenerImpl.this.banner$preLogin();
                    } else if (MixinServerLoginPacketListenerImpl.this.field_14162.method_3724()) {
                        field_14166.warn("Failed to verify username but will let them in anyway!");
                        MixinServerLoginPacketListenerImpl.this.field_14160 = MixinServerLoginPacketListenerImpl.this.method_14375(gameprofile);
                        MixinServerLoginPacketListenerImpl.this.field_14163 = class_3248.class_3249.field_14168;
                    } else {
                        MixinServerLoginPacketListenerImpl.this.method_14380((class_2561)class_2561.method_43471((String)"multiplayer.disconnect.unverified_username"));
                        field_14166.error("Username '{}' tried to join with an invalid session", (Object)gameprofile.getName());
                    }
                }
                catch (AuthenticationUnavailableException authenticationunavailableexception) {
                    if (MixinServerLoginPacketListenerImpl.this.field_14162.method_3724()) {
                        field_14166.warn("Authentication servers are down but will let them in anyway!");
                        MixinServerLoginPacketListenerImpl.this.field_14160 = gameprofile;
                        MixinServerLoginPacketListenerImpl.this.field_14163 = class_3248.class_3249.field_14168;
                    } else {
                        MixinServerLoginPacketListenerImpl.this.method_14380((class_2561)class_2561.method_43471((String)"multiplayer.disconnect.authservers_down"));
                        field_14166.error("Couldn't verify username because servers are unavailable");
                    }
                }
                catch (Exception exception) {
                    MixinServerLoginPacketListenerImpl.this.disconnect("Failed to verify username!");
                    field_14166.warn("Exception verifying " + gameprofile.getName(), (Throwable)exception);
                }
            }

            @Nullable
            private InetAddress getAddress() {
                SocketAddress socketaddress = MixinServerLoginPacketListenerImpl.this.field_14158.method_10755();
                return MixinServerLoginPacketListenerImpl.this.field_14162.method_3775() && socketaddress instanceof InetSocketAddress ? ((InetSocketAddress)socketaddress).getAddress() : null;
            }
        }
        Handler thread = new Handler(field_14157.incrementAndGet());
        thread.setUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)new class_140(field_14166));
        thread.start();
    }

    @Unique
    void banner$preLogin() throws Exception {
        if (this.velocityLoginMessageId == -1 && BannerConfig.velocityEnabled) {
            this.disconnect("This server requires you to connect with Velocity.");
            return;
        }
        String playerName = this.field_14160.getName();
        InetAddress address = ((InetSocketAddress)this.field_14158.method_10755()).getAddress();
        UUID uniqueId = this.field_14160.getId();
        final CraftServer craftServer = (CraftServer)Bukkit.getServer();
        AsyncPlayerPreLoginEvent asyncEvent = new AsyncPlayerPreLoginEvent(playerName, address, uniqueId);
        craftServer.getPluginManager().callEvent(asyncEvent);
        if (PlayerPreLoginEvent.getHandlerList().getRegisteredListeners().length != 0) {
            final PlayerPreLoginEvent event = new PlayerPreLoginEvent(playerName, address, uniqueId);
            if (asyncEvent.getResult() != PlayerPreLoginEvent.Result.ALLOWED) {
                event.disallow(asyncEvent.getResult(), asyncEvent.getKickMessage());
            }
            class SyncPreLogin
            extends Waitable<PlayerPreLoginEvent.Result> {
                SyncPreLogin() {
                }

                @Override
                protected PlayerPreLoginEvent.Result evaluate() {
                    craftServer.getPluginManager().callEvent(event);
                    return event.getResult();
                }
            }
            SyncPreLogin waitable = new SyncPreLogin();
            this.field_14162.bridge$queuedProcess((Runnable)waitable);
            if (waitable.get() != PlayerPreLoginEvent.Result.ALLOWED) {
                this.disconnect(event.getKickMessage());
                return;
            }
        } else if (asyncEvent.getLoginResult() != AsyncPlayerPreLoginEvent.Result.ALLOWED) {
            this.disconnect(asyncEvent.getKickMessage());
            return;
        }
        field_14166.info("UUID of player {} is {}", (Object)this.field_14160.getName(), (Object)this.field_14160.getId());
        this.field_14163 = class_3248.class_3249.field_14168;
    }

    @Overwrite
    public void method_12640(class_2913 packet) {
        if (BannerConfig.velocityEnabled && packet.method_36178() == this.velocityLoginMessageId) {
            class_2540 buf = packet.method_36179();
            if (buf == null) {
                this.disconnect("This server requires you to connect with Velocity.");
                return;
            }
            if (!VelocityProxy.checkIntegrity(buf)) {
                this.disconnect("Unable to verify player details");
                return;
            }
            int version = buf.method_10816();
            if (version > 4) {
                throw new IllegalStateException("Unsupported forwarding version " + version + ", wanted upto 4");
            }
            SocketAddress listening = this.field_14158.method_10755();
            int port = 0;
            if (listening instanceof InetSocketAddress) {
                port = ((InetSocketAddress)listening).getPort();
            }
            this.field_14158.field_11645 = new InetSocketAddress(VelocityProxy.readAddress(buf), port);
            this.field_14160 = VelocityProxy.createProfile(buf);
            authenticatorPool.execute(() -> {
                try {
                    this.banner$preLogin();
                }
                catch (Exception ex) {
                    this.disconnect("Failed to verify username!");
                    field_14166.warn("Exception verifying " + this.field_14160.getName(), (Throwable)ex);
                }
            });
            return;
        }
        this.method_14380((class_2561)class_2561.method_43471((String)"multiplayer.disconnect.unexpected_query_response"));
    }

    static {
        threadId = new AtomicInteger(0);
        authenticatorPool = Executors.newCachedThreadPool(r -> {
            Thread ret = new Thread(r, "User Authenticator #" + threadId.incrementAndGet());
            ret.setUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)new class_140(field_14166));
            return ret;
        });
    }
}

