/*
 * Decompiled with CFR 0.152.
 */
package com.mohistmc.banner.config;

import com.google.common.base.Throwables;
import com.mohistmc.banner.api.color.ColorsAPI;
import com.mohistmc.banner.network.download.DownloadSource;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.YamlConfiguration;

public class BannerConfig {
    private static File CONFIG_FILE;
    private static final String HEADER = "This is the main configuration file for Banner.\nAs you can see, there's tons to configure. Some options may impact gameplay, so use\nwith caution, and make sure you know what each option does before configuring.\n";
    public static YamlConfiguration config;
    static int version;
    public static int maximumRepairCost;
    public static boolean enchantment_fix;
    public static int max_enchantment_level;
    public static boolean check_update;
    public static boolean check_libraries;
    public static String libraries_downloadsource;
    public static String lang;
    public static boolean showLogo;
    public static boolean stackdeobf;
    public static boolean isSymlinkWorld;
    public static boolean skipOtherWorldPreparing;
    public static int server_thread;
    public static List<String> nospawnEntity;
    public static boolean clear_item;
    public static List<String> clear_item__whitelist;
    public static String clear_item__msg;
    public static int clear_item__time;
    public static boolean motdEnable;
    public static String motdFirstLine;
    public static String motdSecondLine;
    public static boolean velocityEnabled;
    public static String velocitySecret;
    public static double WatchDogTimeOut;
    public static boolean spawnForChunk;

    public static void init(File configFile) {
        CONFIG_FILE = configFile;
        config = new YamlConfiguration();
        try {
            config.load(CONFIG_FILE);
        }
        catch (IOException | InvalidConfigurationException ex) {
            Bukkit.getLogger().log(Level.SEVERE, "Could not load banner.yml, please correct your syntax errors", ex);
            throw Throwables.propagate((Throwable)ex);
        }
        config.options().header(HEADER);
        config.options().copyDefaults(true);
        version = BannerConfig.getInt("config-version", 12);
        BannerConfig.set("config-version", 12);
        BannerConfig.readConfig(BannerConfig.class, null);
    }

    static void readConfig(Class<?> clazz, Object instance) {
        for (Method method : clazz.getDeclaredMethods()) {
            if (!Modifier.isPrivate(method.getModifiers()) || method.getParameterTypes().length != 0 || method.getReturnType() != Void.TYPE) continue;
            try {
                method.setAccessible(true);
                method.invoke(instance, new Object[0]);
            }
            catch (InvocationTargetException ex) {
                throw Throwables.propagate((Throwable)ex.getCause());
            }
            catch (Exception ex) {
                Bukkit.getLogger().log(Level.SEVERE, "Error invoking " + method, ex);
            }
        }
        try {
            config.save(CONFIG_FILE);
        }
        catch (IOException ex) {
            Bukkit.getLogger().log(Level.SEVERE, "Could not save " + CONFIG_FILE, ex);
        }
    }

    private static void set(String path, Object val) {
        config.set(path, val);
    }

    private static boolean getBoolean(String path, boolean def) {
        config.addDefault(path, def);
        return config.getBoolean(path, config.getBoolean(path));
    }

    private static int getInt(String path, int def) {
        config.addDefault(path, def);
        return config.getInt(path, config.getInt(path));
    }

    private static <T> List getList(String path, T def) {
        config.addDefault(path, def);
        return config.getList(path, config.getList(path));
    }

    private static String getString(String path, String def) {
        config.addDefault(path, def);
        return config.getString(path, config.getString(path));
    }

    private static double getDouble(String path, double def) {
        config.addDefault(path, def);
        return config.getDouble(path, config.getDouble(path));
    }

    public static String motd() {
        return ColorsAPI.of(motdFirstLine) + "\n" + ColorsAPI.of(motdSecondLine);
    }

    private static void banner() {
        check_update = BannerConfig.getBoolean("banner.check_update", false);
        check_libraries = BannerConfig.getBoolean("banner.check_libraries", true);
        libraries_downloadsource = BannerConfig.getString("banner.libraries_downloadsource", DownloadSource.defaultSource.name());
        lang = BannerConfig.getString("banner.lang", "xx_XX");
        showLogo = BannerConfig.getBoolean("banner.show_logo", true);
        stackdeobf = BannerConfig.getBoolean("banner.stackdeobf", true);
        maximumRepairCost = BannerConfig.getInt("anvilfix.maximumrepaircost", 40);
        enchantment_fix = BannerConfig.getBoolean("anvilfix.enchantment_fix", false);
        max_enchantment_level = BannerConfig.getInt("anvilfix.max_enchantment_level", Short.MAX_VALUE);
        isSymlinkWorld = BannerConfig.getBoolean("compat.symlink_world", true);
        skipOtherWorldPreparing = BannerConfig.getBoolean("compat.skipOtherWorldPreparing", false);
        server_thread = BannerConfig.getInt("threadpriority.server_thread", 8);
        nospawnEntity = BannerConfig.getList("entity.nospawn", Collections.emptyList());
        spawnForChunk = BannerConfig.getBoolean("entity.spawnForChunk", true);
        clear_item = BannerConfig.getBoolean("entity.clear.item.enable", false);
        clear_item__whitelist = BannerConfig.getList("entity.clear.item.whitelist", Collections.emptyList());
        clear_item__msg = BannerConfig.getString("entity.clear.item.msg", "[Server] Cleaned up %size% drops");
        clear_item__time = BannerConfig.getInt("entity.clear.item.time", 1800);
        motdEnable = BannerConfig.getBoolean("motd.enable", true);
        motdFirstLine = BannerConfig.getString("motd.firstline", "<RAINBOW1>A Minecraft Server</RAINBOW>");
        motdSecondLine = BannerConfig.getString("motd.secondline", "");
        velocityEnabled = BannerConfig.getBoolean("proxies.velocity.enabled", false);
        velocitySecret = BannerConfig.getString("proxies.velocity.secret", "");
    }
}

