/*
 * Decompiled with CFR 0.152.
 */
package com.mohistmc.banner.libraries;

import com.mohistmc.banner.libraries.KnotLibraryHelper;
import com.mohistmc.banner.network.download.DownloadSource;
import com.mohistmc.banner.network.download.UpdateUtils;
import com.mohistmc.banner.util.I18n;
import com.mohistmc.tools.MD5Util;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;
import net.fabricmc.loader.api.FabricLoader;

public class DefaultLibraries {
    public static final HashMap<String, String> fail = new HashMap();
    public static final AtomicLong allSize = new AtomicLong();
    public static final String MAVENURL = DownloadSource.get().getUrl();

    public static String libUrl(File lib) {
        return MAVENURL + "libraries/" + lib.getAbsolutePath().replaceAll("\\\\", "/").split("/libraries/")[1];
    }

    public static void run() throws Exception {
        System.out.println(I18n.as("libraries.checking.start"));
        LinkedHashMap<File, String> libs = DefaultLibraries.getDefaultLibs();
        AtomicLong currentSize = new AtomicLong();
        LinkedHashSet<File> defaultLibs = new LinkedHashSet<File>();
        for (File lib : DefaultLibraries.getDefaultLibs().keySet()) {
            if (lib.exists() && MD5Util.get((File)lib).equals(libs.get(lib))) {
                currentSize.addAndGet(lib.length());
                continue;
            }
            defaultLibs.add(lib);
        }
        if (!defaultLibs.isEmpty()) {
            System.out.println(I18n.as("libraries.downloadsource", DownloadSource.get().name()));
        }
        for (File lib : defaultLibs) {
            lib.getParentFile().mkdirs();
            String u = DefaultLibraries.libUrl(lib);
            System.out.println(I18n.as("libraries.global.percentage", Math.round((float)(currentSize.get() * 100L) / (float)allSize.get()) + "%"));
            try {
                UpdateUtils.downloadFile(u, lib, libs.get(lib), true);
                currentSize.addAndGet(lib.length());
                fail.remove(u.replace(MAVENURL, ""));
            }
            catch (Exception e) {
                if (e.getMessage() != null && !"md5".equals(e.getMessage())) {
                    System.out.println(I18n.as("file.download.nook", u));
                    lib.delete();
                }
                fail.put(u.replace(MAVENURL, ""), lib.getAbsolutePath());
            }
        }
        if (!fail.isEmpty()) {
            DefaultLibraries.run();
        } else {
            System.out.println(I18n.as("libraries.check.end"));
        }
    }

    public static void proposeFabricLibs() throws Exception {
        LinkedHashSet<File> defaultLibs = new LinkedHashSet<File>(DefaultLibraries.getDefaultLibs().keySet());
        for (File lib : defaultLibs) {
            if (!lib.exists()) continue;
            KnotLibraryHelper.propose(lib);
        }
    }

    public static LinkedHashMap<File, String> getDefaultLibs() throws Exception {
        String str;
        LinkedHashMap<File, String> temp = new LinkedHashMap<File, String>();
        BufferedReader b = new BufferedReader(new InputStreamReader(Objects.requireNonNull(DefaultLibraries.class.getClassLoader().getResourceAsStream("libraries.txt"))));
        while ((str = b.readLine()) != null) {
            String[] s = str.split("\\|");
            temp.put(new File(FabricLoader.getInstance().getGameDir() + "/" + s[0]), s[1]);
            allSize.addAndGet(Long.parseLong(s[2]));
        }
        b.close();
        return temp;
    }
}

