/*
 * Decompiled with CFR 0.152.
 */
package com.mohistmc.banner.mixin.world.food;

import com.mohistmc.banner.injection.world.food.InjectionFoodData;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.class_1657;
import net.minecraft.class_1702;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_3222;
import net.minecraft.class_4174;
import org.apache.commons.lang.Validate;
import org.bukkit.craftbukkit.v1_20_R1.event.CraftEventFactory;
import org.bukkit.event.entity.EntityExhaustionEvent;
import org.bukkit.event.entity.EntityRegainHealthEvent;
import org.bukkit.event.entity.FoodLevelChangeEvent;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Constant;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyConstant;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_1702.class})
public abstract class MixinFoodData
implements InjectionFoodData {
    @Shadow
    public int field_7756;
    @Shadow
    private int field_7754;
    @Shadow
    public float field_7753;
    @Unique
    private class_1657 entityhuman;
    @Unique
    public int saturatedRegenRate = 10;
    @Unique
    public int unsaturatedRegenRate = 80;
    @Unique
    public int starvationRate = 80;
    @Unique
    private transient class_1792 banner$foodItem;
    @Unique
    private transient class_1799 banner$foodStack;
    @Unique
    private AtomicBoolean duplicateCall = new AtomicBoolean(false);

    @Unique
    public void banner$constructor() {
        throw new RuntimeException();
    }

    @Unique
    public void banner$constructor(class_1657 entityhuman) {
        Validate.notNull((Object)entityhuman);
        this.entityhuman = entityhuman;
    }

    @Inject(method={"eat(IF)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void banner$eatCake(int foodLevelModifier, float saturationLevelModifier, CallbackInfo ci) {
        if (!this.duplicateCall.getAndSet(false)) {
            int old = this.field_7756;
            FoodLevelChangeEvent event = CraftEventFactory.callFoodLevelChangeEvent(this.entityhuman, old + foodLevelModifier);
            if (event.isCancelled()) {
                ci.cancel();
            }
            foodLevelModifier = event.getFoodLevel() - old;
        }
    }

    @Inject(method={"eat(IF)V"}, at={@At(value="TAIL")})
    private void banner$sendUpdate(int foodLevelModifier, float saturationLevelModifier, CallbackInfo ci) {
        ((class_3222)this.entityhuman).getBukkitEntity().sendHealthUpdate();
    }

    @Inject(method={"eat(Lnet/minecraft/world/item/Item;Lnet/minecraft/world/item/ItemStack;)V"}, at={@At(value="HEAD")})
    private void banner$setFoodInformation(class_1792 item, class_1799 stack, CallbackInfo ci) {
        this.banner$foodItem = item;
        this.banner$foodStack = stack;
    }

    @Redirect(method={"eat(Lnet/minecraft/world/item/Item;Lnet/minecraft/world/item/ItemStack;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/food/FoodData;eat(IF)V"))
    private void banner$foodLevelChange(class_1702 instance, int foodLevelModifier, float saturationLevelModifier) {
        int oldFoodLevel = this.field_7756;
        class_4174 foodInfo = this.banner$foodItem.method_19264();
        FoodLevelChangeEvent event = CraftEventFactory.callFoodLevelChangeEvent(this.entityhuman, foodInfo.method_19230() + oldFoodLevel, this.banner$foodStack);
        if (!event.isCancelled()) {
            this.duplicateCall.set(true);
            instance.method_7585(event.getFoodLevel() - oldFoodLevel, saturationLevelModifier);
        }
    }

    @Inject(method={"tick"}, at={@At(value="INVOKE_ASSIGN", remap=false, target="Ljava/lang/Math;max(II)I")})
    public void banner$foodLevelChange2(class_1657 player, CallbackInfo ci) {
        if (this.entityhuman == null) {
            return;
        }
        FoodLevelChangeEvent event = CraftEventFactory.callFoodLevelChangeEvent(this.entityhuman, Math.max(this.field_7754 - 1, 0));
        this.duplicateCall.set(true);
        this.field_7756 = !event.isCancelled() ? event.getFoodLevel() : this.field_7754;
    }

    @Inject(method={"tick"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/player/Player;heal(F)V")})
    public void banner$heal(class_1657 player, CallbackInfo ci) {
        if (this.entityhuman == null) {
            this.entityhuman = player;
        }
        player.pushHealReason(EntityRegainHealthEvent.RegainReason.SATIATED);
        player.pushExhaustReason(EntityExhaustionEvent.ExhaustionReason.REGEN);
    }

    @ModifyConstant(method={"tick"}, constant={@Constant(intValue=10)})
    private int banner$changeValue(int constant) {
        return this.saturatedRegenRate;
    }

    @ModifyConstant(method={"tick"}, constant={@Constant(intValue=80, ordinal=0)})
    private int banner$changeValue0(int constant) {
        return this.unsaturatedRegenRate;
    }

    @ModifyConstant(method={"tick"}, constant={@Constant(intValue=80, ordinal=1)})
    private int banner$changeValue1(int constant) {
        return this.starvationRate;
    }

    @Override
    public class_1657 getEntityhuman() {
        return this.entityhuman;
    }

    @Override
    public void setEntityhuman(class_1657 entityhuman) {
        this.entityhuman = entityhuman;
    }

    @Override
    public int bridge$saturatedRegenRate() {
        return this.saturatedRegenRate;
    }

    @Override
    public void banner$setSaturatedRegenRate(int saturatedRegenRate) {
        this.saturatedRegenRate = saturatedRegenRate;
    }

    @Override
    public int bridge$unsaturatedRegenRate() {
        return this.unsaturatedRegenRate;
    }

    @Override
    public void banner$setUnsaturatedRegenRate(int unsaturatedRegenRate) {
        this.unsaturatedRegenRate = unsaturatedRegenRate;
    }

    @Override
    public int bridge$starvationRate() {
        return this.starvationRate;
    }

    @Override
    public void banner$setStarvationRate(int starvationRate) {
        this.starvationRate = starvationRate;
    }
}

