/*
 * Decompiled with CFR 0.152.
 */
package com.mohistmc.banner.network.download;

import com.mohistmc.banner.BannerMCStart;
import com.mohistmc.banner.util.I18n;
import com.mohistmc.mjson.Json;
import com.mohistmc.tools.ConnectionUtil;
import com.mohistmc.tools.MD5Util;
import com.mohistmc.tools.NumberUtil;
import java.io.File;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.file.StandardOpenOption;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class UpdateUtils {
    private static int percentage = 0;

    public static void versionCheck() {
        System.out.println(I18n.as("update.check"));
        System.out.println(I18n.as("update.stopcheck"));
        try {
            Json json = Json.read((URL)URI.create("https://ci.codemc.io/job/MohistMC/job/Banner-1.20/lastSuccessfulBuild/api/json").toURL());
            String jar_sha = BannerMCStart.getVersion();
            String build_number = json.asString("number");
            String time = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date(json.asLong("timestamp")));
            if (jar_sha.equals(build_number)) {
                System.out.println(I18n.as("update.latest", jar_sha, build_number));
            } else {
                System.out.println(I18n.as("update.detect", build_number, jar_sha, time));
            }
        }
        catch (Throwable e) {
            System.out.println(I18n.as("check.update.noci"));
        }
    }

    public static void downloadFile(String URL2, File f) throws Exception {
        UpdateUtils.downloadFile(URL2, f, null, true);
    }

    public static void downloadFile(String URL2, File f, String md5, boolean showlog) throws Exception {
        URLConnection conn = ConnectionUtil.getConn((String)URL2);
        if (showlog) {
            System.out.println(I18n.as("download.file", f.getName(), NumberUtil.getSize((int)conn.getContentLength())));
        }
        ReadableByteChannel rbc = Channels.newChannel(conn.getInputStream());
        FileChannel fc = FileChannel.open(f.toPath(), StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING);
        int fS = conn.getContentLength();
        ScheduledThreadPoolExecutor scheduledExecutorService = new ScheduledThreadPoolExecutor(2);
        scheduledExecutorService.scheduleAtFixedRate(() -> {
            if (rbc.isOpen()) {
                if (percentage != Math.round((float)f.length() / (float)fS * 100.0f) && percentage < 100) {
                    System.out.println(I18n.as("file.download.percentage", f.getName(), percentage));
                }
                percentage = Math.round((float)f.length() / (float)fS * 100.0f);
            }
        }, 3000L, 1000L, TimeUnit.SECONDS);
        fc.transferFrom(rbc, 0L, Long.MAX_VALUE);
        fc.close();
        rbc.close();
        percentage = 0;
        String MD5 = MD5Util.get((File)f);
        if (f.getName().endsWith(".jar") && md5 != null && MD5 != null && !MD5.equals(md5.toLowerCase())) {
            f.delete();
            if (showlog) {
                System.out.println(I18n.as("file.download.nook.md5", URL2, MD5, md5.toLowerCase()));
            }
            throw new Exception("md5");
        }
        if (showlog) {
            System.out.println(I18n.as("download.file.ok", f.getName()));
        }
    }
}

