/*
 * Decompiled with CFR 0.152.
 */
package com.mohistmc.banner.paper;

import java.math.BigDecimal;
import java.math.RoundingMode;

public class RollingAverage {
    private final int size;
    private long time;
    private BigDecimal total;
    private int index = 0;
    private final BigDecimal[] samples;
    private final long[] times;

    public RollingAverage(int size, int tps, long secInHand) {
        this.size = size;
        this.time = (long)size * secInHand;
        this.total = RollingAverage.dec(tps).multiply(RollingAverage.dec(secInHand)).multiply(RollingAverage.dec(size));
        this.samples = new BigDecimal[size];
        this.times = new long[size];
        for (int i = 0; i < size; ++i) {
            this.samples[i] = RollingAverage.dec(tps);
            this.times[i] = secInHand;
        }
    }

    private static BigDecimal dec(long t) {
        return new BigDecimal(t);
    }

    public void add(BigDecimal x, long t) {
        this.time -= this.times[this.index];
        this.total = this.total.subtract(this.samples[this.index].multiply(RollingAverage.dec(this.times[this.index])));
        this.samples[this.index] = x;
        this.times[this.index] = t;
        this.time = t;
        this.total = this.total.add(x.multiply(RollingAverage.dec(t)));
        if (this.index == this.size) {
            this.index = 0;
        }
    }

    public double getAverage() {
        return this.total.divide(RollingAverage.dec(this.time), 30, RoundingMode.HALF_UP).doubleValue();
    }
}

