/*
 * Decompiled with CFR 0.152.
 */
package com.mohistmc.banner.plugins;

import com.mohistmc.banner.config.BannerConfig;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.event.inventory.PrepareAnvilEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.EnchantmentStorageMeta;
import org.bukkit.inventory.meta.ItemMeta;

public class EnchantmentFix {
    public static void anvilListener(PrepareAnvilEvent e) {
        if (!BannerConfig.enchantment_fix) {
            return;
        }
        ItemStack is = e.getResult();
        if (is == null) {
            return;
        }
        ItemStack itemStack1 = e.getInventory().getItem(0);
        ItemStack itemStack2 = e.getInventory().getItem(1);
        if (itemStack1 == null || itemStack2 == null) {
            return;
        }
        Map<Enchantment, Integer> enchantments1 = EnchantmentFix.getEnchantments(itemStack1);
        Map<Enchantment, Integer> enchantments2 = EnchantmentFix.getEnchantments(itemStack2);
        HashMap<Enchantment, Integer> merged = new HashMap<Enchantment, Integer>();
        for (Map map : Arrays.asList(enchantments1, enchantments2)) {
            for (Map.Entry enchantmentIntegerEntry : map.entrySet()) {
                merged.merge((Enchantment)enchantmentIntegerEntry.getKey(), (Integer)enchantmentIntegerEntry.getValue(), EnchantmentFix::getUplevel);
            }
        }
        for (Map.Entry entry : EnchantmentFix.getEnchantments(is).entrySet()) {
            if (!merged.containsKey(entry.getKey())) continue;
            EnchantmentFix.setEnchantment(is, (Enchantment)entry.getKey(), (Integer)merged.get(entry.getKey()));
        }
    }

    private static void setEnchantment(ItemStack itemStack, Enchantment enchantment, int value) {
        if (enchantment.getMaxLevel() == 1) {
            return;
        }
        ItemMeta itemMeta = itemStack.getItemMeta();
        if (itemMeta instanceof EnchantmentStorageMeta) {
            EnchantmentStorageMeta enchantmentStorageMeta = (EnchantmentStorageMeta)itemMeta;
            enchantmentStorageMeta.removeStoredEnchant(enchantment);
            enchantmentStorageMeta.addStoredEnchant(enchantment, value, true);
            itemStack.setItemMeta(enchantmentStorageMeta);
            return;
        }
        itemStack.removeEnchantment(enchantment);
        itemStack.addUnsafeEnchantment(enchantment, value);
    }

    private static Map<Enchantment, Integer> getEnchantments(ItemStack itemStack) {
        ItemMeta itemMeta = itemStack.getItemMeta();
        if (itemMeta instanceof EnchantmentStorageMeta) {
            EnchantmentStorageMeta enchantmentStorageMeta = (EnchantmentStorageMeta)itemMeta;
            return enchantmentStorageMeta.getStoredEnchants();
        }
        return itemStack.getEnchantments();
    }

    private static int getUplevel(int a, int b) {
        return Math.min(BannerConfig.max_enchantment_level, EnchantmentFix.getUplevel0(a, b));
    }

    private static int getUplevel0(int a, int b) {
        if (a == b) {
            return a + 1;
        }
        return Math.max(a, b);
    }
}

