/*
 * Decompiled with CFR 0.152.
 */
package com.mohistmc.banner.stackdeobf.mappings.providers;

import com.google.common.base.Preconditions;
import com.mohistmc.banner.stackdeobf.util.CompatUtil;
import com.mohistmc.banner.util.I18n;
import java.io.IOException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.mappingio.MappingVisitor;

public abstract class AbstractMappingProvider {
    protected final String name;

    protected AbstractMappingProvider(String name) {
        this.name = name;
    }

    private static Path getCacheDir() {
        Path cacheDir = System.getProperties().containsKey("stackdeobf.mappings-cache-dir") ? Path.of(System.getProperty("stackdeobf.mappings-cache-dir"), new String[0]) : FabricLoader.getInstance().getGameDir().resolve("stackdeobf_mappings");
        if (Files.notExists(cacheDir, new LinkOption[0])) {
            try {
                Files.createDirectories(cacheDir, new FileAttribute[0]);
            }
            catch (IOException exception) {
                throw new RuntimeException(exception);
            }
        }
        Preconditions.checkState((boolean)Files.isDirectory(cacheDir, new LinkOption[0]), (Object)(cacheDir + " has to be a directory"));
        return cacheDir;
    }

    public CompletableFuture<Void> cacheMappings(MappingVisitor visitor, Executor executor) {
        Path cacheDir = AbstractMappingProvider.getCacheDir();
        return ((CompletableFuture)((CompletableFuture)CompletableFuture.completedFuture(null).thenComposeAsync($ -> this.downloadMappings(cacheDir, executor), executor)).thenCompose($ -> this.parseMappings(executor))).thenCompose($ -> this.visitMappings(visitor, executor));
    }

    /*
     * Enabled aggressive exception aggregation
     */
    protected byte[] extractPackagedMappings(byte[] jarBytes) {
        try {
            Path jarPath = Files.createTempFile(null, ".jar", new FileAttribute[0]);
            try {
                byte[] byArray;
                block11: {
                    Files.write(jarPath, jarBytes, new OpenOption[0]);
                    FileSystem jar = FileSystems.newFileSystem(jarPath);
                    try {
                        byArray = Files.readAllBytes(jar.getPath("mappings", "mappings.tiny"));
                        if (jar == null) break block11;
                    }
                    catch (Throwable throwable) {
                        if (jar != null) {
                            try {
                                jar.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    jar.close();
                }
                return byArray;
            }
            finally {
                Files.delete(jarPath);
            }
        }
        catch (IOException exception) {
            throw new RuntimeException(exception);
        }
    }

    private CompletableFuture<Long> trackTime(CompletableFuture<Void> future) {
        long start = System.currentTimeMillis();
        return future.thenApply($ -> System.currentTimeMillis() - start);
    }

    private CompletableFuture<Void> downloadMappings(Path cacheDir, Executor executor) {
        CompatUtil.LOGGER.info(I18n.as("stackdeobf.verifying"), (Object)this.name);
        return this.trackTime(this.downloadMappings0(cacheDir, executor)).thenAccept(timeDiff -> CompatUtil.LOGGER.info(I18n.as("stackdeobf.verified"), (Object)this.name, timeDiff));
    }

    private CompletableFuture<Void> parseMappings(Executor executor) {
        CompatUtil.LOGGER.info(I18n.as("stackdeobf.parsing"), (Object)this.name);
        return this.trackTime(this.parseMappings0(executor)).thenAccept(timeDiff -> CompatUtil.LOGGER.info(I18n.as("stackdeobf.parsed"), (Object)this.name, timeDiff));
    }

    private CompletableFuture<Void> visitMappings(MappingVisitor visitor, Executor executor) {
        CompatUtil.LOGGER.info(I18n.as("stackdeobf.caching"), (Object)this.name);
        return this.trackTime(this.visitMappings0(visitor, executor)).thenAccept(timeDiff -> CompatUtil.LOGGER.info(I18n.as("stackdeobf.cached"), (Object)this.name, timeDiff));
    }

    protected abstract CompletableFuture<Void> downloadMappings0(Path var1, Executor var2);

    protected abstract CompletableFuture<Void> parseMappings0(Executor var1);

    protected abstract CompletableFuture<Void> visitMappings0(MappingVisitor var1, Executor var2);

    public String getName() {
        return this.name;
    }
}

