/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_20_R1.block;

import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import javax.annotation.Nullable;
import net.minecraft.class_1936;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2573;
import net.minecraft.class_2580;
import net.minecraft.class_2586;
import net.minecraft.class_2587;
import net.minecraft.class_2589;
import net.minecraft.class_2593;
import net.minecraft.class_2595;
import net.minecraft.class_2597;
import net.minecraft.class_2599;
import net.minecraft.class_2601;
import net.minecraft.class_2603;
import net.minecraft.class_2605;
import net.minecraft.class_2608;
import net.minecraft.class_2611;
import net.minecraft.class_2614;
import net.minecraft.class_2619;
import net.minecraft.class_2625;
import net.minecraft.class_2627;
import net.minecraft.class_2631;
import net.minecraft.class_2633;
import net.minecraft.class_2636;
import net.minecraft.class_2640;
import net.minecraft.class_2643;
import net.minecraft.class_2646;
import net.minecraft.class_2669;
import net.minecraft.class_2680;
import net.minecraft.class_3719;
import net.minecraft.class_3720;
import net.minecraft.class_3721;
import net.minecraft.class_3722;
import net.minecraft.class_3723;
import net.minecraft.class_3751;
import net.minecraft.class_3866;
import net.minecraft.class_3924;
import net.minecraft.class_4482;
import net.minecraft.class_5704;
import net.minecraft.class_7132;
import net.minecraft.class_7133;
import net.minecraft.class_7716;
import net.minecraft.class_7717;
import net.minecraft.class_8174;
import net.minecraft.class_8239;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.craftbukkit.v1_20_R1.CraftWorld;
import org.bukkit.craftbukkit.v1_20_R1.block.CraftBanner;
import org.bukkit.craftbukkit.v1_20_R1.block.CraftBarrel;
import org.bukkit.craftbukkit.v1_20_R1.block.CraftBeacon;
import org.bukkit.craftbukkit.v1_20_R1.block.CraftBed;
import org.bukkit.craftbukkit.v1_20_R1.block.CraftBeehive;
import org.bukkit.craftbukkit.v1_20_R1.block.CraftBell;
import org.bukkit.craftbukkit.v1_20_R1.block.CraftBlastFurnace;
import org.bukkit.craftbukkit.v1_20_R1.block.CraftBlock;
import org.bukkit.craftbukkit.v1_20_R1.block.CraftBlockEntityState;
import org.bukkit.craftbukkit.v1_20_R1.block.CraftBlockState;
import org.bukkit.craftbukkit.v1_20_R1.block.CraftBrewingStand;
import org.bukkit.craftbukkit.v1_20_R1.block.CraftBrushableBlock;
import org.bukkit.craftbukkit.v1_20_R1.block.CraftCalibratedSculkSensor;
import org.bukkit.craftbukkit.v1_20_R1.block.CraftCampfire;
import org.bukkit.craftbukkit.v1_20_R1.block.CraftChest;
import org.bukkit.craftbukkit.v1_20_R1.block.CraftChiseledBookshelf;
import org.bukkit.craftbukkit.v1_20_R1.block.CraftCommandBlock;
import org.bukkit.craftbukkit.v1_20_R1.block.CraftComparator;
import org.bukkit.craftbukkit.v1_20_R1.block.CraftConduit;
import org.bukkit.craftbukkit.v1_20_R1.block.CraftCreatureSpawner;
import org.bukkit.craftbukkit.v1_20_R1.block.CraftDaylightDetector;
import org.bukkit.craftbukkit.v1_20_R1.block.CraftDispenser;
import org.bukkit.craftbukkit.v1_20_R1.block.CraftDropper;
import org.bukkit.craftbukkit.v1_20_R1.block.CraftEnchantingTable;
import org.bukkit.craftbukkit.v1_20_R1.block.CraftEndGateway;
import org.bukkit.craftbukkit.v1_20_R1.block.CraftEndPortal;
import org.bukkit.craftbukkit.v1_20_R1.block.CraftEnderChest;
import org.bukkit.craftbukkit.v1_20_R1.block.CraftFurnaceFurnace;
import org.bukkit.craftbukkit.v1_20_R1.block.CraftHangingSign;
import org.bukkit.craftbukkit.v1_20_R1.block.CraftHopper;
import org.bukkit.craftbukkit.v1_20_R1.block.CraftJigsaw;
import org.bukkit.craftbukkit.v1_20_R1.block.CraftJukebox;
import org.bukkit.craftbukkit.v1_20_R1.block.CraftLectern;
import org.bukkit.craftbukkit.v1_20_R1.block.CraftMovingPiston;
import org.bukkit.craftbukkit.v1_20_R1.block.CraftSculkCatalyst;
import org.bukkit.craftbukkit.v1_20_R1.block.CraftSculkSensor;
import org.bukkit.craftbukkit.v1_20_R1.block.CraftSculkShrieker;
import org.bukkit.craftbukkit.v1_20_R1.block.CraftShulkerBox;
import org.bukkit.craftbukkit.v1_20_R1.block.CraftSign;
import org.bukkit.craftbukkit.v1_20_R1.block.CraftSkull;
import org.bukkit.craftbukkit.v1_20_R1.block.CraftSmoker;
import org.bukkit.craftbukkit.v1_20_R1.block.CraftStructureBlock;
import org.bukkit.craftbukkit.v1_20_R1.block.CraftSuspiciousSand;
import org.bukkit.craftbukkit.v1_20_R1.util.CraftMagicNumbers;

public final class CraftBlockStates {
    private static final Map<Material, BlockStateFactory<?>> FACTORIES = new HashMap();
    private static final BlockStateFactory<?> DEFAULT_FACTORY = new BlockStateFactory<CraftBlockState>(CraftBlockState.class){

        @Override
        public CraftBlockState createBlockState(World world, class_2338 blockPosition, class_2680 blockData, class_2586 tileEntity) {
            if (tileEntity != null) {
                return new CraftBlockEntityState<class_2586>(world, tileEntity);
            }
            Preconditions.checkState((tileEntity == null ? 1 : 0) != 0, (String)"Unexpected BlockState for %s", (Object)CraftMagicNumbers.getMaterial(blockData.method_26204()));
            return new CraftBlockState(world, blockPosition, blockData);
        }
    };

    private static void register(Material blockType, BlockStateFactory<?> factory) {
        FACTORIES.put(blockType, factory);
    }

    public static <T extends class_2586, B extends CraftBlockEntityState<T>> void register(Material blockType, Class<B> blockStateType, BiFunction<World, T, B> blockStateConstructor, BiFunction<class_2338, class_2680, T> tileEntityConstructor) {
        CraftBlockStates.register(Collections.singletonList(blockType), blockStateType, blockStateConstructor, tileEntityConstructor);
    }

    private static <T extends class_2586, B extends CraftBlockEntityState<T>> void register(List<Material> blockTypes, Class<B> blockStateType, BiFunction<World, T, B> blockStateConstructor, BiFunction<class_2338, class_2680, T> tileEntityConstructor) {
        BlockEntityStateFactory<T, B> factory = new BlockEntityStateFactory<T, B>(blockStateType, blockStateConstructor, tileEntityConstructor);
        for (Material blockType : blockTypes) {
            CraftBlockStates.register(blockType, factory);
        }
    }

    private static BlockStateFactory<?> getFactory(Material material) {
        return FACTORIES.getOrDefault(material, DEFAULT_FACTORY);
    }

    public static Class<? extends CraftBlockState> getBlockStateType(Material material) {
        Preconditions.checkNotNull((Object)material, (Object)"material is null");
        return CraftBlockStates.getFactory((Material)material).blockStateType;
    }

    public static class_2586 createNewTileEntity(Material material) {
        BlockStateFactory<?> factory = CraftBlockStates.getFactory(material);
        if (factory instanceof BlockEntityStateFactory) {
            return ((BlockEntityStateFactory)factory).createTileEntity(class_2338.field_10980, CraftMagicNumbers.getBlock(material).method_9564());
        }
        return null;
    }

    public static BlockState getBlockState(Block block) {
        Preconditions.checkNotNull((Object)block, (Object)"block is null");
        CraftBlock craftBlock = (CraftBlock)block;
        CraftWorld world = (CraftWorld)block.getWorld();
        class_2338 blockPosition = craftBlock.getPosition();
        class_2680 blockData = craftBlock.getNMS();
        class_2586 tileEntity = craftBlock.getHandle().method_8321(blockPosition);
        CraftBlockState blockState = CraftBlockStates.getBlockState(world, blockPosition, blockData, tileEntity);
        blockState.setWorldHandle(craftBlock.getHandle());
        return blockState;
    }

    public static BlockState getBlockState(Material material, @Nullable class_2487 blockEntityTag) {
        return CraftBlockStates.getBlockState(class_2338.field_10980, material, blockEntityTag);
    }

    public static BlockState getBlockState(class_2338 blockPosition, Material material, @Nullable class_2487 blockEntityTag) {
        Preconditions.checkNotNull((Object)material, (Object)"material is null");
        class_2680 blockData = CraftMagicNumbers.getBlock(material).method_9564();
        return CraftBlockStates.getBlockState(blockPosition, blockData, blockEntityTag);
    }

    public static BlockState getBlockState(class_2680 blockData, @Nullable class_2487 blockEntityTag) {
        return CraftBlockStates.getBlockState(class_2338.field_10980, blockData, blockEntityTag);
    }

    public static BlockState getBlockState(class_2338 blockPosition, class_2680 blockData, @Nullable class_2487 blockEntityTag) {
        Preconditions.checkNotNull((Object)blockPosition, (Object)"blockPosition is null");
        Preconditions.checkNotNull((Object)blockData, (Object)"blockData is null");
        class_2586 tileEntity = blockEntityTag == null ? null : class_2586.method_11005((class_2338)blockPosition, (class_2680)blockData, (class_2487)blockEntityTag);
        return CraftBlockStates.getBlockState(null, blockPosition, blockData, tileEntity);
    }

    private static CraftBlockState getBlockState(World world, class_2338 blockPosition, class_2680 blockData, class_2586 tileEntity) {
        Material material = CraftMagicNumbers.getMaterial(blockData.method_26204());
        BlockStateFactory<?> factory = world != null && tileEntity == null && CraftBlockStates.isTileEntityOptional(material) ? DEFAULT_FACTORY : CraftBlockStates.getFactory(material);
        try {
            return factory.createBlockState(world, blockPosition, blockData, tileEntity);
        }
        catch (ClassCastException cce) {
            return DEFAULT_FACTORY.createBlockState(world, blockPosition, blockData, tileEntity);
        }
    }

    private static boolean isTileEntityOptional(Material material) {
        return material == Material.MOVING_PISTON;
    }

    public static CraftBlockState getBlockState(class_1936 world, class_2338 pos) {
        return new CraftBlockState(CraftBlock.at(world, pos));
    }

    public static CraftBlockState getBlockState(class_1936 world, class_2338 pos, int flag) {
        return new CraftBlockState(CraftBlock.at(world, pos), flag);
    }

    private CraftBlockStates() {
    }

    static {
        CraftBlockStates.register(Arrays.asList(Material.ACACIA_SIGN, Material.ACACIA_WALL_SIGN, Material.BAMBOO_SIGN, Material.BAMBOO_WALL_SIGN, Material.BIRCH_SIGN, Material.BIRCH_WALL_SIGN, Material.CHERRY_SIGN, Material.CHERRY_WALL_SIGN, Material.CRIMSON_SIGN, Material.CRIMSON_WALL_SIGN, Material.DARK_OAK_SIGN, Material.DARK_OAK_WALL_SIGN, Material.JUNGLE_SIGN, Material.JUNGLE_WALL_SIGN, Material.MANGROVE_SIGN, Material.MANGROVE_WALL_SIGN, Material.OAK_SIGN, Material.OAK_WALL_SIGN, Material.SPRUCE_SIGN, Material.SPRUCE_WALL_SIGN, Material.WARPED_SIGN, Material.WARPED_WALL_SIGN), CraftSign.class, CraftSign::new, class_2625::new);
        CraftBlockStates.register(Arrays.asList(Material.ACACIA_HANGING_SIGN, Material.ACACIA_WALL_HANGING_SIGN, Material.BAMBOO_HANGING_SIGN, Material.BAMBOO_WALL_HANGING_SIGN, Material.BIRCH_HANGING_SIGN, Material.BIRCH_WALL_HANGING_SIGN, Material.CHERRY_HANGING_SIGN, Material.CHERRY_WALL_HANGING_SIGN, Material.CRIMSON_HANGING_SIGN, Material.CRIMSON_WALL_HANGING_SIGN, Material.DARK_OAK_HANGING_SIGN, Material.DARK_OAK_WALL_HANGING_SIGN, Material.JUNGLE_HANGING_SIGN, Material.JUNGLE_WALL_HANGING_SIGN, Material.MANGROVE_HANGING_SIGN, Material.MANGROVE_WALL_HANGING_SIGN, Material.OAK_HANGING_SIGN, Material.OAK_WALL_HANGING_SIGN, Material.SPRUCE_HANGING_SIGN, Material.SPRUCE_WALL_HANGING_SIGN, Material.WARPED_HANGING_SIGN, Material.WARPED_WALL_HANGING_SIGN), CraftHangingSign.class, CraftHangingSign::new, class_7717::new);
        CraftBlockStates.register(Arrays.asList(Material.CREEPER_HEAD, Material.CREEPER_WALL_HEAD, Material.DRAGON_HEAD, Material.DRAGON_WALL_HEAD, Material.PIGLIN_HEAD, Material.PIGLIN_WALL_HEAD, Material.PLAYER_HEAD, Material.PLAYER_WALL_HEAD, Material.SKELETON_SKULL, Material.SKELETON_WALL_SKULL, Material.WITHER_SKELETON_SKULL, Material.WITHER_SKELETON_WALL_SKULL, Material.ZOMBIE_HEAD, Material.ZOMBIE_WALL_HEAD), CraftSkull.class, CraftSkull::new, class_2631::new);
        CraftBlockStates.register(Arrays.asList(Material.COMMAND_BLOCK, Material.REPEATING_COMMAND_BLOCK, Material.CHAIN_COMMAND_BLOCK), CraftCommandBlock.class, CraftCommandBlock::new, class_2593::new);
        CraftBlockStates.register(Arrays.asList(Material.BLACK_BANNER, Material.BLACK_WALL_BANNER, Material.BLUE_BANNER, Material.BLUE_WALL_BANNER, Material.BROWN_BANNER, Material.BROWN_WALL_BANNER, Material.CYAN_BANNER, Material.CYAN_WALL_BANNER, Material.GRAY_BANNER, Material.GRAY_WALL_BANNER, Material.GREEN_BANNER, Material.GREEN_WALL_BANNER, Material.LIGHT_BLUE_BANNER, Material.LIGHT_BLUE_WALL_BANNER, Material.LIGHT_GRAY_BANNER, Material.LIGHT_GRAY_WALL_BANNER, Material.LIME_BANNER, Material.LIME_WALL_BANNER, Material.MAGENTA_BANNER, Material.MAGENTA_WALL_BANNER, Material.ORANGE_BANNER, Material.ORANGE_WALL_BANNER, Material.PINK_BANNER, Material.PINK_WALL_BANNER, Material.PURPLE_BANNER, Material.PURPLE_WALL_BANNER, Material.RED_BANNER, Material.RED_WALL_BANNER, Material.WHITE_BANNER, Material.WHITE_WALL_BANNER, Material.YELLOW_BANNER, Material.YELLOW_WALL_BANNER), CraftBanner.class, CraftBanner::new, class_2573::new);
        CraftBlockStates.register(Arrays.asList(Material.SHULKER_BOX, Material.WHITE_SHULKER_BOX, Material.ORANGE_SHULKER_BOX, Material.MAGENTA_SHULKER_BOX, Material.LIGHT_BLUE_SHULKER_BOX, Material.YELLOW_SHULKER_BOX, Material.LIME_SHULKER_BOX, Material.PINK_SHULKER_BOX, Material.GRAY_SHULKER_BOX, Material.LIGHT_GRAY_SHULKER_BOX, Material.CYAN_SHULKER_BOX, Material.PURPLE_SHULKER_BOX, Material.BLUE_SHULKER_BOX, Material.BROWN_SHULKER_BOX, Material.GREEN_SHULKER_BOX, Material.RED_SHULKER_BOX, Material.BLACK_SHULKER_BOX), CraftShulkerBox.class, CraftShulkerBox::new, class_2627::new);
        CraftBlockStates.register(Arrays.asList(Material.BLACK_BED, Material.BLUE_BED, Material.BROWN_BED, Material.CYAN_BED, Material.GRAY_BED, Material.GREEN_BED, Material.LIGHT_BLUE_BED, Material.LIGHT_GRAY_BED, Material.LIME_BED, Material.MAGENTA_BED, Material.ORANGE_BED, Material.PINK_BED, Material.PURPLE_BED, Material.RED_BED, Material.WHITE_BED, Material.YELLOW_BED), CraftBed.class, CraftBed::new, class_2587::new);
        CraftBlockStates.register(Arrays.asList(Material.BEEHIVE, Material.BEE_NEST), CraftBeehive.class, CraftBeehive::new, class_4482::new);
        CraftBlockStates.register(Arrays.asList(Material.CAMPFIRE, Material.SOUL_CAMPFIRE), CraftCampfire.class, CraftCampfire::new, class_3924::new);
        CraftBlockStates.register(Material.BARREL, CraftBarrel.class, CraftBarrel::new, class_3719::new);
        CraftBlockStates.register(Material.BEACON, CraftBeacon.class, CraftBeacon::new, class_2580::new);
        CraftBlockStates.register(Material.BELL, CraftBell.class, CraftBell::new, class_3721::new);
        CraftBlockStates.register(Material.BLAST_FURNACE, CraftBlastFurnace.class, CraftBlastFurnace::new, class_3720::new);
        CraftBlockStates.register(Material.BREWING_STAND, CraftBrewingStand.class, CraftBrewingStand::new, class_2589::new);
        CraftBlockStates.register(Material.CHEST, CraftChest.class, CraftChest::new, class_2595::new);
        CraftBlockStates.register(Material.CHISELED_BOOKSHELF, CraftChiseledBookshelf.class, CraftChiseledBookshelf::new, class_7716::new);
        CraftBlockStates.register(Material.COMPARATOR, CraftComparator.class, CraftComparator::new, class_2599::new);
        CraftBlockStates.register(Material.CONDUIT, CraftConduit.class, CraftConduit::new, class_2597::new);
        CraftBlockStates.register(Material.DAYLIGHT_DETECTOR, CraftDaylightDetector.class, CraftDaylightDetector::new, class_2603::new);
        CraftBlockStates.register(Material.DISPENSER, CraftDispenser.class, CraftDispenser::new, class_2601::new);
        CraftBlockStates.register(Material.DROPPER, CraftDropper.class, CraftDropper::new, class_2608::new);
        CraftBlockStates.register(Material.ENCHANTING_TABLE, CraftEnchantingTable.class, CraftEnchantingTable::new, class_2605::new);
        CraftBlockStates.register(Material.ENDER_CHEST, CraftEnderChest.class, CraftEnderChest::new, class_2611::new);
        CraftBlockStates.register(Material.END_GATEWAY, CraftEndGateway.class, CraftEndGateway::new, class_2643::new);
        CraftBlockStates.register(Material.END_PORTAL, CraftEndPortal.class, CraftEndPortal::new, class_2640::new);
        CraftBlockStates.register(Material.FURNACE, CraftFurnaceFurnace.class, CraftFurnaceFurnace::new, class_3866::new);
        CraftBlockStates.register(Material.HOPPER, CraftHopper.class, CraftHopper::new, class_2614::new);
        CraftBlockStates.register(Material.JIGSAW, CraftJigsaw.class, CraftJigsaw::new, class_3751::new);
        CraftBlockStates.register(Material.JUKEBOX, CraftJukebox.class, CraftJukebox::new, class_2619::new);
        CraftBlockStates.register(Material.LECTERN, CraftLectern.class, CraftLectern::new, class_3722::new);
        CraftBlockStates.register(Material.MOVING_PISTON, CraftMovingPiston.class, CraftMovingPiston::new, class_2669::new);
        CraftBlockStates.register(Material.SCULK_CATALYST, CraftSculkCatalyst.class, CraftSculkCatalyst::new, class_7132::new);
        CraftBlockStates.register(Material.CALIBRATED_SCULK_SENSOR, CraftCalibratedSculkSensor.class, CraftCalibratedSculkSensor::new, class_8239::new);
        CraftBlockStates.register(Material.SCULK_SENSOR, CraftSculkSensor.class, CraftSculkSensor::new, class_5704::new);
        CraftBlockStates.register(Material.SCULK_SHRIEKER, CraftSculkShrieker.class, CraftSculkShrieker::new, class_7133::new);
        CraftBlockStates.register(Material.SMOKER, CraftSmoker.class, CraftSmoker::new, class_3723::new);
        CraftBlockStates.register(Material.SPAWNER, CraftCreatureSpawner.class, CraftCreatureSpawner::new, class_2636::new);
        CraftBlockStates.register(Material.STRUCTURE_BLOCK, CraftStructureBlock.class, CraftStructureBlock::new, class_2633::new);
        CraftBlockStates.register(Material.SUSPICIOUS_SAND, CraftSuspiciousSand.class, CraftSuspiciousSand::new, class_8174::new);
        CraftBlockStates.register(Material.SUSPICIOUS_GRAVEL, CraftBrushableBlock.class, CraftBrushableBlock::new, class_8174::new);
        CraftBlockStates.register(Material.TRAPPED_CHEST, CraftChest.class, CraftChest::new, class_2646::new);
    }

    private static class BlockEntityStateFactory<T extends class_2586, B extends CraftBlockEntityState<T>>
    extends BlockStateFactory<B> {
        private final BiFunction<World, T, B> blockStateConstructor;
        private final BiFunction<class_2338, class_2680, T> tileEntityConstructor;

        protected BlockEntityStateFactory(Class<B> blockStateType, BiFunction<World, T, B> blockStateConstructor, BiFunction<class_2338, class_2680, T> tileEntityConstructor) {
            super(blockStateType);
            this.blockStateConstructor = blockStateConstructor;
            this.tileEntityConstructor = tileEntityConstructor;
        }

        @Override
        public final B createBlockState(World world, class_2338 blockPosition, class_2680 blockData, class_2586 tileEntity) {
            if (world != null) {
                Preconditions.checkState((tileEntity != null ? 1 : 0) != 0, (String)"Tile is null, asynchronous access? %s", (Object)CraftBlock.at((class_1936)((CraftWorld)world).getHandle(), blockPosition));
            } else if (tileEntity == null) {
                tileEntity = this.createTileEntity(blockPosition, blockData);
            }
            return this.createBlockState(world, tileEntity);
        }

        private T createTileEntity(class_2338 blockPosition, class_2680 blockData) {
            return (T)((class_2586)this.tileEntityConstructor.apply(blockPosition, blockData));
        }

        private B createBlockState(World world, T tileEntity) {
            return (B)((CraftBlockEntityState)this.blockStateConstructor.apply(world, (World)tileEntity));
        }
    }

    private static abstract class BlockStateFactory<B extends CraftBlockState> {
        public final Class<B> blockStateType;

        public BlockStateFactory(Class<B> blockStateType) {
            this.blockStateType = blockStateType;
        }

        public abstract B createBlockState(World var1, class_2338 var2, class_2680 var3, class_2586 var4);
    }
}

